/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.common;

import com.aliyun.common.models.ErrorResponse;
import com.aliyun.common.utils.XmlUtil;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.utils.StringUtils;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class Common {
    public static final String defaultUserAgent;
    public static final String SEPARATOR = "&";
    public static final String URL_ENCODING = "UTF-8";
    public static final String ALGORITHM_NAME = "HmacSHA1";
    public static final String coreVersion = "0.1.0";

    public static Map<String, String> query(Map<String, ?> map) {
        HashMap<String, String> outMap = new HashMap<String, String>();
        if (null != map) {
            Common.processeObject(outMap, "", map);
        }
        return outMap;
    }

    private static void processeObject(Map<String, String> map, String key, Object value) {
        if (StringUtils.isEmpty(value)) {
            return;
        }
        if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                Common.processeObject(map, key + "." + (i + 1), list.get(i));
            }
        } else if (value instanceof Map) {
            Map subMap = (Map)value;
            for (Map.Entry entry : subMap.entrySet()) {
                Common.processeObject(map, key + "." + (String)entry.getKey(), entry.getValue());
            }
        } else {
            if (key.startsWith(".")) {
                key = key.substring(1);
            }
            map.put(key, String.valueOf(value));
        }
    }

    public static String readAsString(InputStream input) {
        try {
            int index;
            if (input == null) {
                return "";
            }
            byte[] bcache = new byte[4096];
            ByteArrayOutputStream infoStream = new ByteArrayOutputStream();
            while ((index = input.read(bcache)) > 0) {
                infoStream.write(bcache, 0, index);
            }
            return infoStream.toString(URL_ENCODING);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getEndpoint(String endpoint, boolean useAccelerate, String endpointType) {
        if ("internal".equals(endpointType)) {
            String[] strs = endpoint.split("\\.");
            strs[0] = strs[0] + "-internal";
            endpoint = StringUtils.join(".", Arrays.asList(strs));
        }
        if (useAccelerate && "accelerate".equals(endpointType)) {
            return "oss-accelerate.aliyuncs.com";
        }
        return endpoint;
    }

    public static boolean equal(String hostModel, String ip) {
        if (hostModel == null || ip == null) {
            return false;
        }
        return hostModel.equals(ip);
    }

    public static boolean empty(String bucketName) {
        return StringUtils.isEmpty(bucketName);
    }

    public static Map<String, Object> parseXml(String bodyStr, Class<?> clazz) {
        try {
            return XmlUtil.DeserializeXml(bodyStr, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> getErrMessage(String bodyStr) {
        Map result = null;
        try {
            result = XmlUtil.DeserializeXml(bodyStr, ErrorResponse.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        result = result.get("Error") == null ? result : (Map)result.get("Error");
        return result;
    }

    public static boolean isFail(TeaResponse response_) {
        if (null == response_) {
            return false;
        }
        return 200 > response_.statusCode || 300 <= response_.statusCode;
    }

    public static InputStream toForm(Map<String, ?> map, InputStream sourceFile, String boundary) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (null == map) {
            return sourceFile;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object file = map.remove("file");
        if (!StringUtils.isEmpty(map.get("UserMeta"))) {
            Map userMeta = (Map)map.remove("UserMeta");
            for (Map.Entry meta : userMeta.entrySet()) {
                stringBuilder.append("--").append(boundary).append("\r\n");
                stringBuilder.append("Content-Disposition: form-data; name=\"x-oss-meta-").append((String)meta.getKey()).append("\"\r\n\r\n");
                stringBuilder.append((String)meta.getValue()).append("\r\n");
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            if (StringUtils.isEmpty(entry.getValue())) continue;
            stringBuilder.append("--").append(boundary).append("\r\n");
            stringBuilder.append("Content-Disposition: form-data; name=\"").append((String)entry.getKey()).append("\"\r\n\r\n");
            stringBuilder.append(entry.getValue()).append("\r\n");
        }
        try {
            if (null != file) {
                int n;
                Map<String, Object> headerFile = ((TeaModel)file).toMap();
                stringBuilder.append("--").append(boundary).append("\r\n");
                stringBuilder.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(headerFile.get("filename")).append("\"\r\n");
                stringBuilder.append("Content-Type: ").append(headerFile.get("content-type")).append("\r\n\r\n");
                os.write(stringBuilder.toString().getBytes(URL_ENCODING));
                byte[] bufferOut = new byte[4096];
                while ((n = sourceFile.read(bufferOut)) != -1) {
                    ((OutputStream)os).write(bufferOut, 0, n);
                }
                sourceFile.close();
                os.write("\r\n".getBytes(URL_ENCODING));
            } else {
                os.write(stringBuilder.toString().getBytes(URL_ENCODING));
            }
            byte[] endData = ("--" + boundary + "--\r\n").getBytes();
            os.write(endData);
            os.flush();
            byte[] byArray = os.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(byArray);
            return is;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return simpleDateFormat.format(new Date());
    }

    public static String getBoundary() {
        double num = Math.random() * 1.0E14;
        return String.format("%014d", (long)num);
    }

    public static Number defaultNumber(Integer maxAttempts, long defaultNumber) {
        if (maxAttempts != null && maxAttempts >= 0) {
            return maxAttempts;
        }
        return defaultNumber;
    }

    public static String _default(String maxAttempts, String defaultStr) {
        if (!StringUtils.isEmpty(maxAttempts)) {
            return maxAttempts;
        }
        return defaultStr;
    }

    public static String getTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "UTC"));
        return df.format(new Date());
    }

    public static String getNonce() {
        StringBuffer uniqueNonce = new StringBuffer();
        UUID uuid = UUID.randomUUID();
        uniqueNonce.append(uuid.toString());
        uniqueNonce.append(System.currentTimeMillis());
        uniqueNonce.append(Thread.currentThread().getId());
        return uniqueNonce.toString();
    }

    public static String getUserAgent() {
        return Common.getUserAgent(null);
    }

    public static String getUserAgent(String a) {
        if (StringUtils.isEmpty(a)) {
            return defaultUserAgent;
        }
        return defaultUserAgent + " " + a;
    }

    public static String getSignature(TeaRequest request, String secret) {
        return Common.getSignature(request.query, request.method, secret);
    }

    public static String percentEncode(String value) {
        try {
            return value != null ? URLEncoder.encode(value, URL_ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getHost(String str, String regionId, String _endpoint) {
        if (null == _endpoint) {
            String serviceCode = str.split("\\_")[0].toLowerCase();
            return String.format("%s.%s.aliyuncs.com", serviceCode, regionId);
        }
        return _endpoint;
    }

    public static Map<String, Object> json(TeaResponse response) {
        Gson gson = new Gson();
        Map map = null;
        try {
            map = gson.fromJson(response.getResponseBody(), Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public static boolean hasError(Map<String, ?> body) {
        if (null == body) {
            return true;
        }
        try {
            Object resultCode = body.get("Code");
            if (null == resultCode) {
                return false;
            }
            String code = String.valueOf(resultCode);
            return Double.parseDouble(code) > 0.0;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void convert(TeaModel source, TeaModel target) {
        if (source == null || target == null) {
            return;
        }
        try {
            Class<?> sourceClass = source.getClass();
            Class<?> targetClass = target.getClass();
            Field[] fields = sourceClass.getDeclaredFields();
            TeaModel teaModel = (TeaModel)sourceClass.newInstance();
            for (Field field : fields) {
                field.setAccessible(true);
                if (InputStream.class.isAssignableFrom(field.getType())) continue;
                field.set(teaModel, field.get(source));
            }
            Gson gson = new Gson();
            String jsonString = gson.toJson(teaModel);
            Object outPut = gson.fromJson(jsonString, targetClass);
            for (Field field : fields = outPut.getClass().getFields()) {
                field.setAccessible(true);
                field.set(target, field.get(outPut));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getOpenPlatFormEndpoint(String endpoint, String regionId) {
        if (StringUtils.isEmpty(regionId)) {
            return endpoint;
        }
        List<String> regionIds = Arrays.asList("ap-southeast-1", "ap-northeast-1", "eu-central-1", "cn-hongkong", "ap-south-1");
        boolean ifExist = false;
        for (String region : regionIds) {
            if (!region.equals(regionId.toLowerCase())) continue;
            ifExist = true;
        }
        if (ifExist) {
            String[] strs = endpoint.split("\\.");
            strs[0] = strs[0] + "." + regionId;
            return StringUtils.join(".", Arrays.asList(strs));
        }
        return endpoint;
    }

    public static String getSignatureV1(Map<String, String> signedParams, String method, String secret) {
        return Common.getSignature(signedParams, method, secret);
    }

    private static String getSignature(Map<String, String> signedParams, String method, String secret) {
        Map<String, String> queries = signedParams;
        Object[] sortedKeys = queries.keySet().toArray(new String[0]);
        Arrays.sort(sortedKeys);
        StringBuilder canonicalizedQueryString = new StringBuilder();
        for (Object key : sortedKeys) {
            if (StringUtils.isEmpty(queries.get(key))) continue;
            canonicalizedQueryString.append(SEPARATOR).append(Common.percentEncode((String)key)).append("=").append(Common.percentEncode(queries.get(key)));
        }
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(method);
        stringToSign.append(SEPARATOR);
        stringToSign.append(Common.percentEncode("/"));
        stringToSign.append(SEPARATOR);
        stringToSign.append(Common.percentEncode(canonicalizedQueryString.toString().substring(1)));
        try {
            Mac mac = Mac.getInstance(ALGORITHM_NAME);
            mac.init(new SecretKeySpec((secret + SEPARATOR).getBytes(URL_ENCODING), ALGORITHM_NAME));
            byte[] signData = mac.doFinal(stringToSign.toString().getBytes(URL_ENCODING));
            return DatatypeConverter.printBase64Binary(signData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Properties sysProps = System.getProperties();
        defaultUserAgent = String.format("AlibabaCloud (%s; %s) Java/%s %s/%s TeaDSL/1", sysProps.getProperty("os.name"), sysProps.getProperty("os.arch"), sysProps.getProperty("java.runtime.version"), "Common", coreVersion);
    }
}

