/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands.ide;

import com.mks.api.CmdRunnerCreator;
import com.mks.api.commands.ide.SandboxInfo;
import com.mks.api.commands.ide.WorkingDirectory;
import com.mks.api.commands.ide.WorkingDirectoryFactory;
import com.mks.api.commands.ide.WorkingFile;
import com.mks.api.commands.ide.WorkingFileCache;
import com.mks.api.commands.ide.WorkingFileFactory;
import com.mks.api.response.APIError;
import com.mks.api.response.APIException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class WorkingFileList {
    private List list;

    public WorkingFileList() {
    }

    public WorkingFileList(WorkingFile[] wfArray) {
        this();
        this.add(wfArray);
    }

    public synchronized void add(WorkingFile wf) {
        if (this.list == null) {
            this.list = new ArrayList(1);
        }
        this.list.add(wf);
    }

    public void add(WorkingFile[] array) {
        for (int i = 0; i < array.length; ++i) {
            this.add(array[i]);
        }
    }

    public Iterator iterator() {
        return this.getList().iterator();
    }

    public int size() {
        return this.getList().size();
    }

    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    public synchronized List getList() {
        return this.list == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.list);
    }

    public Map getWorkingFileBuckets() {
        try {
            return this.getWorkingFileBuckets(null, null);
        }
        catch (APIException err) {
            throw new APIError(err);
        }
    }

    public Map getWorkingFileBuckets(CmdRunnerCreator session, File preferredRootSandbox) throws APIException {
        HashMap<File, WorkingDirectory> wdMap = new HashMap<File, WorkingDirectory>();
        HashMap<File, WorkingFileList> workingFileBuckets = new HashMap<File, WorkingFileList>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            WorkingFile wf = (WorkingFile)i.next();
            if (!wf.isInSandboxDir()) continue;
            File root = wf.getWorkingRoot();
            if (root == null && preferredRootSandbox != null) {
                File wfDir = wf.getFile().getParentFile();
                WorkingDirectory wd = (WorkingDirectory)wdMap.get(wfDir);
                if (wd == null) {
                    wd = WorkingDirectoryFactory.getWorkingDirectory(session, wfDir);
                    wdMap.put(wfDir, wd);
                }
                if (wd.isAmbiguous()) {
                    Iterator sandboxes = wd.getSandboxes().iterator();
                    while (sandboxes.hasNext()) {
                        SandboxInfo sandbox = (SandboxInfo)sandboxes.next();
                        if (!sandbox.isRelatedTo(session, preferredRootSandbox)) continue;
                        root = sandbox.getSandboxFile();
                        break;
                    }
                } else {
                    root = wd.getSandboxLocation();
                }
            }
            if (root == null) continue;
            WorkingFileList bucket = (WorkingFileList)workingFileBuckets.get(root);
            if (bucket == null) {
                bucket = new WorkingFileList();
                workingFileBuckets.put(root, bucket);
            }
            bucket.add(wf);
        }
        return workingFileBuckets;
    }

    List getFileList() {
        ArrayList<File> fileList = new ArrayList<File>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            WorkingFile wf = (WorkingFile)i.next();
            fileList.add(wf.getFile());
        }
        return fileList;
    }

    public List getMemberList() {
        ArrayList<File> fileList = new ArrayList<File>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            WorkingFile wf = (WorkingFile)i.next();
            fileList.add(wf.getMemberName());
        }
        return fileList;
    }

    public void invalidate() {
        WorkingFileCache wfCache = WorkingFileCache.getInstance();
        wfCache.invalidate(this, WorkingFileFactory.getNewOrdinal());
    }
}

