/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NTLM {
    private byte[] currentResponse;
    private int currentPosition = 0;
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$NTLM == null ? (class$org$apache$commons$httpclient$NTLM = NTLM.class$("org.apache.commons.httpclient.NTLM")) : class$org$apache$commons$httpclient$NTLM);
    public static final String DEFAULT_CHARSET = "ASCII";
    static /* synthetic */ Class class$org$apache$commons$httpclient$NTLM;

    public final String getResponseFor(String message, String username, String password, String host, String domain) throws HttpException {
        String response = message == null || message.trim().equals("") ? this.getType1Message(host, domain) : this.getType3Message(username, password, host, domain, this.parseType2Message(message));
        return response;
    }

    private Cipher getCipher(byte[] key) throws HttpException {
        try {
            Cipher ecipher = Cipher.getInstance("DES/ECB/NoPadding");
            key = this.setupKey(key);
            ecipher.init(1, new SecretKeySpec(key, "DES"));
            return ecipher;
        }
        catch (NoSuchAlgorithmException e) {
            throw new HttpException("DES encryption is not available.");
        }
        catch (InvalidKeyException e) {
            throw new HttpException("Invalid key for DES encryption.");
        }
        catch (NoSuchPaddingException e) {
            throw new HttpException("NoPadding option for DES is not available.");
        }
    }

    private byte[] setupKey(byte[] key56) {
        byte[] key = new byte[]{(byte)(key56[0] >> 1 & 0xFF), (byte)(((key56[0] & 1) << 6 | (key56[1] & 0xFF) >> 2 & 0xFF) & 0xFF), (byte)(((key56[1] & 3) << 5 | (key56[2] & 0xFF) >> 3 & 0xFF) & 0xFF), (byte)(((key56[2] & 7) << 4 | (key56[3] & 0xFF) >> 4 & 0xFF) & 0xFF), (byte)(((key56[3] & 0xF) << 3 | (key56[4] & 0xFF) >> 5 & 0xFF) & 0xFF), (byte)(((key56[4] & 0x1F) << 2 | (key56[5] & 0xFF) >> 6 & 0xFF) & 0xFF), (byte)(((key56[5] & 0x3F) << 1 | (key56[6] & 0xFF) >> 7 & 0xFF) & 0xFF), (byte)(key56[6] & 0x7F)};
        int i = 0;
        while (i < key.length) {
            key[i] = (byte)(key[i] << 1);
            ++i;
        }
        return key;
    }

    private byte[] encrypt(byte[] key, byte[] bytes) throws HttpException {
        Cipher ecipher = this.getCipher(key);
        try {
            byte[] enc = ecipher.doFinal(bytes);
            return enc;
        }
        catch (IllegalBlockSizeException e) {
            throw new HttpException("Invalid block size for DES encryption.");
        }
        catch (BadPaddingException e) {
            throw new HttpException("Data not padded correctly for DES encryption.");
        }
    }

    private void prepareResponse(int length) {
        this.currentResponse = new byte[length];
        this.currentPosition = 0;
    }

    private void addByte(byte b) {
        this.currentResponse[this.currentPosition] = b;
        ++this.currentPosition;
    }

    private void addBytes(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            this.currentResponse[this.currentPosition] = bytes[i];
            ++this.currentPosition;
            ++i;
        }
    }

    private String getResponse() {
        byte[] resp;
        if (this.currentResponse.length > this.currentPosition) {
            byte[] tmp = new byte[this.currentPosition];
            int i = 0;
            while (i < this.currentPosition) {
                tmp[i] = this.currentResponse[i];
                ++i;
            }
            resp = tmp;
        } else {
            resp = this.currentResponse;
        }
        return HttpConstants.getString(Base64.encode(resp));
    }

    private String getType1Message(String host, String domain) {
        host = host.toUpperCase();
        domain = domain.toUpperCase();
        byte[] hostBytes = NTLM.getBytes(host);
        byte[] domainBytes = NTLM.getBytes(domain);
        int finalLength = 32 + hostBytes.length + domainBytes.length;
        this.prepareResponse(finalLength);
        byte[] protocol = NTLM.getBytes("NTLMSSP");
        this.addBytes(protocol);
        this.addByte((byte)0);
        this.addByte((byte)1);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)6);
        this.addByte((byte)82);
        this.addByte((byte)0);
        this.addByte((byte)0);
        int iDomLen = domainBytes.length;
        byte[] domLen = this.convertShort(iDomLen);
        this.addByte(domLen[0]);
        this.addByte(domLen[1]);
        this.addByte(domLen[0]);
        this.addByte(domLen[1]);
        byte[] domOff = this.convertShort(hostBytes.length + 32);
        this.addByte(domOff[0]);
        this.addByte(domOff[1]);
        this.addByte((byte)0);
        this.addByte((byte)0);
        byte[] hostLen = this.convertShort(hostBytes.length);
        this.addByte(hostLen[0]);
        this.addByte(hostLen[1]);
        this.addByte(hostLen[0]);
        this.addByte(hostLen[1]);
        byte[] hostOff = this.convertShort(32);
        this.addByte(hostOff[0]);
        this.addByte(hostOff[1]);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(hostBytes);
        this.addBytes(domainBytes);
        return this.getResponse();
    }

    private byte[] parseType2Message(String message) {
        byte[] msg = Base64.decode(NTLM.getBytes(message));
        byte[] nonce = new byte[8];
        int i = 0;
        while (i < 8) {
            nonce[i] = msg[i + 24];
            ++i;
        }
        return nonce;
    }

    private String getType3Message(String user, String password, String host, String domain, byte[] nonce) throws HttpException {
        int ntRespLen = 0;
        int lmRespLen = 24;
        domain = domain.toUpperCase();
        host = host.toUpperCase();
        user = user.toUpperCase();
        byte[] domainBytes = NTLM.getBytes(domain);
        byte[] hostBytes = NTLM.getBytes(host);
        byte[] userBytes = NTLM.getBytes(user);
        int domainLen = domainBytes.length;
        int hostLen = hostBytes.length;
        int userLen = userBytes.length;
        int finalLength = 64 + ntRespLen + lmRespLen + domainLen + userLen + hostLen;
        this.prepareResponse(finalLength);
        byte[] ntlmssp = NTLM.getBytes("NTLMSSP");
        this.addBytes(ntlmssp);
        this.addByte((byte)0);
        this.addByte((byte)3);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(24));
        this.addBytes(this.convertShort(24));
        this.addBytes(this.convertShort(finalLength - 24));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(0));
        this.addBytes(this.convertShort(0));
        this.addBytes(this.convertShort(finalLength));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(domainLen));
        this.addBytes(this.convertShort(domainLen));
        this.addBytes(this.convertShort(64));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(userLen));
        this.addBytes(this.convertShort(userLen));
        this.addBytes(this.convertShort(64 + domainLen));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(hostLen));
        this.addBytes(this.convertShort(hostLen));
        this.addBytes(this.convertShort(64 + domainLen + userLen));
        int i = 0;
        while (i < 6) {
            this.addByte((byte)0);
            ++i;
        }
        this.addBytes(this.convertShort(finalLength));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)6);
        this.addByte((byte)82);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(domainBytes);
        this.addBytes(userBytes);
        this.addBytes(hostBytes);
        this.addBytes(this.hashPassword(password, nonce));
        return this.getResponse();
    }

    private byte[] hashPassword(String password, byte[] nonce) throws HttpException {
        byte[] passw = NTLM.getBytes(password.toUpperCase());
        byte[] lmPw1 = new byte[7];
        byte[] lmPw2 = new byte[7];
        int len = passw.length;
        if (len > 7) {
            len = 7;
        }
        int idx = 0;
        while (idx < len) {
            lmPw1[idx] = passw[idx];
            ++idx;
        }
        while (idx < 7) {
            lmPw1[idx] = 0;
            ++idx;
        }
        len = passw.length;
        if (len > 14) {
            len = 14;
        }
        idx = 7;
        while (idx < len) {
            lmPw2[idx - 7] = passw[idx];
            ++idx;
        }
        while (idx < 14) {
            lmPw2[idx - 7] = 0;
            ++idx;
        }
        byte[] magic = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
        byte[] lmHpw1 = this.encrypt(lmPw1, magic);
        byte[] lmHpw2 = this.encrypt(lmPw2, magic);
        byte[] lmHpw = new byte[21];
        int i = 0;
        while (i < lmHpw1.length) {
            lmHpw[i] = lmHpw1[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < lmHpw2.length) {
            lmHpw[i2 + 8] = lmHpw2[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < 5) {
            lmHpw[i3 + 16] = 0;
            ++i3;
        }
        byte[] lmResp = new byte[24];
        this.calcResp(lmHpw, nonce, lmResp);
        return lmResp;
    }

    private void calcResp(byte[] keys, byte[] plaintext, byte[] results) throws HttpException {
        byte[] keys1 = new byte[7];
        byte[] keys2 = new byte[7];
        byte[] keys3 = new byte[7];
        int i = 0;
        while (i < 7) {
            keys1[i] = keys[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < 7) {
            keys2[i2] = keys[i2 + 7];
            ++i2;
        }
        int i3 = 0;
        while (i3 < 7) {
            keys3[i3] = keys[i3 + 14];
            ++i3;
        }
        byte[] results1 = this.encrypt(keys1, plaintext);
        byte[] results2 = this.encrypt(keys2, plaintext);
        byte[] results3 = this.encrypt(keys3, plaintext);
        int i4 = 0;
        while (i4 < 8) {
            results[i4] = results1[i4];
            ++i4;
        }
        int i5 = 0;
        while (i5 < 8) {
            results[i5 + 8] = results2[i5];
            ++i5;
        }
        int i6 = 0;
        while (i6 < 8) {
            results[i6 + 16] = results3[i6];
            ++i6;
        }
    }

    private byte[] convertShort(int num) {
        byte[] val = new byte[2];
        String hex = Integer.toString(num, 16);
        while (hex.length() < 4) {
            hex = "0" + hex;
        }
        String low = hex.substring(2, 4);
        String high = hex.substring(0, 2);
        val[0] = (byte)Integer.parseInt(low, 16);
        val[1] = (byte)Integer.parseInt(high, 16);
        return val;
    }

    private static byte[] getBytes(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return s.getBytes(DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException unexpectedEncodingException) {
            throw new RuntimeException("NTLM requires ASCII support");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

