/*
 * Decompiled with CFR 0.152.
 */
package vipapis.brand;

import com.vip.hermes.core.health.CheckResult;
import com.vip.hermes.core.health.CheckResultHelper;
import com.vip.osp.sdk.base.OspRestStub;
import com.vip.osp.sdk.base.TBeanSerializer;
import com.vip.osp.sdk.exception.OspException;
import com.vip.osp.sdk.protocol.Protocol;
import java.util.ArrayList;
import java.util.List;
import vipapis.brand.BrandInfo;
import vipapis.brand.BrandInfoHelper;
import vipapis.brand.BrandSearchType;
import vipapis.brand.BrandService;
import vipapis.brand.BrandStory;
import vipapis.brand.BrandStoryHelper;
import vipapis.brand.MultiGetBrandResponse;
import vipapis.brand.MultiGetBrandResponseHelper;
import vipapis.brand.VendorBrandRelationShip;
import vipapis.brand.VendorBrandRelationShipHelper;

public class BrandServiceHelper {

    public static class BrandServiceClient
    extends OspRestStub
    implements BrandService {
        public BrandServiceClient() {
            super("1.0.0", "vipapis.brand.BrandService");
        }

        @Override
        public BrandInfo getBrandInfo(String brand_id) throws OspException {
            this.send_getBrandInfo(brand_id);
            return this.recv_getBrandInfo();
        }

        private void send_getBrandInfo(String brand_id) throws OspException {
            this.initInvocation("getBrandInfo");
            getBrandInfo_args args = new getBrandInfo_args();
            args.setBrand_id(brand_id);
            this.sendBase(args, getBrandInfo_argsHelper.getInstance());
        }

        private BrandInfo recv_getBrandInfo() throws OspException {
            getBrandInfo_result result = new getBrandInfo_result();
            this.receiveBase(result, getBrandInfo_resultHelper.getInstance());
            return result.getSuccess();
        }

        @Override
        public List<BrandStory> getBrandStories(List<Integer> brand_ids) throws OspException {
            this.send_getBrandStories(brand_ids);
            return this.recv_getBrandStories();
        }

        private void send_getBrandStories(List<Integer> brand_ids) throws OspException {
            this.initInvocation("getBrandStories");
            getBrandStories_args args = new getBrandStories_args();
            args.setBrand_ids(brand_ids);
            this.sendBase(args, getBrandStories_argsHelper.getInstance());
        }

        private List<BrandStory> recv_getBrandStories() throws OspException {
            getBrandStories_result result = new getBrandStories_result();
            this.receiveBase(result, getBrandStories_resultHelper.getInstance());
            return result.getSuccess();
        }

        @Override
        public List<VendorBrandRelationShip> getVendorBrandRelationshipByVendorId(int vendor_id) throws OspException {
            this.send_getVendorBrandRelationshipByVendorId(vendor_id);
            return this.recv_getVendorBrandRelationshipByVendorId();
        }

        private void send_getVendorBrandRelationshipByVendorId(int vendor_id) throws OspException {
            this.initInvocation("getVendorBrandRelationshipByVendorId");
            getVendorBrandRelationshipByVendorId_args args = new getVendorBrandRelationshipByVendorId_args();
            args.setVendor_id(vendor_id);
            this.sendBase(args, getVendorBrandRelationshipByVendorId_argsHelper.getInstance());
        }

        private List<VendorBrandRelationShip> recv_getVendorBrandRelationshipByVendorId() throws OspException {
            getVendorBrandRelationshipByVendorId_result result = new getVendorBrandRelationshipByVendorId_result();
            this.receiveBase(result, getVendorBrandRelationshipByVendorId_resultHelper.getInstance());
            return result.getSuccess();
        }

        @Override
        public CheckResult healthCheck() throws OspException {
            this.send_healthCheck();
            return this.recv_healthCheck();
        }

        private void send_healthCheck() throws OspException {
            this.initInvocation("healthCheck");
            healthCheck_args args = new healthCheck_args();
            this.sendBase(args, healthCheck_argsHelper.getInstance());
        }

        private CheckResult recv_healthCheck() throws OspException {
            healthCheck_result result = new healthCheck_result();
            this.receiveBase(result, healthCheck_resultHelper.getInstance());
            return result.getSuccess();
        }

        @Override
        public MultiGetBrandResponse multiGetBrand(BrandSearchType search_type, String word, Integer page, Integer limit) throws OspException {
            this.send_multiGetBrand(search_type, word, page, limit);
            return this.recv_multiGetBrand();
        }

        private void send_multiGetBrand(BrandSearchType search_type, String word, Integer page, Integer limit) throws OspException {
            this.initInvocation("multiGetBrand");
            multiGetBrand_args args = new multiGetBrand_args();
            args.setSearch_type(search_type);
            args.setWord(word);
            args.setPage(page);
            args.setLimit(limit);
            this.sendBase(args, multiGetBrand_argsHelper.getInstance());
        }

        private MultiGetBrandResponse recv_multiGetBrand() throws OspException {
            multiGetBrand_result result = new multiGetBrand_result();
            this.receiveBase(result, multiGetBrand_resultHelper.getInstance());
            return result.getSuccess();
        }
    }

    public static class multiGetBrand_resultHelper
    implements TBeanSerializer<multiGetBrand_result> {
        public static final multiGetBrand_resultHelper OBJ = new multiGetBrand_resultHelper();

        public static multiGetBrand_resultHelper getInstance() {
            return OBJ;
        }

        public void read(multiGetBrand_result struct, Protocol iprot) throws OspException {
            MultiGetBrandResponse value = new MultiGetBrandResponse();
            MultiGetBrandResponseHelper.getInstance().read(value, iprot);
            struct.setSuccess(value);
            this.validate(struct);
        }

        public void write(multiGetBrand_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                MultiGetBrandResponseHelper.getInstance().write(struct.getSuccess(), oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(multiGetBrand_result bean) throws OspException {
        }
    }

    public static class healthCheck_resultHelper
    implements TBeanSerializer<healthCheck_result> {
        public static final healthCheck_resultHelper OBJ = new healthCheck_resultHelper();

        public static healthCheck_resultHelper getInstance() {
            return OBJ;
        }

        public void read(healthCheck_result struct, Protocol iprot) throws OspException {
            CheckResult value = new CheckResult();
            CheckResultHelper.getInstance().read(value, iprot);
            struct.setSuccess(value);
            this.validate(struct);
        }

        public void write(healthCheck_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                CheckResultHelper.getInstance().write(struct.getSuccess(), oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(healthCheck_result bean) throws OspException {
        }
    }

    public static class getVendorBrandRelationshipByVendorId_resultHelper
    implements TBeanSerializer<getVendorBrandRelationshipByVendorId_result> {
        public static final getVendorBrandRelationshipByVendorId_resultHelper OBJ = new getVendorBrandRelationshipByVendorId_resultHelper();

        public static getVendorBrandRelationshipByVendorId_resultHelper getInstance() {
            return OBJ;
        }

        public void read(getVendorBrandRelationshipByVendorId_result struct, Protocol iprot) throws OspException {
            ArrayList<VendorBrandRelationShip> value = new ArrayList<VendorBrandRelationShip>();
            iprot.readListBegin();
            try {
                while (true) {
                    VendorBrandRelationShip elem1 = new VendorBrandRelationShip();
                    VendorBrandRelationShipHelper.getInstance().read(elem1, iprot);
                    value.add(elem1);
                }
            }
            catch (Exception e) {
                iprot.readListEnd();
                struct.setSuccess(value);
                this.validate(struct);
                return;
            }
        }

        public void write(getVendorBrandRelationshipByVendorId_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                oprot.writeListBegin();
                for (VendorBrandRelationShip _item0 : struct.getSuccess()) {
                    VendorBrandRelationShipHelper.getInstance().write(_item0, oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getVendorBrandRelationshipByVendorId_result bean) throws OspException {
        }
    }

    public static class getBrandStories_resultHelper
    implements TBeanSerializer<getBrandStories_result> {
        public static final getBrandStories_resultHelper OBJ = new getBrandStories_resultHelper();

        public static getBrandStories_resultHelper getInstance() {
            return OBJ;
        }

        public void read(getBrandStories_result struct, Protocol iprot) throws OspException {
            ArrayList<BrandStory> value = new ArrayList<BrandStory>();
            iprot.readListBegin();
            try {
                while (true) {
                    BrandStory elem0 = new BrandStory();
                    BrandStoryHelper.getInstance().read(elem0, iprot);
                    value.add(elem0);
                }
            }
            catch (Exception e) {
                iprot.readListEnd();
                struct.setSuccess(value);
                this.validate(struct);
                return;
            }
        }

        public void write(getBrandStories_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                oprot.writeListBegin();
                for (BrandStory _item0 : struct.getSuccess()) {
                    BrandStoryHelper.getInstance().write(_item0, oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getBrandStories_result bean) throws OspException {
        }
    }

    public static class getBrandInfo_resultHelper
    implements TBeanSerializer<getBrandInfo_result> {
        public static final getBrandInfo_resultHelper OBJ = new getBrandInfo_resultHelper();

        public static getBrandInfo_resultHelper getInstance() {
            return OBJ;
        }

        public void read(getBrandInfo_result struct, Protocol iprot) throws OspException {
            BrandInfo value = new BrandInfo();
            BrandInfoHelper.getInstance().read(value, iprot);
            struct.setSuccess(value);
            this.validate(struct);
        }

        public void write(getBrandInfo_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                BrandInfoHelper.getInstance().write(struct.getSuccess(), oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getBrandInfo_result bean) throws OspException {
        }
    }

    public static class multiGetBrand_argsHelper
    implements TBeanSerializer<multiGetBrand_args> {
        public static final multiGetBrand_argsHelper OBJ = new multiGetBrand_argsHelper();

        public static multiGetBrand_argsHelper getInstance() {
            return OBJ;
        }

        public void read(multiGetBrand_args struct, Protocol iprot) throws OspException {
            BrandSearchType[] values;
            Object value = null;
            String name = iprot.readString();
            for (BrandSearchType v : values = BrandSearchType.values()) {
                if (!v.name().equals(name)) continue;
                value = v;
                break;
            }
            struct.setSearch_type((BrandSearchType)((Object)value));
            value = iprot.readString();
            struct.setWord((String)value);
            value = iprot.readI32();
            struct.setPage((Integer)value);
            value = iprot.readI32();
            struct.setLimit((Integer)value);
            this.validate(struct);
        }

        public void write(multiGetBrand_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSearch_type() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "search_type can not be null!");
            }
            oprot.writeFieldBegin("search_type");
            oprot.writeString(struct.getSearch_type().name());
            oprot.writeFieldEnd();
            if (struct.getWord() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "word can not be null!");
            }
            oprot.writeFieldBegin("word");
            oprot.writeString(struct.getWord());
            oprot.writeFieldEnd();
            if (struct.getPage() != null) {
                oprot.writeFieldBegin("page");
                oprot.writeI32(struct.getPage().intValue());
                oprot.writeFieldEnd();
            }
            if (struct.getLimit() != null) {
                oprot.writeFieldBegin("limit");
                oprot.writeI32(struct.getLimit().intValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(multiGetBrand_args bean) throws OspException {
        }
    }

    public static class healthCheck_argsHelper
    implements TBeanSerializer<healthCheck_args> {
        public static final healthCheck_argsHelper OBJ = new healthCheck_argsHelper();

        public static healthCheck_argsHelper getInstance() {
            return OBJ;
        }

        public void read(healthCheck_args struct, Protocol iprot) throws OspException {
            this.validate(struct);
        }

        public void write(healthCheck_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(healthCheck_args bean) throws OspException {
        }
    }

    public static class getVendorBrandRelationshipByVendorId_argsHelper
    implements TBeanSerializer<getVendorBrandRelationshipByVendorId_args> {
        public static final getVendorBrandRelationshipByVendorId_argsHelper OBJ = new getVendorBrandRelationshipByVendorId_argsHelper();

        public static getVendorBrandRelationshipByVendorId_argsHelper getInstance() {
            return OBJ;
        }

        public void read(getVendorBrandRelationshipByVendorId_args struct, Protocol iprot) throws OspException {
            int value = iprot.readI32();
            struct.setVendor_id(value);
            this.validate(struct);
        }

        public void write(getVendorBrandRelationshipByVendorId_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getVendor_id() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "vendor_id can not be null!");
            }
            oprot.writeFieldBegin("vendor_id");
            oprot.writeI32(struct.getVendor_id().intValue());
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getVendorBrandRelationshipByVendorId_args bean) throws OspException {
        }
    }

    public static class getBrandStories_argsHelper
    implements TBeanSerializer<getBrandStories_args> {
        public static final getBrandStories_argsHelper OBJ = new getBrandStories_argsHelper();

        public static getBrandStories_argsHelper getInstance() {
            return OBJ;
        }

        public void read(getBrandStories_args struct, Protocol iprot) throws OspException {
            ArrayList<Integer> value = new ArrayList<Integer>();
            iprot.readListBegin();
            try {
                while (true) {
                    int elem0 = iprot.readI32();
                    value.add(elem0);
                }
            }
            catch (Exception e) {
                iprot.readListEnd();
                struct.setBrand_ids(value);
                this.validate(struct);
                return;
            }
        }

        public void write(getBrandStories_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getBrand_ids() != null) {
                oprot.writeFieldBegin("brand_ids");
                oprot.writeListBegin();
                for (int _item0 : struct.getBrand_ids()) {
                    oprot.writeI32(_item0);
                }
            } else {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "brand_ids can not be null!");
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getBrandStories_args bean) throws OspException {
        }
    }

    public static class getBrandInfo_argsHelper
    implements TBeanSerializer<getBrandInfo_args> {
        public static final getBrandInfo_argsHelper OBJ = new getBrandInfo_argsHelper();

        public static getBrandInfo_argsHelper getInstance() {
            return OBJ;
        }

        public void read(getBrandInfo_args struct, Protocol iprot) throws OspException {
            String value = iprot.readString();
            struct.setBrand_id(value);
            this.validate(struct);
        }

        public void write(getBrandInfo_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getBrand_id() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "brand_id can not be null!");
            }
            oprot.writeFieldBegin("brand_id");
            oprot.writeString(struct.getBrand_id());
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getBrandInfo_args bean) throws OspException {
        }
    }

    public static class multiGetBrand_result {
        private MultiGetBrandResponse success;

        public MultiGetBrandResponse getSuccess() {
            return this.success;
        }

        public void setSuccess(MultiGetBrandResponse value) {
            this.success = value;
        }
    }

    public static class healthCheck_result {
        private CheckResult success;

        public CheckResult getSuccess() {
            return this.success;
        }

        public void setSuccess(CheckResult value) {
            this.success = value;
        }
    }

    public static class getVendorBrandRelationshipByVendorId_result {
        private List<VendorBrandRelationShip> success;

        public List<VendorBrandRelationShip> getSuccess() {
            return this.success;
        }

        public void setSuccess(List<VendorBrandRelationShip> value) {
            this.success = value;
        }
    }

    public static class getBrandStories_result {
        private List<BrandStory> success;

        public List<BrandStory> getSuccess() {
            return this.success;
        }

        public void setSuccess(List<BrandStory> value) {
            this.success = value;
        }
    }

    public static class getBrandInfo_result {
        private BrandInfo success;

        public BrandInfo getSuccess() {
            return this.success;
        }

        public void setSuccess(BrandInfo value) {
            this.success = value;
        }
    }

    public static class multiGetBrand_args {
        private BrandSearchType search_type;
        private String word;
        private Integer page;
        private Integer limit;

        public BrandSearchType getSearch_type() {
            return this.search_type;
        }

        public void setSearch_type(BrandSearchType value) {
            this.search_type = value;
        }

        public String getWord() {
            return this.word;
        }

        public void setWord(String value) {
            this.word = value;
        }

        public Integer getPage() {
            return this.page;
        }

        public void setPage(Integer value) {
            this.page = value;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public void setLimit(Integer value) {
            this.limit = value;
        }
    }

    public static class healthCheck_args {
    }

    public static class getVendorBrandRelationshipByVendorId_args {
        private Integer vendor_id;

        public Integer getVendor_id() {
            return this.vendor_id;
        }

        public void setVendor_id(Integer value) {
            this.vendor_id = value;
        }
    }

    public static class getBrandStories_args {
        private List<Integer> brand_ids;

        public List<Integer> getBrand_ids() {
            return this.brand_ids;
        }

        public void setBrand_ids(List<Integer> value) {
            this.brand_ids = value;
        }
    }

    public static class getBrandInfo_args {
        private String brand_id;

        public String getBrand_id() {
            return this.brand_id;
        }

        public void setBrand_id(String value) {
            this.brand_id = value;
        }
    }
}

