/*
 * Decompiled with CFR 0.152.
 */
package vipapis.category;

import com.vip.hermes.core.health.CheckResult;
import com.vip.hermes.core.health.CheckResultHelper;
import com.vip.osp.sdk.base.OspRestStub;
import com.vip.osp.sdk.base.TBeanSerializer;
import com.vip.osp.sdk.exception.OspException;
import com.vip.osp.sdk.protocol.Protocol;
import java.util.ArrayList;
import java.util.List;
import vipapis.category.Attribute;
import vipapis.category.AttributeHelper;
import vipapis.category.Category;
import vipapis.category.CategoryHelper;
import vipapis.category.CategoryService;
import vipapis.category.CategoryUpdates;
import vipapis.category.CategoryUpdatesHelper;
import vipapis.category.VendorCategory;
import vipapis.category.VendorCategoryHelper;

public class CategoryServiceHelper {

    public static class CategoryServiceClient
    extends OspRestStub
    implements CategoryService {
        public CategoryServiceClient() {
            super("1.0.0", "vipapis.category.CategoryService");
        }

        @Override
        public List<Attribute> getAttributes(int category_id, String attr_text) throws OspException {
            this.send_getAttributes(category_id, attr_text);
            return this.recv_getAttributes();
        }

        private void send_getAttributes(int category_id, String attr_text) throws OspException {
            this.initInvocation("getAttributes");
            getAttributes_args args = new getAttributes_args();
            args.setCategory_id(category_id);
            args.setAttr_text(attr_text);
            this.sendBase(args, getAttributes_argsHelper.getInstance());
        }

        private List<Attribute> recv_getAttributes() throws OspException {
            getAttributes_result result = new getAttributes_result();
            this.receiveBase(result, getAttributes_resultHelper.getInstance());
            return result.getSuccess();
        }

        @Override
        public List<Attribute> getCategoryAttributeListById(int category_id, Boolean is_include_children) throws OspException {
            this.send_getCategoryAttributeListById(category_id, is_include_children);
            return this.recv_getCategoryAttributeListById();
        }

        private void send_getCategoryAttributeListById(int category_id, Boolean is_include_children) throws OspException {
            this.initInvocation("getCategoryAttributeListById");
            getCategoryAttributeListById_args args = new getCategoryAttributeListById_args();
            args.setCategory_id(category_id);
            args.setIs_include_children(is_include_children);
            this.sendBase(args, getCategoryAttributeListById_argsHelper.getInstance());
        }

        private List<Attribute> recv_getCategoryAttributeListById() throws OspException {
            getCategoryAttributeListById_result result = new getCategoryAttributeListById_result();
            this.receiveBase(result, getCategoryAttributeListById_resultHelper.getInstance());
            return result.getSuccess();
        }

        @Override
        public Category getCategoryById(int category_id) throws OspException {
            this.send_getCategoryById(category_id);
            return this.recv_getCategoryById();
        }

        private void send_getCategoryById(int category_id) throws OspException {
            this.initInvocation("getCategoryById");
            getCategoryById_args args = new getCategoryById_args();
            args.setCategory_id(category_id);
            this.sendBase(args, getCategoryById_argsHelper.getInstance());
        }

        private Category recv_getCategoryById() throws OspException {
            getCategoryById_result result = new getCategoryById_result();
            this.receiveBase(result, getCategoryById_resultHelper.getInstance());
            return result.getSuccess();
        }

        @Override
        public List<Category> getCategoryListByName(String category_name, int limit, Boolean only_leaf) throws OspException {
            this.send_getCategoryListByName(category_name, limit, only_leaf);
            return this.recv_getCategoryListByName();
        }

        private void send_getCategoryListByName(String category_name, int limit, Boolean only_leaf) throws OspException {
            this.initInvocation("getCategoryListByName");
            getCategoryListByName_args args = new getCategoryListByName_args();
            args.setCategory_name(category_name);
            args.setLimit(limit);
            args.setOnly_leaf(only_leaf);
            this.sendBase(args, getCategoryListByName_argsHelper.getInstance());
        }

        private List<Category> recv_getCategoryListByName() throws OspException {
            getCategoryListByName_result result = new getCategoryListByName_result();
            this.receiveBase(result, getCategoryListByName_resultHelper.getInstance());
            return result.getSuccess();
        }

        @Override
        public List<Category> getCategoryTreeById(int category_id) throws OspException {
            this.send_getCategoryTreeById(category_id);
            return this.recv_getCategoryTreeById();
        }

        private void send_getCategoryTreeById(int category_id) throws OspException {
            this.initInvocation("getCategoryTreeById");
            getCategoryTreeById_args args = new getCategoryTreeById_args();
            args.setCategory_id(category_id);
            this.sendBase(args, getCategoryTreeById_argsHelper.getInstance());
        }

        private List<Category> recv_getCategoryTreeById() throws OspException {
            getCategoryTreeById_result result = new getCategoryTreeById_result();
            this.receiveBase(result, getCategoryTreeById_resultHelper.getInstance());
            return result.getSuccess();
        }

        @Override
        public CategoryUpdates getUpdatedCategoryList(long since_updatetime, int hierarchyId) throws OspException {
            this.send_getUpdatedCategoryList(since_updatetime, hierarchyId);
            return this.recv_getUpdatedCategoryList();
        }

        private void send_getUpdatedCategoryList(long since_updatetime, int hierarchyId) throws OspException {
            this.initInvocation("getUpdatedCategoryList");
            getUpdatedCategoryList_args args = new getUpdatedCategoryList_args();
            args.setSince_updatetime(since_updatetime);
            args.setHierarchyId(hierarchyId);
            this.sendBase(args, getUpdatedCategoryList_argsHelper.getInstance());
        }

        private CategoryUpdates recv_getUpdatedCategoryList() throws OspException {
            getUpdatedCategoryList_result result = new getUpdatedCategoryList_result();
            this.receiveBase(result, getUpdatedCategoryList_resultHelper.getInstance());
            return result.getSuccess();
        }

        @Override
        public CheckResult healthCheck() throws OspException {
            this.send_healthCheck();
            return this.recv_healthCheck();
        }

        private void send_healthCheck() throws OspException {
            this.initInvocation("healthCheck");
            healthCheck_args args = new healthCheck_args();
            this.sendBase(args, healthCheck_argsHelper.getInstance());
        }

        private CheckResult recv_healthCheck() throws OspException {
            healthCheck_result result = new healthCheck_result();
            this.receiveBase(result, healthCheck_resultHelper.getInstance());
            return result.getSuccess();
        }

        @Override
        public Integer uploadVendorCategory(int vendor_id, String vendor_category_tree_name, List<VendorCategory> vendor_categories) throws OspException {
            this.send_uploadVendorCategory(vendor_id, vendor_category_tree_name, vendor_categories);
            return this.recv_uploadVendorCategory();
        }

        private void send_uploadVendorCategory(int vendor_id, String vendor_category_tree_name, List<VendorCategory> vendor_categories) throws OspException {
            this.initInvocation("uploadVendorCategory");
            uploadVendorCategory_args args = new uploadVendorCategory_args();
            args.setVendor_id(vendor_id);
            args.setVendor_category_tree_name(vendor_category_tree_name);
            args.setVendor_categories(vendor_categories);
            this.sendBase(args, uploadVendorCategory_argsHelper.getInstance());
        }

        private Integer recv_uploadVendorCategory() throws OspException {
            uploadVendorCategory_result result = new uploadVendorCategory_result();
            this.receiveBase(result, uploadVendorCategory_resultHelper.getInstance());
            return result.getSuccess();
        }
    }

    public static class uploadVendorCategory_resultHelper
    implements TBeanSerializer<uploadVendorCategory_result> {
        public static final uploadVendorCategory_resultHelper OBJ = new uploadVendorCategory_resultHelper();

        public static uploadVendorCategory_resultHelper getInstance() {
            return OBJ;
        }

        public void read(uploadVendorCategory_result struct, Protocol iprot) throws OspException {
            Integer value = iprot.readI32();
            struct.setSuccess(value);
            this.validate(struct);
        }

        public void write(uploadVendorCategory_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                oprot.writeI32(struct.getSuccess().intValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(uploadVendorCategory_result bean) throws OspException {
        }
    }

    public static class healthCheck_resultHelper
    implements TBeanSerializer<healthCheck_result> {
        public static final healthCheck_resultHelper OBJ = new healthCheck_resultHelper();

        public static healthCheck_resultHelper getInstance() {
            return OBJ;
        }

        public void read(healthCheck_result struct, Protocol iprot) throws OspException {
            CheckResult value = new CheckResult();
            CheckResultHelper.getInstance().read(value, iprot);
            struct.setSuccess(value);
            this.validate(struct);
        }

        public void write(healthCheck_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                CheckResultHelper.getInstance().write(struct.getSuccess(), oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(healthCheck_result bean) throws OspException {
        }
    }

    public static class getUpdatedCategoryList_resultHelper
    implements TBeanSerializer<getUpdatedCategoryList_result> {
        public static final getUpdatedCategoryList_resultHelper OBJ = new getUpdatedCategoryList_resultHelper();

        public static getUpdatedCategoryList_resultHelper getInstance() {
            return OBJ;
        }

        public void read(getUpdatedCategoryList_result struct, Protocol iprot) throws OspException {
            CategoryUpdates value = new CategoryUpdates();
            CategoryUpdatesHelper.getInstance().read(value, iprot);
            struct.setSuccess(value);
            this.validate(struct);
        }

        public void write(getUpdatedCategoryList_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                CategoryUpdatesHelper.getInstance().write(struct.getSuccess(), oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getUpdatedCategoryList_result bean) throws OspException {
        }
    }

    public static class getCategoryTreeById_resultHelper
    implements TBeanSerializer<getCategoryTreeById_result> {
        public static final getCategoryTreeById_resultHelper OBJ = new getCategoryTreeById_resultHelper();

        public static getCategoryTreeById_resultHelper getInstance() {
            return OBJ;
        }

        public void read(getCategoryTreeById_result struct, Protocol iprot) throws OspException {
            ArrayList<Category> value = new ArrayList<Category>();
            iprot.readListBegin();
            try {
                while (true) {
                    Category elem1 = new Category();
                    CategoryHelper.getInstance().read(elem1, iprot);
                    value.add(elem1);
                }
            }
            catch (Exception e) {
                iprot.readListEnd();
                struct.setSuccess(value);
                this.validate(struct);
                return;
            }
        }

        public void write(getCategoryTreeById_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                oprot.writeListBegin();
                for (Category _item0 : struct.getSuccess()) {
                    CategoryHelper.getInstance().write(_item0, oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getCategoryTreeById_result bean) throws OspException {
        }
    }

    public static class getCategoryListByName_resultHelper
    implements TBeanSerializer<getCategoryListByName_result> {
        public static final getCategoryListByName_resultHelper OBJ = new getCategoryListByName_resultHelper();

        public static getCategoryListByName_resultHelper getInstance() {
            return OBJ;
        }

        public void read(getCategoryListByName_result struct, Protocol iprot) throws OspException {
            ArrayList<Category> value = new ArrayList<Category>();
            iprot.readListBegin();
            try {
                while (true) {
                    Category elem0 = new Category();
                    CategoryHelper.getInstance().read(elem0, iprot);
                    value.add(elem0);
                }
            }
            catch (Exception e) {
                iprot.readListEnd();
                struct.setSuccess(value);
                this.validate(struct);
                return;
            }
        }

        public void write(getCategoryListByName_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                oprot.writeListBegin();
                for (Category _item0 : struct.getSuccess()) {
                    CategoryHelper.getInstance().write(_item0, oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getCategoryListByName_result bean) throws OspException {
        }
    }

    public static class getCategoryById_resultHelper
    implements TBeanSerializer<getCategoryById_result> {
        public static final getCategoryById_resultHelper OBJ = new getCategoryById_resultHelper();

        public static getCategoryById_resultHelper getInstance() {
            return OBJ;
        }

        public void read(getCategoryById_result struct, Protocol iprot) throws OspException {
            Category value = new Category();
            CategoryHelper.getInstance().read(value, iprot);
            struct.setSuccess(value);
            this.validate(struct);
        }

        public void write(getCategoryById_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                CategoryHelper.getInstance().write(struct.getSuccess(), oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getCategoryById_result bean) throws OspException {
        }
    }

    public static class getCategoryAttributeListById_resultHelper
    implements TBeanSerializer<getCategoryAttributeListById_result> {
        public static final getCategoryAttributeListById_resultHelper OBJ = new getCategoryAttributeListById_resultHelper();

        public static getCategoryAttributeListById_resultHelper getInstance() {
            return OBJ;
        }

        public void read(getCategoryAttributeListById_result struct, Protocol iprot) throws OspException {
            ArrayList<Attribute> value = new ArrayList<Attribute>();
            iprot.readListBegin();
            try {
                while (true) {
                    Attribute elem1 = new Attribute();
                    AttributeHelper.getInstance().read(elem1, iprot);
                    value.add(elem1);
                }
            }
            catch (Exception e) {
                iprot.readListEnd();
                struct.setSuccess(value);
                this.validate(struct);
                return;
            }
        }

        public void write(getCategoryAttributeListById_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                oprot.writeListBegin();
                for (Attribute _item0 : struct.getSuccess()) {
                    AttributeHelper.getInstance().write(_item0, oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getCategoryAttributeListById_result bean) throws OspException {
        }
    }

    public static class getAttributes_resultHelper
    implements TBeanSerializer<getAttributes_result> {
        public static final getAttributes_resultHelper OBJ = new getAttributes_resultHelper();

        public static getAttributes_resultHelper getInstance() {
            return OBJ;
        }

        public void read(getAttributes_result struct, Protocol iprot) throws OspException {
            ArrayList<Attribute> value = new ArrayList<Attribute>();
            iprot.readListBegin();
            try {
                while (true) {
                    Attribute elem1 = new Attribute();
                    AttributeHelper.getInstance().read(elem1, iprot);
                    value.add(elem1);
                }
            }
            catch (Exception e) {
                iprot.readListEnd();
                struct.setSuccess(value);
                this.validate(struct);
                return;
            }
        }

        public void write(getAttributes_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                oprot.writeListBegin();
                for (Attribute _item0 : struct.getSuccess()) {
                    AttributeHelper.getInstance().write(_item0, oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getAttributes_result bean) throws OspException {
        }
    }

    public static class uploadVendorCategory_argsHelper
    implements TBeanSerializer<uploadVendorCategory_args> {
        public static final uploadVendorCategory_argsHelper OBJ = new uploadVendorCategory_argsHelper();

        public static uploadVendorCategory_argsHelper getInstance() {
            return OBJ;
        }

        public void read(uploadVendorCategory_args struct, Protocol iprot) throws OspException {
            int value = iprot.readI32();
            struct.setVendor_id(value);
            Object value2 = iprot.readString();
            struct.setVendor_category_tree_name((String)value2);
            value2 = new ArrayList();
            iprot.readListBegin();
            try {
                while (true) {
                    VendorCategory elem0 = new VendorCategory();
                    VendorCategoryHelper.getInstance().read(elem0, iprot);
                    value2.add(elem0);
                }
            }
            catch (Exception e) {
                iprot.readListEnd();
                struct.setVendor_categories((List<VendorCategory>)value2);
                this.validate(struct);
                return;
            }
        }

        public void write(uploadVendorCategory_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getVendor_id() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "vendor_id can not be null!");
            }
            oprot.writeFieldBegin("vendor_id");
            oprot.writeI32(struct.getVendor_id().intValue());
            oprot.writeFieldEnd();
            if (struct.getVendor_category_tree_name() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "vendor_category_tree_name can not be null!");
            }
            oprot.writeFieldBegin("vendor_category_tree_name");
            oprot.writeString(struct.getVendor_category_tree_name());
            oprot.writeFieldEnd();
            if (struct.getVendor_categories() != null) {
                oprot.writeFieldBegin("vendor_categories");
                oprot.writeListBegin();
                for (VendorCategory _item0 : struct.getVendor_categories()) {
                    VendorCategoryHelper.getInstance().write(_item0, oprot);
                }
            } else {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "vendor_categories can not be null!");
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(uploadVendorCategory_args bean) throws OspException {
        }
    }

    public static class healthCheck_argsHelper
    implements TBeanSerializer<healthCheck_args> {
        public static final healthCheck_argsHelper OBJ = new healthCheck_argsHelper();

        public static healthCheck_argsHelper getInstance() {
            return OBJ;
        }

        public void read(healthCheck_args struct, Protocol iprot) throws OspException {
            this.validate(struct);
        }

        public void write(healthCheck_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(healthCheck_args bean) throws OspException {
        }
    }

    public static class getUpdatedCategoryList_argsHelper
    implements TBeanSerializer<getUpdatedCategoryList_args> {
        public static final getUpdatedCategoryList_argsHelper OBJ = new getUpdatedCategoryList_argsHelper();

        public static getUpdatedCategoryList_argsHelper getInstance() {
            return OBJ;
        }

        public void read(getUpdatedCategoryList_args struct, Protocol iprot) throws OspException {
            long value = iprot.readI64();
            struct.setSince_updatetime(value);
            int value2 = iprot.readI32();
            struct.setHierarchyId(value2);
            this.validate(struct);
        }

        public void write(getUpdatedCategoryList_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSince_updatetime() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "since_updatetime can not be null!");
            }
            oprot.writeFieldBegin("since_updatetime");
            oprot.writeI64(struct.getSince_updatetime().longValue());
            oprot.writeFieldEnd();
            if (struct.getHierarchyId() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "hierarchyId can not be null!");
            }
            oprot.writeFieldBegin("hierarchyId");
            oprot.writeI32(struct.getHierarchyId().intValue());
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getUpdatedCategoryList_args bean) throws OspException {
        }
    }

    public static class getCategoryTreeById_argsHelper
    implements TBeanSerializer<getCategoryTreeById_args> {
        public static final getCategoryTreeById_argsHelper OBJ = new getCategoryTreeById_argsHelper();

        public static getCategoryTreeById_argsHelper getInstance() {
            return OBJ;
        }

        public void read(getCategoryTreeById_args struct, Protocol iprot) throws OspException {
            int value = iprot.readI32();
            struct.setCategory_id(value);
            this.validate(struct);
        }

        public void write(getCategoryTreeById_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getCategory_id() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "category_id can not be null!");
            }
            oprot.writeFieldBegin("category_id");
            oprot.writeI32(struct.getCategory_id().intValue());
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getCategoryTreeById_args bean) throws OspException {
        }
    }

    public static class getCategoryListByName_argsHelper
    implements TBeanSerializer<getCategoryListByName_args> {
        public static final getCategoryListByName_argsHelper OBJ = new getCategoryListByName_argsHelper();

        public static getCategoryListByName_argsHelper getInstance() {
            return OBJ;
        }

        public void read(getCategoryListByName_args struct, Protocol iprot) throws OspException {
            String value = iprot.readString();
            struct.setCategory_name(value);
            int value2 = iprot.readI32();
            struct.setLimit(value2);
            Boolean value3 = iprot.readBool();
            struct.setOnly_leaf(value3);
            this.validate(struct);
        }

        public void write(getCategoryListByName_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getCategory_name() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "category_name can not be null!");
            }
            oprot.writeFieldBegin("category_name");
            oprot.writeString(struct.getCategory_name());
            oprot.writeFieldEnd();
            if (struct.getLimit() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "limit can not be null!");
            }
            oprot.writeFieldBegin("limit");
            oprot.writeI32(struct.getLimit().intValue());
            oprot.writeFieldEnd();
            if (struct.getOnly_leaf() != null) {
                oprot.writeFieldBegin("only_leaf");
                oprot.writeBool(struct.getOnly_leaf().booleanValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getCategoryListByName_args bean) throws OspException {
        }
    }

    public static class getCategoryById_argsHelper
    implements TBeanSerializer<getCategoryById_args> {
        public static final getCategoryById_argsHelper OBJ = new getCategoryById_argsHelper();

        public static getCategoryById_argsHelper getInstance() {
            return OBJ;
        }

        public void read(getCategoryById_args struct, Protocol iprot) throws OspException {
            int value = iprot.readI32();
            struct.setCategory_id(value);
            this.validate(struct);
        }

        public void write(getCategoryById_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getCategory_id() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "category_id can not be null!");
            }
            oprot.writeFieldBegin("category_id");
            oprot.writeI32(struct.getCategory_id().intValue());
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getCategoryById_args bean) throws OspException {
        }
    }

    public static class getCategoryAttributeListById_argsHelper
    implements TBeanSerializer<getCategoryAttributeListById_args> {
        public static final getCategoryAttributeListById_argsHelper OBJ = new getCategoryAttributeListById_argsHelper();

        public static getCategoryAttributeListById_argsHelper getInstance() {
            return OBJ;
        }

        public void read(getCategoryAttributeListById_args struct, Protocol iprot) throws OspException {
            int value = iprot.readI32();
            struct.setCategory_id(value);
            Boolean value2 = iprot.readBool();
            struct.setIs_include_children(value2);
            this.validate(struct);
        }

        public void write(getCategoryAttributeListById_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getCategory_id() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "category_id can not be null!");
            }
            oprot.writeFieldBegin("category_id");
            oprot.writeI32(struct.getCategory_id().intValue());
            oprot.writeFieldEnd();
            if (struct.getIs_include_children() != null) {
                oprot.writeFieldBegin("is_include_children");
                oprot.writeBool(struct.getIs_include_children().booleanValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getCategoryAttributeListById_args bean) throws OspException {
        }
    }

    public static class getAttributes_argsHelper
    implements TBeanSerializer<getAttributes_args> {
        public static final getAttributes_argsHelper OBJ = new getAttributes_argsHelper();

        public static getAttributes_argsHelper getInstance() {
            return OBJ;
        }

        public void read(getAttributes_args struct, Protocol iprot) throws OspException {
            int value = iprot.readI32();
            struct.setCategory_id(value);
            String value2 = iprot.readString();
            struct.setAttr_text(value2);
            this.validate(struct);
        }

        public void write(getAttributes_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getCategory_id() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "category_id can not be null!");
            }
            oprot.writeFieldBegin("category_id");
            oprot.writeI32(struct.getCategory_id().intValue());
            oprot.writeFieldEnd();
            if (struct.getAttr_text() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "attr_text can not be null!");
            }
            oprot.writeFieldBegin("attr_text");
            oprot.writeString(struct.getAttr_text());
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getAttributes_args bean) throws OspException {
        }
    }

    public static class uploadVendorCategory_result {
        private Integer success;

        public Integer getSuccess() {
            return this.success;
        }

        public void setSuccess(Integer value) {
            this.success = value;
        }
    }

    public static class healthCheck_result {
        private CheckResult success;

        public CheckResult getSuccess() {
            return this.success;
        }

        public void setSuccess(CheckResult value) {
            this.success = value;
        }
    }

    public static class getUpdatedCategoryList_result {
        private CategoryUpdates success;

        public CategoryUpdates getSuccess() {
            return this.success;
        }

        public void setSuccess(CategoryUpdates value) {
            this.success = value;
        }
    }

    public static class getCategoryTreeById_result {
        private List<Category> success;

        public List<Category> getSuccess() {
            return this.success;
        }

        public void setSuccess(List<Category> value) {
            this.success = value;
        }
    }

    public static class getCategoryListByName_result {
        private List<Category> success;

        public List<Category> getSuccess() {
            return this.success;
        }

        public void setSuccess(List<Category> value) {
            this.success = value;
        }
    }

    public static class getCategoryById_result {
        private Category success;

        public Category getSuccess() {
            return this.success;
        }

        public void setSuccess(Category value) {
            this.success = value;
        }
    }

    public static class getCategoryAttributeListById_result {
        private List<Attribute> success;

        public List<Attribute> getSuccess() {
            return this.success;
        }

        public void setSuccess(List<Attribute> value) {
            this.success = value;
        }
    }

    public static class getAttributes_result {
        private List<Attribute> success;

        public List<Attribute> getSuccess() {
            return this.success;
        }

        public void setSuccess(List<Attribute> value) {
            this.success = value;
        }
    }

    public static class uploadVendorCategory_args {
        private Integer vendor_id;
        private String vendor_category_tree_name;
        private List<VendorCategory> vendor_categories;

        public Integer getVendor_id() {
            return this.vendor_id;
        }

        public void setVendor_id(Integer value) {
            this.vendor_id = value;
        }

        public String getVendor_category_tree_name() {
            return this.vendor_category_tree_name;
        }

        public void setVendor_category_tree_name(String value) {
            this.vendor_category_tree_name = value;
        }

        public List<VendorCategory> getVendor_categories() {
            return this.vendor_categories;
        }

        public void setVendor_categories(List<VendorCategory> value) {
            this.vendor_categories = value;
        }
    }

    public static class healthCheck_args {
    }

    public static class getUpdatedCategoryList_args {
        private Long since_updatetime;
        private Integer hierarchyId;

        public Long getSince_updatetime() {
            return this.since_updatetime;
        }

        public void setSince_updatetime(Long value) {
            this.since_updatetime = value;
        }

        public Integer getHierarchyId() {
            return this.hierarchyId;
        }

        public void setHierarchyId(Integer value) {
            this.hierarchyId = value;
        }
    }

    public static class getCategoryTreeById_args {
        private Integer category_id;

        public Integer getCategory_id() {
            return this.category_id;
        }

        public void setCategory_id(Integer value) {
            this.category_id = value;
        }
    }

    public static class getCategoryListByName_args {
        private String category_name;
        private Integer limit;
        private Boolean only_leaf;

        public String getCategory_name() {
            return this.category_name;
        }

        public void setCategory_name(String value) {
            this.category_name = value;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public void setLimit(Integer value) {
            this.limit = value;
        }

        public Boolean getOnly_leaf() {
            return this.only_leaf;
        }

        public void setOnly_leaf(Boolean value) {
            this.only_leaf = value;
        }
    }

    public static class getCategoryById_args {
        private Integer category_id;

        public Integer getCategory_id() {
            return this.category_id;
        }

        public void setCategory_id(Integer value) {
            this.category_id = value;
        }
    }

    public static class getCategoryAttributeListById_args {
        private Integer category_id;
        private Boolean is_include_children;

        public Integer getCategory_id() {
            return this.category_id;
        }

        public void setCategory_id(Integer value) {
            this.category_id = value;
        }

        public Boolean getIs_include_children() {
            return this.is_include_children;
        }

        public void setIs_include_children(Boolean value) {
            this.is_include_children = value;
        }
    }

    public static class getAttributes_args {
        private Integer category_id;
        private String attr_text;

        public Integer getCategory_id() {
            return this.category_id;
        }

        public void setCategory_id(Integer value) {
            this.category_id = value;
        }

        public String getAttr_text() {
            return this.attr_text;
        }

        public void setAttr_text(String value) {
            this.attr_text = value;
        }
    }
}

