/*
 * Decompiled with CFR 0.152.
 */
package vipapis.inventory;

import com.vip.osp.sdk.base.TBeanSerializer;
import com.vip.osp.sdk.exception.OspException;
import com.vip.osp.sdk.protocol.Protocol;
import com.vip.osp.sdk.protocol.ProtocolUtil;
import vipapis.inventory.PrebuySku;

public class PrebuySkuHelper
implements TBeanSerializer<PrebuySku> {
    public static final PrebuySkuHelper OBJ = new PrebuySkuHelper();

    public static PrebuySkuHelper getInstance() {
        return OBJ;
    }

    public void read(PrebuySku struct, Protocol iprot) throws OspException {
        String schemeStruct = iprot.readStructBegin();
        if (schemeStruct != null) {
            String schemeField;
            while ((schemeField = iprot.readFieldBegin()) != null) {
                boolean needSkip = true;
                if ("barcode".equals(schemeField.trim())) {
                    needSkip = false;
                    String value = iprot.readString();
                    struct.setBarcode(value);
                }
                if ("quantity".equals(schemeField.trim())) {
                    needSkip = false;
                    int value = iprot.readI32();
                    struct.setQuantity(value);
                }
                if (needSkip) {
                    ProtocolUtil.skip((Protocol)iprot);
                }
                iprot.readFieldEnd();
            }
        } else {
            throw new OspException();
        }
        iprot.readStructEnd();
        this.validate(struct);
    }

    public void write(PrebuySku struct, Protocol oprot) throws OspException {
        this.validate(struct);
        oprot.writeStructBegin();
        if (struct.getBarcode() == null) {
            throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "barcode can not be null!");
        }
        oprot.writeFieldBegin("barcode");
        oprot.writeString(struct.getBarcode());
        oprot.writeFieldEnd();
        if (struct.getQuantity() == null) {
            throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "quantity can not be null!");
        }
        oprot.writeFieldBegin("quantity");
        oprot.writeI32(struct.getQuantity().intValue());
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public void validate(PrebuySku bean) throws OspException {
    }
}

