/*
 * Decompiled with CFR 0.152.
 */
package vipapis.marketplace.price;

import com.vip.hermes.core.health.CheckResult;
import com.vip.hermes.core.health.CheckResultHelper;
import com.vip.osp.sdk.base.OspRestStub;
import com.vip.osp.sdk.base.TBeanSerializer;
import com.vip.osp.sdk.exception.OspException;
import com.vip.osp.sdk.protocol.Protocol;
import vipapis.marketplace.price.GetSkuPriceResponse;
import vipapis.marketplace.price.GetSkuPriceResponseHelper;
import vipapis.marketplace.price.PriceService;
import vipapis.marketplace.price.UpdateSkuPriceResponse;
import vipapis.marketplace.price.UpdateSkuPriceResponseHelper;

public class PriceServiceHelper {

    public static class PriceServiceClient
    extends OspRestStub
    implements PriceService {
        public PriceServiceClient() {
            super("1.0.0", "vipapis.marketplace.price.PriceService");
        }

        @Override
        public GetSkuPriceResponse getSkuPrice(String sku_id) throws OspException {
            this.send_getSkuPrice(sku_id);
            return this.recv_getSkuPrice();
        }

        private void send_getSkuPrice(String sku_id) throws OspException {
            this.initInvocation("getSkuPrice");
            getSkuPrice_args args = new getSkuPrice_args();
            args.setSku_id(sku_id);
            this.sendBase(args, getSkuPrice_argsHelper.getInstance());
        }

        private GetSkuPriceResponse recv_getSkuPrice() throws OspException {
            getSkuPrice_result result = new getSkuPrice_result();
            this.receiveBase(result, getSkuPrice_resultHelper.getInstance());
            return result.getSuccess();
        }

        @Override
        public CheckResult healthCheck() throws OspException {
            this.send_healthCheck();
            return this.recv_healthCheck();
        }

        private void send_healthCheck() throws OspException {
            this.initInvocation("healthCheck");
            healthCheck_args args = new healthCheck_args();
            this.sendBase(args, healthCheck_argsHelper.getInstance());
        }

        private CheckResult recv_healthCheck() throws OspException {
            healthCheck_result result = new healthCheck_result();
            this.receiveBase(result, healthCheck_resultHelper.getInstance());
            return result.getSuccess();
        }

        @Override
        public UpdateSkuPriceResponse updateSkuPrice(String sku_id, double market_price, double sale_price) throws OspException {
            this.send_updateSkuPrice(sku_id, market_price, sale_price);
            return this.recv_updateSkuPrice();
        }

        private void send_updateSkuPrice(String sku_id, double market_price, double sale_price) throws OspException {
            this.initInvocation("updateSkuPrice");
            updateSkuPrice_args args = new updateSkuPrice_args();
            args.setSku_id(sku_id);
            args.setMarket_price(market_price);
            args.setSale_price(sale_price);
            this.sendBase(args, updateSkuPrice_argsHelper.getInstance());
        }

        private UpdateSkuPriceResponse recv_updateSkuPrice() throws OspException {
            updateSkuPrice_result result = new updateSkuPrice_result();
            this.receiveBase(result, updateSkuPrice_resultHelper.getInstance());
            return result.getSuccess();
        }
    }

    public static class updateSkuPrice_resultHelper
    implements TBeanSerializer<updateSkuPrice_result> {
        public static final updateSkuPrice_resultHelper OBJ = new updateSkuPrice_resultHelper();

        public static updateSkuPrice_resultHelper getInstance() {
            return OBJ;
        }

        public void read(updateSkuPrice_result struct, Protocol iprot) throws OspException {
            UpdateSkuPriceResponse value = new UpdateSkuPriceResponse();
            UpdateSkuPriceResponseHelper.getInstance().read(value, iprot);
            struct.setSuccess(value);
            this.validate(struct);
        }

        public void write(updateSkuPrice_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                UpdateSkuPriceResponseHelper.getInstance().write(struct.getSuccess(), oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(updateSkuPrice_result bean) throws OspException {
        }
    }

    public static class healthCheck_resultHelper
    implements TBeanSerializer<healthCheck_result> {
        public static final healthCheck_resultHelper OBJ = new healthCheck_resultHelper();

        public static healthCheck_resultHelper getInstance() {
            return OBJ;
        }

        public void read(healthCheck_result struct, Protocol iprot) throws OspException {
            CheckResult value = new CheckResult();
            CheckResultHelper.getInstance().read(value, iprot);
            struct.setSuccess(value);
            this.validate(struct);
        }

        public void write(healthCheck_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                CheckResultHelper.getInstance().write(struct.getSuccess(), oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(healthCheck_result bean) throws OspException {
        }
    }

    public static class getSkuPrice_resultHelper
    implements TBeanSerializer<getSkuPrice_result> {
        public static final getSkuPrice_resultHelper OBJ = new getSkuPrice_resultHelper();

        public static getSkuPrice_resultHelper getInstance() {
            return OBJ;
        }

        public void read(getSkuPrice_result struct, Protocol iprot) throws OspException {
            GetSkuPriceResponse value = new GetSkuPriceResponse();
            GetSkuPriceResponseHelper.getInstance().read(value, iprot);
            struct.setSuccess(value);
            this.validate(struct);
        }

        public void write(getSkuPrice_result struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSuccess() != null) {
                oprot.writeFieldBegin("success");
                GetSkuPriceResponseHelper.getInstance().write(struct.getSuccess(), oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getSkuPrice_result bean) throws OspException {
        }
    }

    public static class updateSkuPrice_argsHelper
    implements TBeanSerializer<updateSkuPrice_args> {
        public static final updateSkuPrice_argsHelper OBJ = new updateSkuPrice_argsHelper();

        public static updateSkuPrice_argsHelper getInstance() {
            return OBJ;
        }

        public void read(updateSkuPrice_args struct, Protocol iprot) throws OspException {
            String value = iprot.readString();
            struct.setSku_id(value);
            double value2 = iprot.readDouble();
            struct.setMarket_price(value2);
            value2 = iprot.readDouble();
            struct.setSale_price(value2);
            this.validate(struct);
        }

        public void write(updateSkuPrice_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSku_id() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "sku_id can not be null!");
            }
            oprot.writeFieldBegin("sku_id");
            oprot.writeString(struct.getSku_id());
            oprot.writeFieldEnd();
            if (struct.getMarket_price() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "market_price can not be null!");
            }
            oprot.writeFieldBegin("market_price");
            oprot.writeDouble(struct.getMarket_price().doubleValue());
            oprot.writeFieldEnd();
            if (struct.getSale_price() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "sale_price can not be null!");
            }
            oprot.writeFieldBegin("sale_price");
            oprot.writeDouble(struct.getSale_price().doubleValue());
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(updateSkuPrice_args bean) throws OspException {
        }
    }

    public static class healthCheck_argsHelper
    implements TBeanSerializer<healthCheck_args> {
        public static final healthCheck_argsHelper OBJ = new healthCheck_argsHelper();

        public static healthCheck_argsHelper getInstance() {
            return OBJ;
        }

        public void read(healthCheck_args struct, Protocol iprot) throws OspException {
            this.validate(struct);
        }

        public void write(healthCheck_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(healthCheck_args bean) throws OspException {
        }
    }

    public static class getSkuPrice_argsHelper
    implements TBeanSerializer<getSkuPrice_args> {
        public static final getSkuPrice_argsHelper OBJ = new getSkuPrice_argsHelper();

        public static getSkuPrice_argsHelper getInstance() {
            return OBJ;
        }

        public void read(getSkuPrice_args struct, Protocol iprot) throws OspException {
            String value = iprot.readString();
            struct.setSku_id(value);
            this.validate(struct);
        }

        public void write(getSkuPrice_args struct, Protocol oprot) throws OspException {
            this.validate(struct);
            oprot.writeStructBegin();
            if (struct.getSku_id() == null) {
                throw new OspException("OSP_CALLEE_UNKNOWN_EXCEPTION", "sku_id can not be null!");
            }
            oprot.writeFieldBegin("sku_id");
            oprot.writeString(struct.getSku_id());
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate(getSkuPrice_args bean) throws OspException {
        }
    }

    public static class updateSkuPrice_result {
        private UpdateSkuPriceResponse success;

        public UpdateSkuPriceResponse getSuccess() {
            return this.success;
        }

        public void setSuccess(UpdateSkuPriceResponse value) {
            this.success = value;
        }
    }

    public static class healthCheck_result {
        private CheckResult success;

        public CheckResult getSuccess() {
            return this.success;
        }

        public void setSuccess(CheckResult value) {
            this.success = value;
        }
    }

    public static class getSkuPrice_result {
        private GetSkuPriceResponse success;

        public GetSkuPriceResponse getSuccess() {
            return this.success;
        }

        public void setSuccess(GetSkuPriceResponse value) {
            this.success = value;
        }
    }

    public static class updateSkuPrice_args {
        private String sku_id;
        private Double market_price;
        private Double sale_price;

        public String getSku_id() {
            return this.sku_id;
        }

        public void setSku_id(String value) {
            this.sku_id = value;
        }

        public Double getMarket_price() {
            return this.market_price;
        }

        public void setMarket_price(Double value) {
            this.market_price = value;
        }

        public Double getSale_price() {
            return this.sale_price;
        }

        public void setSale_price(Double value) {
            this.sale_price = value;
        }
    }

    public static class healthCheck_args {
    }

    public static class getSkuPrice_args {
        private String sku_id;

        public String getSku_id() {
            return this.sku_id;
        }

        public void setSku_id(String value) {
            this.sku_id = value;
        }
    }
}

