/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config;

import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.builder.IProperty;
import de.flapdoodle.embed.process.builder.TypedProperty;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.runtime.ICommandLinePostProcessor;
import de.flapdoodle.embed.process.store.IArtifactStore;

public class RuntimeConfigBuilder
extends AbstractBuilder<IRuntimeConfig> {
    private static final TypedProperty<IArtifactStore> ARTIFACT_STORE = TypedProperty.with("ArtifactStore", IArtifactStore.class);
    private static final TypedProperty<ProcessOutput> PROCESS_OUTPUT = TypedProperty.with("ProcessOutput", ProcessOutput.class);
    private static final TypedProperty<ICommandLinePostProcessor> CMD_POSTPROCESSOR = TypedProperty.with("CommandLinePostProcessor", ICommandLinePostProcessor.class);
    private static final TypedProperty<Boolean> DAEMON_PROCESS = TypedProperty.with("DaemonProcess", Boolean.class);

    public RuntimeConfigBuilder artifactStore(AbstractBuilder<IArtifactStore> artifactStoreBuilder) {
        return this.artifactStore(artifactStoreBuilder.build());
    }

    public RuntimeConfigBuilder artifactStore(IArtifactStore artifactStore) {
        this.set(ARTIFACT_STORE, artifactStore);
        return this;
    }

    protected IProperty<IArtifactStore> artifactStore() {
        return this.property(ARTIFACT_STORE);
    }

    public RuntimeConfigBuilder processOutput(ProcessOutput processOutput) {
        this.set(PROCESS_OUTPUT, processOutput);
        return this;
    }

    protected IProperty<ProcessOutput> processOutput() {
        return this.property(PROCESS_OUTPUT);
    }

    public RuntimeConfigBuilder commandLinePostProcessor(ICommandLinePostProcessor commandLinePostProcessor) {
        this.set(CMD_POSTPROCESSOR, commandLinePostProcessor);
        return this;
    }

    protected IProperty<ICommandLinePostProcessor> commandLinePostProcessor() {
        return this.property(CMD_POSTPROCESSOR);
    }

    public RuntimeConfigBuilder daemonProcess(boolean daemonProcess) {
        this.set(DAEMON_PROCESS, daemonProcess);
        return this;
    }

    protected IProperty<Boolean> daemonProcess() {
        return this.property(DAEMON_PROCESS);
    }

    @Override
    public IRuntimeConfig build() {
        IArtifactStore artifactStore = this.get(ARTIFACT_STORE);
        ProcessOutput processOutput = this.get(PROCESS_OUTPUT);
        ICommandLinePostProcessor commandLinePostProcessor = this.get(CMD_POSTPROCESSOR);
        Boolean daemonProcess = this.get(DAEMON_PROCESS, true);
        return new ImmutableRuntimeConfig(artifactStore, processOutput, commandLinePostProcessor, daemonProcess);
    }

    static class ImmutableRuntimeConfig
    implements IRuntimeConfig {
        private final ProcessOutput _processOutput;
        private final ICommandLinePostProcessor _commandLinePostProcessor;
        private final IArtifactStore _artifactStore;
        private final boolean _daemonProcess;

        public ImmutableRuntimeConfig(IArtifactStore artifactStore, ProcessOutput processOutput, ICommandLinePostProcessor commandLinePostProcessor, boolean daemonProcess) {
            this._artifactStore = artifactStore;
            this._processOutput = processOutput;
            this._commandLinePostProcessor = commandLinePostProcessor;
            this._daemonProcess = daemonProcess;
        }

        @Override
        public ProcessOutput getProcessOutput() {
            return this._processOutput;
        }

        @Override
        public ICommandLinePostProcessor getCommandLinePostProcessor() {
            return this._commandLinePostProcessor;
        }

        @Override
        public IArtifactStore getArtifactStore() {
            return this._artifactStore;
        }

        @Override
        public boolean isDaemonProcess() {
            return this._daemonProcess;
        }
    }
}

