/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.annotation.Policy;
import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.ext.IExtPolicy;
import io.github.dddplus.model.IDomainModel;
import io.github.dddplus.runtime.registry.BootstrapException;
import io.github.dddplus.runtime.registry.ExtensionDef;
import io.github.dddplus.runtime.registry.IRegistryAware;
import io.github.dddplus.runtime.registry.InternalAopUtils;
import io.github.dddplus.runtime.registry.InternalIndexer;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import lombok.Generated;

class PolicyDef
implements IRegistryAware {
    private IExtPolicy policyBean;
    private Class<? extends IDomainExtension> extClazz;
    private Map<String, ExtensionDef> extensionDefMap = new HashMap<String, ExtensionDef>();

    PolicyDef() {
    }

    @Override
    public void registerBean(@NotNull Object bean) {
        this.initialize(bean);
        InternalIndexer.index(this);
    }

    private void initialize(Object bean) {
        Policy policy = InternalAopUtils.getAnnotation(bean, Policy.class);
        this.extClazz = policy.extClazz();
        if (!(bean instanceof IExtPolicy)) {
            throw BootstrapException.ofMessage(bean.getClass().getCanonicalName(), " MUST implements IExtPolicy");
        }
        this.policyBean = (IExtPolicy)bean;
    }

    void registerExtensionDef(ExtensionDef extensionDef) {
        this.extensionDefMap.put(extensionDef.getCode(), extensionDef);
    }

    @NotNull
    ExtensionDef getExtension(IDomainModel model) {
        String extensionCode = this.policyBean.extensionCode(model);
        if (extensionCode == null) {
            return null;
        }
        return this.extensionDefMap.get(extensionCode);
    }

    String policyName() {
        return this.policyBean.getClass().getCanonicalName();
    }

    @Generated
    public String toString() {
        return "PolicyDef(policyBean=" + this.getPolicyBean() + ", extClazz=" + this.getExtClazz() + ", extensionDefMap=" + this.getExtensionDefMap() + ")";
    }

    @Generated
    IExtPolicy getPolicyBean() {
        return this.policyBean;
    }

    @Generated
    Class<? extends IDomainExtension> getExtClazz() {
        return this.extClazz;
    }

    @Generated
    Map<String, ExtensionDef> getExtensionDefMap() {
        return this.extensionDefMap;
    }
}

