/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.interceptor;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;

public class ContentTypeInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        if (response.header("Content-Type") != null && response.header("Content-Type").contains("application/x-ndjson")) {
            ResponseBody responseBody = response.body();
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.getBuffer();
            String bodyString = buffer.clone().readString(StandardCharsets.UTF_8);
            String[] ndjsonLines = bodyString.split("\n");
            StringBuilder sseBody = new StringBuilder();
            for (String jsonLine : ndjsonLines) {
                if (jsonLine.trim().isEmpty()) continue;
                sseBody.append("data: ").append(jsonLine).append("\n\n");
            }
            ResponseBody modifiedBody = ResponseBody.create((MediaType)MediaType.get((String)"text/event-stream"), (String)sseBody.toString());
            return response.newBuilder().header("Content-Type", "text/event-stream").body(modifiedBody).build();
        }
        return response;
    }
}

