/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.interceptor;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import io.github.lnyocly.ai4j.exception.CommonException;
import io.github.lnyocly.ai4j.exception.chain.ErrorHandler;
import io.github.lnyocly.ai4j.exception.error.Error;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ErrorInterceptor.class);

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        Response response = chain.proceed(original);
        if (this.isStreamingResponse(response)) {
            return response;
        }
        if (!response.isSuccessful() && response.code() != 100 && response.code() != 101) {
            ResponseBody responseBody = response.body();
            String errorMsg = this.getResponseBodyContent(responseBody);
            try {
                JSONObject object = JSON.parseObject((String)errorMsg);
                if (object == null) {
                    errorMsg = response.code() + " " + response.message();
                    throw new CommonException(errorMsg);
                }
            }
            catch (Exception e) {
                throw new CommonException(errorMsg);
            }
            ErrorHandler errorHandler = ErrorHandler.getInstance();
            Error error = errorHandler.process(errorMsg);
            log.error("AI\u670d\u52a1\u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)error.getMessage());
            throw new CommonException(error.getMessage());
        }
        ResponseBody responseBody = response.body();
        byte[] contentBytes = this.getResponseBodyBytes(responseBody);
        String content = new String(contentBytes, StandardCharsets.UTF_8);
        if (content.contains("Response") && content.contains("Error")) {
            ErrorHandler errorHandler = ErrorHandler.getInstance();
            Error error = errorHandler.process(content);
            log.error("AI\u670d\u52a1\u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)error.getMessage());
            throw new CommonException(error.getMessage());
        }
        ResponseBody newBody = ResponseBody.create((MediaType)responseBody.contentType(), (byte[])contentBytes);
        return response.newBuilder().body(newBody).build();
    }

    private boolean isStreamingResponse(Response response) {
        MediaType contentType = response.body().contentType();
        return contentType != null && (contentType.toString().contains("text/event-stream") || contentType.toString().contains("application/x-ndjson"));
    }

    private String getResponseBodyContent(ResponseBody responseBody) throws IOException {
        if (responseBody == null) {
            return "";
        }
        byte[] contentBytes = responseBody.bytes();
        return new String(contentBytes, StandardCharsets.UTF_8);
    }

    private byte[] getResponseBodyBytes(ResponseBody responseBody) throws IOException {
        if (responseBody == null) {
            return new byte[0];
        }
        return responseBody.bytes();
    }
}

