/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.listener;

import com.alibaba.fastjson2.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.lnyocly.ai4j.exception.CommonException;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatCompletionResponse;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.ChatMessage;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.Choice;
import io.github.lnyocly.ai4j.platform.openai.chat.enums.ChatMessageType;
import io.github.lnyocly.ai4j.platform.openai.tool.ToolCall;
import io.github.lnyocly.ai4j.platform.openai.usage.Usage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SseListener
extends EventSourceListener {
    private static final Logger log = LoggerFactory.getLogger(SseListener.class);
    private final StringBuilder output = new StringBuilder();
    private String currStr = "";
    private String currData = "";
    private String currToolName = "";
    private boolean isReasoning = false;
    private final StringBuilder reasoningOutput = new StringBuilder();
    private boolean showToolArgs = false;
    private final Usage usage = new Usage();
    private List<ToolCall> toolCalls = new ArrayList<ToolCall>();
    private ToolCall toolCall;
    private final StringBuilder argument = new StringBuilder();
    private CountDownLatch countDownLatch = new CountDownLatch(1);
    private String finishReason = null;
    private EventSource eventSource = null;
    private boolean ollamaToolCall = false;

    protected abstract void send();

    public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
        this.countDownLatch.countDown();
    }

    public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
        List<Choice> choices;
        this.currData = data;
        if (this.eventSource == null) {
            this.eventSource = eventSource;
        }
        if ("[DONE]".equalsIgnoreCase(data)) {
            this.currStr = "";
            this.send();
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        ChatCompletionResponse chatCompletionResponse = null;
        try {
            chatCompletionResponse = (ChatCompletionResponse)objectMapper.readValue(data, ChatCompletionResponse.class);
        }
        catch (JsonProcessingException e) {
            throw new CommonException("read data error");
        }
        Usage currUsage = chatCompletionResponse.getUsage();
        if (currUsage != null) {
            this.usage.setPromptTokens(this.usage.getPromptTokens() + currUsage.getPromptTokens());
            this.usage.setCompletionTokens(this.usage.getCompletionTokens() + currUsage.getCompletionTokens());
            this.usage.setTotalTokens(this.usage.getTotalTokens() + currUsage.getTotalTokens());
        }
        if ((choices = chatCompletionResponse.getChoices()) == null || choices.isEmpty()) {
            return;
        }
        ChatMessage responseMessage = choices.get(0).getDelta();
        this.finishReason = choices.get(0).getFinishReason();
        if ("stop".equals(this.finishReason) && this.ollamaToolCall) {
            this.ollamaToolCall = false;
            this.finishReason = "tool_calls";
        }
        if ("tool_calls".equals(this.finishReason)) {
            if (this.toolCall == null && responseMessage.getToolCalls() != null) {
                this.toolCalls = responseMessage.getToolCalls();
                if (this.showToolArgs) {
                    this.currStr = responseMessage.getToolCalls().get(0).getFunction().getArguments();
                    this.send();
                }
                return;
            }
            if (this.toolCall != null) {
                this.toolCall.getFunction().setArguments(this.argument.toString());
                this.toolCalls.add(this.toolCall);
            }
            this.argument.setLength(0);
            this.currToolName = "";
            return;
        }
        if ("stop".equals(this.finishReason)) {
            return;
        }
        if (ChatMessageType.ASSISTANT.getRole().equals(responseMessage.getRole()) && (responseMessage.getContent() == null || StringUtils.isEmpty((CharSequence)responseMessage.getContent().getText())) && responseMessage.getToolCalls() == null) {
            return;
        }
        if (responseMessage.getToolCalls() == null) {
            if (this.toolCall != null && StringUtils.isNotEmpty((CharSequence)this.argument) && "assistant".equals(responseMessage.getRole()) && responseMessage.getContent() != null && StringUtils.isNotEmpty((CharSequence)responseMessage.getContent().getText())) {
                return;
            }
            if (responseMessage.getContent() == null) {
                return;
            }
            if ("<tool_call>".equals(responseMessage.getContent().getText())) {
                this.ollamaToolCall = true;
                return;
            }
            if (this.ollamaToolCall) {
                if ("</tool_call>".equals(responseMessage.getContent().getText())) {
                    ToolCall.Function function = (ToolCall.Function)JSON.parseObject((String)this.argument.toString(), ToolCall.Function.class);
                    this.toolCall = new ToolCall();
                    this.toolCall.setFunction(function);
                    this.currToolName = function.getName();
                    this.argument.setLength(0);
                    this.argument.append(function.getArguments());
                    return;
                }
                this.argument.append(responseMessage.getContent().getText());
                if (this.showToolArgs) {
                    this.currStr = responseMessage.getContent().getText();
                    this.send();
                }
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)responseMessage.getReasoningContent())) {
                this.isReasoning = true;
                this.reasoningOutput.append(responseMessage.getReasoningContent());
                this.currStr = responseMessage.getReasoningContent();
            } else {
                this.isReasoning = false;
                if (responseMessage.getContent() == null) {
                    return;
                }
                this.output.append(responseMessage.getContent().getText());
                this.currStr = responseMessage.getContent().getText();
            }
            this.send();
        } else if (responseMessage.getToolCalls().get(0).getId() != null) {
            if (this.toolCall == null) {
                this.toolCall = responseMessage.getToolCalls().get(0);
            } else {
                this.toolCall.getFunction().setArguments(this.argument.toString());
                this.argument.setLength(0);
                this.toolCalls.add(this.toolCall);
                this.toolCall = responseMessage.getToolCalls().get(0);
            }
            this.currToolName = responseMessage.getToolCalls().get(0).getFunction().getName();
        } else {
            this.argument.append(responseMessage.getToolCalls().get(0).getFunction().getArguments());
            if (this.showToolArgs) {
                this.currStr = responseMessage.getToolCalls().get(0).getFunction().getArguments();
                this.send();
            }
        }
    }

    public void onClosed(@NotNull EventSource eventSource) {
        this.countDownLatch.countDown();
        this.countDownLatch = new CountDownLatch(1);
    }

    public StringBuilder getOutput() {
        return this.output;
    }

    public String getCurrStr() {
        return this.currStr;
    }

    public String getCurrData() {
        return this.currData;
    }

    public String getCurrToolName() {
        return this.currToolName;
    }

    public boolean isReasoning() {
        return this.isReasoning;
    }

    public StringBuilder getReasoningOutput() {
        return this.reasoningOutput;
    }

    public boolean isShowToolArgs() {
        return this.showToolArgs;
    }

    public void setShowToolArgs(boolean showToolArgs) {
        this.showToolArgs = showToolArgs;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public void setToolCalls(List<ToolCall> toolCalls) {
        this.toolCalls = toolCalls;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public void setToolCall(ToolCall toolCall) {
        this.toolCall = toolCall;
    }

    public ToolCall getToolCall() {
        return this.toolCall;
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public String getFinishReason() {
        return this.finishReason;
    }

    public EventSource getEventSource() {
        return this.eventSource;
    }
}

