/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.platform.openai.chat.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.lnyocly.ai4j.platform.openai.chat.entity.Content;
import io.github.lnyocly.ai4j.platform.openai.chat.enums.ChatMessageType;
import io.github.lnyocly.ai4j.platform.openai.tool.ToolCall;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChatMessage {
    private Content content;
    private String role;
    private String name;
    private String refusal;
    @JsonProperty(value="reasoning_content")
    private String reasoningContent;
    @JsonProperty(value="tool_call_id")
    private String toolCallId;
    @JsonProperty(value="tool_calls")
    private List<ToolCall> toolCalls;

    public ChatMessage(String userMessage) {
        this.role = ChatMessageType.USER.getRole();
        this.content = Content.ofText(userMessage);
    }

    public ChatMessage(ChatMessageType role, String message) {
        this.role = role.getRole();
        this.content = Content.ofText(message);
    }

    public ChatMessage(String role, String message) {
        this.role = role;
        this.content = Content.ofText(message);
    }

    public static ChatMessage withSystem(String content) {
        return new ChatMessage(ChatMessageType.SYSTEM, content);
    }

    public static ChatMessage withUser(String content) {
        return new ChatMessage(ChatMessageType.USER, content);
    }

    public static ChatMessage withUser(String content, String ... images) {
        return ChatMessage.builder().role(ChatMessageType.USER.getRole()).content(Content.ofMultiModals(Content.MultiModal.withMultiModal(content, images))).build();
    }

    public static ChatMessage withAssistant(String content) {
        return new ChatMessage(ChatMessageType.ASSISTANT, content);
    }

    public static ChatMessage withAssistant(List<ToolCall> toolCalls) {
        return ChatMessage.builder().role(ChatMessageType.ASSISTANT.getRole()).toolCalls(toolCalls).build();
    }

    public static ChatMessage withTool(String content, String toolCallId) {
        return ChatMessage.builder().role(ChatMessageType.TOOL.getRole()).content(Content.ofText(content)).toolCallId(toolCallId).build();
    }

    public static ChatMessageBuilder builder() {
        return new ChatMessageBuilder();
    }

    public Content getContent() {
        return this.content;
    }

    public String getRole() {
        return this.role;
    }

    public String getName() {
        return this.name;
    }

    public String getRefusal() {
        return this.refusal;
    }

    public String getReasoningContent() {
        return this.reasoningContent;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRefusal(String refusal) {
        this.refusal = refusal;
    }

    @JsonProperty(value="reasoning_content")
    public void setReasoningContent(String reasoningContent) {
        this.reasoningContent = reasoningContent;
    }

    @JsonProperty(value="tool_call_id")
    public void setToolCallId(String toolCallId) {
        this.toolCallId = toolCallId;
    }

    @JsonProperty(value="tool_calls")
    public void setToolCalls(List<ToolCall> toolCalls) {
        this.toolCalls = toolCalls;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Content this$content = this.getContent();
        Content other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$refusal = this.getRefusal();
        String other$refusal = other.getRefusal();
        if (this$refusal == null ? other$refusal != null : !this$refusal.equals(other$refusal)) {
            return false;
        }
        String this$reasoningContent = this.getReasoningContent();
        String other$reasoningContent = other.getReasoningContent();
        if (this$reasoningContent == null ? other$reasoningContent != null : !this$reasoningContent.equals(other$reasoningContent)) {
            return false;
        }
        String this$toolCallId = this.getToolCallId();
        String other$toolCallId = other.getToolCallId();
        if (this$toolCallId == null ? other$toolCallId != null : !this$toolCallId.equals(other$toolCallId)) {
            return false;
        }
        List<ToolCall> this$toolCalls = this.getToolCalls();
        List<ToolCall> other$toolCalls = other.getToolCalls();
        return !(this$toolCalls == null ? other$toolCalls != null : !((Object)this$toolCalls).equals(other$toolCalls));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Content $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $refusal = this.getRefusal();
        result = result * 59 + ($refusal == null ? 43 : $refusal.hashCode());
        String $reasoningContent = this.getReasoningContent();
        result = result * 59 + ($reasoningContent == null ? 43 : $reasoningContent.hashCode());
        String $toolCallId = this.getToolCallId();
        result = result * 59 + ($toolCallId == null ? 43 : $toolCallId.hashCode());
        List<ToolCall> $toolCalls = this.getToolCalls();
        result = result * 59 + ($toolCalls == null ? 43 : ((Object)$toolCalls).hashCode());
        return result;
    }

    public String toString() {
        return "ChatMessage(content=" + this.getContent() + ", role=" + this.getRole() + ", name=" + this.getName() + ", refusal=" + this.getRefusal() + ", reasoningContent=" + this.getReasoningContent() + ", toolCallId=" + this.getToolCallId() + ", toolCalls=" + this.getToolCalls() + ")";
    }

    private ChatMessage() {
    }

    private ChatMessage(Content content, String role, String name, String refusal, String reasoningContent, String toolCallId, List<ToolCall> toolCalls) {
        this.content = content;
        this.role = role;
        this.name = name;
        this.refusal = refusal;
        this.reasoningContent = reasoningContent;
        this.toolCallId = toolCallId;
        this.toolCalls = toolCalls;
    }

    public static class ChatMessageBuilder {
        private Content content;
        private String role;
        private String name;
        private String refusal;
        private String reasoningContent;
        private String toolCallId;
        private List<ToolCall> toolCalls;

        ChatMessageBuilder() {
        }

        public ChatMessageBuilder content(Content content) {
            this.content = content;
            return this;
        }

        public ChatMessageBuilder role(String role) {
            this.role = role;
            return this;
        }

        public ChatMessageBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChatMessageBuilder refusal(String refusal) {
            this.refusal = refusal;
            return this;
        }

        @JsonProperty(value="reasoning_content")
        public ChatMessageBuilder reasoningContent(String reasoningContent) {
            this.reasoningContent = reasoningContent;
            return this;
        }

        @JsonProperty(value="tool_call_id")
        public ChatMessageBuilder toolCallId(String toolCallId) {
            this.toolCallId = toolCallId;
            return this;
        }

        @JsonProperty(value="tool_calls")
        public ChatMessageBuilder toolCalls(List<ToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        public ChatMessage build() {
            return new ChatMessage(this.content, this.role, this.name, this.refusal, this.reasoningContent, this.toolCallId, this.toolCalls);
        }

        public String toString() {
            return "ChatMessage.ChatMessageBuilder(content=" + this.content + ", role=" + this.role + ", name=" + this.name + ", refusal=" + this.refusal + ", reasoningContent=" + this.reasoningContent + ", toolCallId=" + this.toolCallId + ", toolCalls=" + this.toolCalls + ")";
        }
    }
}

