/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.utils;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.util.Map;
import java.util.Set;

public class JsonObjectUtil {
    public static String toCamelCaseWithUppercaseJson(String json) {
        return JsonObjectUtil.convertJsonString(json, true);
    }

    public static String toSnakeCaseJson(String json) {
        return JsonObjectUtil.convertJsonString(json, false);
    }

    private static String convertJsonString(String json, boolean isCamelCase) {
        JSONObject jsonObject = JSON.parseObject((String)json);
        JSONObject newJsonObject = JsonObjectUtil.processJsonObject(jsonObject, isCamelCase);
        return newJsonObject.toJSONString(new JSONWriter.Feature[0]);
    }

    private static JSONObject processJsonObject(JSONObject jsonObject, boolean isCamelCase) {
        JSONObject newJsonObject = new JSONObject();
        Set entries = jsonObject.entrySet();
        for (Map.Entry entry : entries) {
            String newKey = isCamelCase ? JsonObjectUtil.toCamelCaseWithUppercase((String)entry.getKey()) : JsonObjectUtil.toSnakeCase((String)entry.getKey());
            Object value = entry.getValue();
            if (value instanceof JSONObject) {
                value = JsonObjectUtil.processJsonObject((JSONObject)value, isCamelCase);
            } else if (value instanceof JSONArray) {
                value = JsonObjectUtil.processJsonArray((JSONArray)value, isCamelCase);
            }
            newJsonObject.put((Object)newKey, value);
        }
        return newJsonObject;
    }

    private static JSONArray processJsonArray(JSONArray jsonArray, boolean isCamelCase) {
        JSONArray newArray = new JSONArray();
        for (Object element : jsonArray) {
            if (element instanceof JSONObject) {
                newArray.add((Object)JsonObjectUtil.processJsonObject((JSONObject)element, isCamelCase));
                continue;
            }
            if (element instanceof JSONArray) {
                newArray.add((Object)JsonObjectUtil.processJsonArray((JSONArray)element, isCamelCase));
                continue;
            }
            newArray.add(element);
        }
        return newArray;
    }

    private static String toCamelCaseWithUppercase(String key) {
        String[] parts = key.split("_");
        StringBuilder camelCaseKey = new StringBuilder();
        for (String part : parts) {
            if (part.length() <= 0) continue;
            camelCaseKey.append(part.substring(0, 1).toUpperCase()).append(part.substring(1).toLowerCase());
        }
        return camelCaseKey.toString();
    }

    private static String toSnakeCase(String key) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    result.append("_");
                }
                result.append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static void main(String[] args) {
        JsonObjectUtil util = new JsonObjectUtil();
        String camelCaseJson = JsonObjectUtil.toCamelCaseWithUppercaseJson("{\"request_id\":\"123\",\"created_time\":456}");
        System.out.println(camelCaseJson);
        String snakeCaseJson = JsonObjectUtil.toSnakeCaseJson("{\"RequestId\":\"123\",\"CreatedTime\":456}");
        System.out.println(snakeCaseJson);
    }
}

