/*
 * Decompiled with CFR 0.152.
 */
package io.github.lnyocly.ai4j.vector.pinecone;

import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class PineconeQuery {
    @NonNull
    private String namespace;
    private Integer topK;
    private Map<String, String> filter;
    private Boolean includeValues;
    private Boolean includeMetadata;
    @NonNull
    private List<Float> vector;
    private Map<String, String> sparseVector;
    private String id;

    private static Integer $default$topK() {
        return 10;
    }

    private static Boolean $default$includeValues() {
        return true;
    }

    private static Boolean $default$includeMetadata() {
        return true;
    }

    PineconeQuery(@NonNull String namespace, Integer topK, Map<String, String> filter, Boolean includeValues, Boolean includeMetadata, @NonNull List<Float> vector, Map<String, String> sparseVector, String id) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        if (vector == null) {
            throw new NullPointerException("vector is marked non-null but is null");
        }
        this.namespace = namespace;
        this.topK = topK;
        this.filter = filter;
        this.includeValues = includeValues;
        this.includeMetadata = includeMetadata;
        this.vector = vector;
        this.sparseVector = sparseVector;
        this.id = id;
    }

    public static PineconeQueryBuilder builder() {
        return new PineconeQueryBuilder();
    }

    @NonNull
    public String getNamespace() {
        return this.namespace;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Map<String, String> getFilter() {
        return this.filter;
    }

    public Boolean getIncludeValues() {
        return this.includeValues;
    }

    public Boolean getIncludeMetadata() {
        return this.includeMetadata;
    }

    @NonNull
    public List<Float> getVector() {
        return this.vector;
    }

    public Map<String, String> getSparseVector() {
        return this.sparseVector;
    }

    public String getId() {
        return this.id;
    }

    public void setNamespace(@NonNull String namespace) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        this.namespace = namespace;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public void setFilter(Map<String, String> filter) {
        this.filter = filter;
    }

    public void setIncludeValues(Boolean includeValues) {
        this.includeValues = includeValues;
    }

    public void setIncludeMetadata(Boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    public void setVector(@NonNull List<Float> vector) {
        if (vector == null) {
            throw new NullPointerException("vector is marked non-null but is null");
        }
        this.vector = vector;
    }

    public void setSparseVector(Map<String, String> sparseVector) {
        this.sparseVector = sparseVector;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PineconeQuery)) {
            return false;
        }
        PineconeQuery other = (PineconeQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$topK = this.getTopK();
        Integer other$topK = other.getTopK();
        if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
            return false;
        }
        Boolean this$includeValues = this.getIncludeValues();
        Boolean other$includeValues = other.getIncludeValues();
        if (this$includeValues == null ? other$includeValues != null : !((Object)this$includeValues).equals(other$includeValues)) {
            return false;
        }
        Boolean this$includeMetadata = this.getIncludeMetadata();
        Boolean other$includeMetadata = other.getIncludeMetadata();
        if (this$includeMetadata == null ? other$includeMetadata != null : !((Object)this$includeMetadata).equals(other$includeMetadata)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        Map<String, String> this$filter = this.getFilter();
        Map<String, String> other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
            return false;
        }
        List<Float> this$vector = this.getVector();
        List<Float> other$vector = other.getVector();
        if (this$vector == null ? other$vector != null : !((Object)this$vector).equals(other$vector)) {
            return false;
        }
        Map<String, String> this$sparseVector = this.getSparseVector();
        Map<String, String> other$sparseVector = other.getSparseVector();
        if (this$sparseVector == null ? other$sparseVector != null : !((Object)this$sparseVector).equals(other$sparseVector)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PineconeQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $topK = this.getTopK();
        result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
        Boolean $includeValues = this.getIncludeValues();
        result = result * 59 + ($includeValues == null ? 43 : ((Object)$includeValues).hashCode());
        Boolean $includeMetadata = this.getIncludeMetadata();
        result = result * 59 + ($includeMetadata == null ? 43 : ((Object)$includeMetadata).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        Map<String, String> $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        List<Float> $vector = this.getVector();
        result = result * 59 + ($vector == null ? 43 : ((Object)$vector).hashCode());
        Map<String, String> $sparseVector = this.getSparseVector();
        result = result * 59 + ($sparseVector == null ? 43 : ((Object)$sparseVector).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "PineconeQuery(namespace=" + this.getNamespace() + ", topK=" + this.getTopK() + ", filter=" + this.getFilter() + ", includeValues=" + this.getIncludeValues() + ", includeMetadata=" + this.getIncludeMetadata() + ", vector=" + this.getVector() + ", sparseVector=" + this.getSparseVector() + ", id=" + this.getId() + ")";
    }

    public static class PineconeQueryBuilder {
        private String namespace;
        private boolean topK$set;
        private Integer topK$value;
        private Map<String, String> filter;
        private boolean includeValues$set;
        private Boolean includeValues$value;
        private boolean includeMetadata$set;
        private Boolean includeMetadata$value;
        private List<Float> vector;
        private Map<String, String> sparseVector;
        private String id;

        PineconeQueryBuilder() {
        }

        public PineconeQueryBuilder namespace(@NonNull String namespace) {
            if (namespace == null) {
                throw new NullPointerException("namespace is marked non-null but is null");
            }
            this.namespace = namespace;
            return this;
        }

        public PineconeQueryBuilder topK(Integer topK) {
            this.topK$value = topK;
            this.topK$set = true;
            return this;
        }

        public PineconeQueryBuilder filter(Map<String, String> filter) {
            this.filter = filter;
            return this;
        }

        public PineconeQueryBuilder includeValues(Boolean includeValues) {
            this.includeValues$value = includeValues;
            this.includeValues$set = true;
            return this;
        }

        public PineconeQueryBuilder includeMetadata(Boolean includeMetadata) {
            this.includeMetadata$value = includeMetadata;
            this.includeMetadata$set = true;
            return this;
        }

        public PineconeQueryBuilder vector(@NonNull List<Float> vector) {
            if (vector == null) {
                throw new NullPointerException("vector is marked non-null but is null");
            }
            this.vector = vector;
            return this;
        }

        public PineconeQueryBuilder sparseVector(Map<String, String> sparseVector) {
            this.sparseVector = sparseVector;
            return this;
        }

        public PineconeQueryBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PineconeQuery build() {
            Integer topK$value = this.topK$value;
            if (!this.topK$set) {
                topK$value = PineconeQuery.$default$topK();
            }
            Boolean includeValues$value = this.includeValues$value;
            if (!this.includeValues$set) {
                includeValues$value = PineconeQuery.$default$includeValues();
            }
            Boolean includeMetadata$value = this.includeMetadata$value;
            if (!this.includeMetadata$set) {
                includeMetadata$value = PineconeQuery.$default$includeMetadata();
            }
            return new PineconeQuery(this.namespace, topK$value, this.filter, includeValues$value, includeMetadata$value, this.vector, this.sparseVector, this.id);
        }

        public String toString() {
            return "PineconeQuery.PineconeQueryBuilder(namespace=" + this.namespace + ", topK$value=" + this.topK$value + ", filter=" + this.filter + ", includeValues$value=" + this.includeValues$value + ", includeMetadata$value=" + this.includeMetadata$value + ", vector=" + this.vector + ", sparseVector=" + this.sparseVector + ", id=" + this.id + ")";
        }
    }
}

