/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class IdWorker {
    private static volatile IdWorker idWorker = null;
    private final long twepoch = 1588435200000L;
    private final long workerIdBits = 10L;
    private final long maxWorkerId = 1023L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private long workerId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public IdWorker(long workerId) {
        if (workerId > 1023L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 1023L));
        }
        this.workerId = workerId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1588435200000L << 22 | this.workerId << 12 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IdWorker getInstance() {
        if (idWorker != null) return idWorker;
        Class<IdWorker> clazz = IdWorker.class;
        synchronized (IdWorker.class) {
            if (idWorker != null) return idWorker;
            IdWorker.init(IdWorker.initWorkerId());
            // ** MonitorExit[var0] (shouldn't be in output)
            return idWorker;
        }
    }

    public static long initWorkerId() {
        InetAddress address;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Cannot get LocalHost InetAddress, please check your network!", e);
        }
        byte[] ipAddressByteArray = address.getAddress();
        return ((ipAddressByteArray[ipAddressByteArray.length - 2] & 3) << 8) + (ipAddressByteArray[ipAddressByteArray.length - 1] & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(Long serverNodeId) {
        if (idWorker != null) return;
        Class<IdWorker> clazz = IdWorker.class;
        synchronized (IdWorker.class) {
            if (idWorker != null) return;
            idWorker = new IdWorker(serverNodeId);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

