/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.NumberInRange;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalArgumentNotContainedException;
import net.sf.qualitycheck.exception.IllegalEmptyArgumentException;
import net.sf.qualitycheck.exception.IllegalInstanceOfArgumentException;
import net.sf.qualitycheck.exception.IllegalMissingAnnotationException;
import net.sf.qualitycheck.exception.IllegalNaNArgumentException;
import net.sf.qualitycheck.exception.IllegalNegativeArgumentException;
import net.sf.qualitycheck.exception.IllegalNotEqualException;
import net.sf.qualitycheck.exception.IllegalNotGreaterOrEqualThanException;
import net.sf.qualitycheck.exception.IllegalNotGreaterThanException;
import net.sf.qualitycheck.exception.IllegalNotLesserThanException;
import net.sf.qualitycheck.exception.IllegalNotNullArgumentException;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;
import net.sf.qualitycheck.exception.IllegalNullElementsException;
import net.sf.qualitycheck.exception.IllegalNumberArgumentException;
import net.sf.qualitycheck.exception.IllegalNumericArgumentException;
import net.sf.qualitycheck.exception.IllegalPatternArgumentException;
import net.sf.qualitycheck.exception.IllegalPositionIndexException;
import net.sf.qualitycheck.exception.IllegalPositiveArgumentException;
import net.sf.qualitycheck.exception.IllegalRangeException;
import net.sf.qualitycheck.exception.IllegalStateOfArgumentException;
import net.sf.qualitycheck.exception.RuntimeInstantiationException;

public final class Check {
    private static final String EMPTY_ARGUMENT_NAME = "";

    private static <T> Number checkNumberInRange(String value, Class<T> type) {
        Number ret;
        if (type.equals(Byte.class)) {
            BigInteger number = new BigInteger(value);
            NumberInRange.checkByte(number);
            ret = number.byteValue();
        } else if (type.equals(Double.class)) {
            BigDecimal number = new BigDecimal(value);
            NumberInRange.checkDouble(number);
            ret = ((Number)number).doubleValue();
        } else if (type.equals(Float.class)) {
            BigDecimal number = new BigDecimal(value);
            NumberInRange.checkFloat(number);
            ret = Float.valueOf(((Number)number).floatValue());
        } else if (type.equals(Integer.class)) {
            BigInteger number = new BigInteger(value);
            NumberInRange.checkInteger(number);
            ret = ((Number)number).intValue();
        } else if (type.equals(Long.class)) {
            BigInteger number = new BigInteger(value);
            NumberInRange.checkLong(number);
            ret = ((Number)number).longValue();
        } else if (type.equals(Short.class)) {
            BigInteger number = new BigInteger(value);
            NumberInRange.checkShort(number);
            ret = number.shortValue();
        } else if (type.equals(BigInteger.class)) {
            ret = new BigInteger(value);
        } else if (type.equals(BigDecimal.class)) {
            ret = new BigDecimal(value);
        } else {
            throw new IllegalNumberArgumentException("Return value is no known subclass of 'java.lang.Number': " + type.getName());
        }
        return ret;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalArgumentNotContainedException.class})
    public static <T> T contains(@Nonnull Collection<T> haystack, @Nonnull T needle) {
        Check.notNull(haystack, "haystack");
        Check.notNull(needle, "needle");
        if (!haystack.contains(needle)) {
            throw new IllegalArgumentNotContainedException();
        }
        return needle;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalArgumentNotContainedException.class})
    public static <T> T contains(@Nonnull Collection<T> haystack, @Nonnull T needle, @Nonnull String name) {
        Check.notNull(haystack, "haystack");
        Check.notNull(needle, "needle");
        if (!haystack.contains(needle)) {
            throw new IllegalArgumentNotContainedException(name);
        }
        return needle;
    }

    private static boolean containsNullElements(@Nonnull Object[] array) {
        boolean containsNull = false;
        for (Object o : array) {
            if (o != null) continue;
            containsNull = true;
            break;
        }
        return containsNull;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static boolean equals(@Nonnull boolean expected, @Nonnull boolean check) {
        if (expected != check) {
            throw new IllegalNotEqualException();
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static boolean equals(@Nonnull boolean expected, @Nonnull boolean check, String message) {
        if (expected != check) {
            throw new IllegalNotEqualException(message);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static byte equals(@Nonnull byte expected, @Nonnull byte check) {
        if (expected != check) {
            throw new IllegalNotEqualException();
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static byte equals(@Nonnull byte expected, @Nonnull byte check, String message) {
        if (expected != check) {
            throw new IllegalNotEqualException(message);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static char equals(@Nonnull char expected, @Nonnull char check) {
        if (expected != check) {
            throw new IllegalNotEqualException();
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static char equals(@Nonnull char expected, @Nonnull char check, String message) {
        if (expected != check) {
            throw new IllegalNotEqualException(message);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static int equals(@Nonnull int expected, @Nonnull int check) {
        if (expected != check) {
            throw new IllegalNotEqualException();
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static int equals(@Nonnull int expected, @Nonnull int check, String message) {
        if (expected != check) {
            throw new IllegalNotEqualException(message);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static long equals(@Nonnull long expected, @Nonnull long check) {
        if (expected != check) {
            throw new IllegalNotEqualException();
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static long equals(@Nonnull long expected, @Nonnull long check, String message) {
        if (expected != check) {
            throw new IllegalNotEqualException(message);
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static short equals(@Nonnull short expected, @Nonnull short check) {
        if (expected != check) {
            throw new IllegalNotEqualException();
        }
        return check;
    }

    @Throws(value={IllegalNotEqualException.class})
    public static short equals(@Nonnull short expected, @Nonnull short check, String message) {
        if (expected != check) {
            throw new IllegalNotEqualException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotEqualException.class})
    public static <T extends Comparable<T>> T equals(@Nonnull T expected, @Nonnull T check) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (expected.compareTo(check) != 0) {
            throw new IllegalNotEqualException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotEqualException.class})
    public static <T> T equals(@Nonnull T expected, @Nonnull T check) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (!expected.equals(check)) {
            throw new IllegalNotEqualException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotEqualException.class})
    public static <T extends Comparable<T>> T equals(@Nonnull T expected, @Nonnull T check, String message) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (expected.compareTo(check) != 0) {
            throw new IllegalNotEqualException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotEqualException.class})
    public static <T> T equals(@Nonnull T expected, @Nonnull T check, String message) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (!expected.equals(check)) {
            throw new IllegalNotEqualException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotGreaterOrEqualThanException.class})
    public static <T extends Comparable<T>> T greaterOrEqualThan(@Nonnull T expected, @Nonnull T check) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (expected.compareTo(check) > 0) {
            throw new IllegalNotGreaterOrEqualThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotGreaterOrEqualThanException.class})
    public static <T extends Comparable<T>> T greaterOrEqualThan(@Nonnull T expected, @Nonnull T check, String message) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (expected.compareTo(check) > 0) {
            throw new IllegalNotGreaterOrEqualThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotGreaterThanException.class})
    public static byte greaterThan(@Nonnull byte expected, @Nonnull byte check) {
        if (expected >= check) {
            throw new IllegalNotGreaterThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotGreaterThanException.class})
    public static byte greaterThan(@Nonnull byte expected, @Nonnull byte check, String message) {
        if (expected >= check) {
            throw new IllegalNotGreaterThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotGreaterThanException.class})
    public static char greaterThan(@Nonnull char expected, @Nonnull char check) {
        if (expected >= check) {
            throw new IllegalNotGreaterThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotGreaterThanException.class})
    public static char greaterThan(@Nonnull char expected, @Nonnull char check, String message) {
        if (expected >= check) {
            throw new IllegalNotGreaterThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotGreaterThanException.class})
    public static double greaterThan(@Nonnull double expected, @Nonnull double check) {
        if (expected >= check) {
            throw new IllegalNotGreaterThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotGreaterThanException.class})
    public static double greaterThan(@Nonnull double expected, @Nonnull double check, String message) {
        if (expected >= check) {
            throw new IllegalNotGreaterThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotGreaterThanException.class})
    public static float greaterThan(@Nonnull float expected, @Nonnull float check) {
        if (expected >= check) {
            throw new IllegalNotGreaterThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotGreaterThanException.class})
    public static float greaterThan(@Nonnull float expected, @Nonnull float check, String message) {
        if (expected >= check) {
            throw new IllegalNotGreaterThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotGreaterThanException.class})
    public static int greaterThan(@Nonnull int expected, @Nonnull int check) {
        if (expected >= check) {
            throw new IllegalNotGreaterThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotGreaterThanException.class})
    public static int greaterThan(@Nonnull int expected, @Nonnull int check, String message) {
        if (expected >= check) {
            throw new IllegalNotGreaterThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotGreaterThanException.class})
    public static long greaterThan(@Nonnull long expected, @Nonnull long check) {
        if (expected >= check) {
            throw new IllegalNotGreaterThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotGreaterThanException.class})
    public static long greaterThan(@Nonnull long expected, @Nonnull long check, String message) {
        if (expected >= check) {
            throw new IllegalNotGreaterThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotGreaterThanException.class})
    public static short greaterThan(@Nonnull short expected, @Nonnull short check) {
        if (expected >= check) {
            throw new IllegalNotGreaterThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotGreaterThanException.class})
    public static short greaterThan(@Nonnull short expected, @Nonnull short check, String message) {
        if (expected >= check) {
            throw new IllegalNotGreaterThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotGreaterThanException.class})
    public static <T extends Comparable<T>> T greaterThan(@Nonnull T expected, @Nonnull T check) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (expected.compareTo(check) >= 0) {
            throw new IllegalNotGreaterThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotGreaterThanException.class})
    public static <T extends Comparable<T>> T greaterThan(@Nonnull T expected, @Nonnull T check, String message) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (expected.compareTo(check) >= 0) {
            throw new IllegalNotGreaterThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalMissingAnnotationException.class})
    public static Annotation hasAnnotation(@Nonnull Class<?> clazz, @Nonnull Class<? extends Annotation> annotation) {
        Check.notNull(clazz, "clazz");
        Check.notNull(annotation, "annotation");
        if (!clazz.isAnnotationPresent(annotation)) {
            throw new IllegalMissingAnnotationException(annotation, clazz);
        }
        return clazz.getAnnotation(annotation);
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalInstanceOfArgumentException.class})
    public static <T> T instanceOf(@Nonnull Class<?> type, @Nonnull Object obj) {
        return Check.instanceOf(type, obj, EMPTY_ARGUMENT_NAME);
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalInstanceOfArgumentException.class})
    public static <T> T instanceOf(@Nonnull Class<?> type, @Nonnull Object obj, @Nullable String name) {
        Check.notNull(type, "type");
        Check.notNull(obj, "obj");
        if (!type.isInstance(obj)) {
            throw new IllegalInstanceOfArgumentException(name, type, obj.getClass());
        }
        return (T)obj;
    }

    @Throws(value={IllegalNotNullArgumentException.class})
    public static void isNull(@Nullable Object reference) {
        if (reference != null) {
            throw new IllegalNotNullArgumentException();
        }
    }

    @Throws(value={IllegalNotNullArgumentException.class})
    public static void isNull(@Nullable Object reference, @Nullable String name) {
        if (reference != null) {
            throw new IllegalNotNullArgumentException(name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static int isNumber(@Nonnull String value) {
        Check.notNull(value, "value");
        return Check.isNumber(value, Integer.class);
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static <T extends Number> T isNumber(@Nonnull String value, @Nonnull Class<T> type) {
        return Check.isNumber(value, null, type);
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static int isNumber(@Nonnull String value, @Nullable String name) {
        Check.notNull(value, "value");
        return Check.isNumber(value, name, Integer.class);
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static <T extends Number> T isNumber(@Nonnull String value, @Nullable String name, @Nonnull Class<T> type) {
        Number ret;
        Check.notNull(value, "value");
        Check.notNull(type, "type");
        try {
            ret = Check.checkNumberInRange(value, type);
        }
        catch (NumberFormatException nfe) {
            if (name == null) {
                throw new IllegalNumberArgumentException(nfe);
            }
            throw new IllegalNumberArgumentException(name, nfe);
        }
        return (T)((Number)type.cast(ret));
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumberArgumentException.class})
    public static <T extends CharSequence> T isNumeric(@Nonnull T value) {
        return Check.isNumeric(value, EMPTY_ARGUMENT_NAME);
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNumericArgumentException.class})
    public static <T extends CharSequence> T isNumeric(@Nonnull T value, @Nullable String name) {
        Check.notNull(value, "value");
        if (!Check.matches(NumericRegularExpressionHolder.getPattern(), value)) {
            throw new IllegalNumericArgumentException(name);
        }
        return value;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotLesserThanException.class})
    public static byte lesserThan(@Nonnull byte expected, @Nonnull byte check) {
        if (expected <= check) {
            throw new IllegalNotLesserThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotLesserThanException.class})
    public static byte lesserThan(@Nonnull byte expected, @Nonnull byte check, String message) {
        if (expected <= check) {
            throw new IllegalNotLesserThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotLesserThanException.class})
    public static char lesserThan(@Nonnull char expected, @Nonnull char check) {
        if (expected <= check) {
            throw new IllegalNotLesserThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotLesserThanException.class})
    public static char lesserThan(@Nonnull char expected, @Nonnull char check, String message) {
        if (expected <= check) {
            throw new IllegalNotLesserThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotLesserThanException.class})
    public static double lesserThan(@Nonnull double expected, @Nonnull double check) {
        if (expected <= check) {
            throw new IllegalNotLesserThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotLesserThanException.class})
    public static double lesserThan(@Nonnull double expected, @Nonnull double check, String message) {
        if (expected <= check) {
            throw new IllegalNotLesserThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotLesserThanException.class})
    public static float lesserThan(@Nonnull float expected, @Nonnull float check) {
        if (expected <= check) {
            throw new IllegalNotLesserThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotLesserThanException.class})
    public static float lesserThan(@Nonnull float expected, @Nonnull float check, String message) {
        if (expected <= check) {
            throw new IllegalNotLesserThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotLesserThanException.class})
    public static int lesserThan(@Nonnull int expected, @Nonnull int check) {
        if (expected <= check) {
            throw new IllegalNotLesserThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotLesserThanException.class})
    public static int lesserThan(@Nonnull int expected, @Nonnull int check, String message) {
        if (expected <= check) {
            throw new IllegalNotLesserThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotLesserThanException.class})
    public static long lesserThan(@Nonnull long expected, @Nonnull long check) {
        if (expected <= check) {
            throw new IllegalNotLesserThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotLesserThanException.class})
    public static long lesserThan(@Nonnull long expected, @Nonnull long check, String message) {
        if (expected <= check) {
            throw new IllegalNotLesserThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotLesserThanException.class})
    public static short lesserThan(@Nonnull short expected, @Nonnull short check) {
        if (expected <= check) {
            throw new IllegalNotLesserThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotLesserThanException.class})
    public static short lesserThan(@Nonnull short expected, @Nonnull short check, String message) {
        if (expected <= check) {
            throw new IllegalNotLesserThanException(message);
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotLesserThanException.class})
    public static <T extends Comparable<T>> T lesserThan(@Nonnull T expected, @Nonnull T check) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (expected.compareTo(check) <= 0) {
            throw new IllegalNotLesserThanException();
        }
        return check;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNotLesserThanException.class})
    public static <T extends Comparable<T>> T lesserThan(@Nonnull T expected, @Nonnull T check, String message) {
        Check.notNull(expected, "expected");
        Check.notNull(check, "check");
        if (expected.compareTo(check) <= 0) {
            throw new IllegalNotLesserThanException(message);
        }
        return check;
    }

    private static boolean matches(@Nonnull Pattern pattern, @Nonnull CharSequence chars) {
        return pattern.matcher(chars).matches();
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalPatternArgumentException.class})
    public static <T extends CharSequence> T matchesPattern(@Nonnull Pattern pattern, @Nonnull T chars) {
        return Check.matchesPattern(pattern, chars, EMPTY_ARGUMENT_NAME);
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalPatternArgumentException.class})
    public static <T extends CharSequence> T matchesPattern(@Nonnull Pattern pattern, @Nonnull T chars, @Nullable String name) {
        Check.notNull(pattern, "pattern");
        Check.notNull(chars, "chars");
        if (!Check.matches(pattern, chars)) {
            throw new IllegalPatternArgumentException(name, pattern);
        }
        return chars;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNullElementsException.class})
    public static <T extends Iterable<?>> T noNullElements(@Nonnull T iterable) {
        return Check.noNullElements(iterable, EMPTY_ARGUMENT_NAME);
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNullElementsException.class})
    public static <T extends Iterable<?>> T noNullElements(@Nonnull T iterable, String name) {
        Check.notNull(iterable, "iterable");
        for (Object element : iterable) {
            if (element != null) continue;
            throw new IllegalNullElementsException(name);
        }
        return iterable;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNullElementsException.class})
    public static <T> T[] noNullElements(@Nonnull T[] array) {
        return Check.noNullElements(array, EMPTY_ARGUMENT_NAME);
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalNullElementsException.class})
    public static <T> T[] noNullElements(@Nonnull T[] array, @Nullable String name) {
        Check.notNull(array, "array");
        if (Check.containsNullElements(array)) {
            throw new IllegalNullElementsException(name);
        }
        return array;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static void notEmpty(boolean expression) {
        Check.notEmpty(expression, EMPTY_ARGUMENT_NAME);
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static void notEmpty(boolean expression, @Nullable String name) {
        if (expression) {
            throw new IllegalEmptyArgumentException(name);
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends CharSequence> T notEmpty(@Nonnull T chars) {
        Check.notNull(chars);
        Check.notEmpty(chars, chars.length() == 0, EMPTY_ARGUMENT_NAME);
        return chars;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Collection<?>> T notEmpty(@Nonnull T collection) {
        Check.notNull(collection);
        Check.notEmpty(collection, collection.isEmpty(), EMPTY_ARGUMENT_NAME);
        return collection;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Map<?, ?>> T notEmpty(@Nonnull T map) {
        Check.notNull(map);
        Check.notEmpty(map, map.isEmpty(), EMPTY_ARGUMENT_NAME);
        return map;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> T notEmpty(@Nonnull T reference, boolean expression, @Nullable String name) {
        Check.notNull(reference, name);
        if (expression) {
            throw new IllegalEmptyArgumentException(name);
        }
        return reference;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends CharSequence> T notEmpty(@Nonnull T chars, @Nullable String name) {
        Check.notNull(chars, name);
        Check.notEmpty(chars, chars.length() == 0, name);
        return chars;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Map<?, ?>> T notEmpty(@Nonnull T map, @Nullable String name) {
        Check.notNull(map);
        Check.notEmpty(map, map.isEmpty(), name);
        return map;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T extends Collection<?>> T notEmpty(@Nonnull T collection, @Nullable String name) {
        Check.notNull(collection, name);
        Check.notEmpty(collection, collection.isEmpty(), name);
        return collection;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> T[] notEmpty(@Nonnull T[] array) {
        Check.notNull(array);
        Check.notEmpty(array, array.length == 0, EMPTY_ARGUMENT_NAME);
        return array;
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, IllegalEmptyArgumentException.class})
    public static <T> T[] notEmpty(@Nonnull T[] array, @Nullable String name) {
        Check.notNull(array);
        Check.notEmpty(array, array.length == 0, EMPTY_ARGUMENT_NAME);
        return array;
    }

    public static <T> T nothing(T t) {
        return t;
    }

    @Throws(value={IllegalNaNArgumentException.class})
    public static double notNaN(double value) {
        return Check.notNaN(value, EMPTY_ARGUMENT_NAME);
    }

    @Throws(value={IllegalNaNArgumentException.class})
    public static double notNaN(double value, @Nullable String name) {
        if (value != value) {
            throw new IllegalNaNArgumentException(name);
        }
        return value;
    }

    @Throws(value={IllegalNaNArgumentException.class})
    public static float notNaN(float value) {
        return Check.notNaN(value, EMPTY_ARGUMENT_NAME);
    }

    @Throws(value={IllegalNaNArgumentException.class})
    public static float notNaN(float value, @Nullable String name) {
        if (value != value) {
            throw new IllegalNaNArgumentException(name);
        }
        return value;
    }

    @Throws(value={IllegalNegativeArgumentException.class})
    public static double notNegative(@Nonnull double value) {
        if (value < 0.0) {
            throw new IllegalNegativeArgumentException();
        }
        return value;
    }

    @Throws(value={IllegalNegativeArgumentException.class})
    public static double notNegative(@Nonnull double value, @Nullable String name) {
        if (value < 0.0) {
            throw new IllegalNegativeArgumentException(name);
        }
        return value;
    }

    @Throws(value={IllegalNegativeArgumentException.class})
    public static float notNegative(@Nonnull float value) {
        if (value < 0.0f) {
            throw new IllegalNegativeArgumentException();
        }
        return value;
    }

    @Throws(value={IllegalNegativeArgumentException.class})
    public static float notNegative(@Nonnull float value, @Nullable String name) {
        if (value < 0.0f) {
            throw new IllegalNegativeArgumentException(name);
        }
        return value;
    }

    @Throws(value={IllegalNegativeArgumentException.class})
    public static int notNegative(@Nonnull int value) {
        if (value < 0) {
            throw new IllegalNegativeArgumentException();
        }
        return value;
    }

    @Throws(value={IllegalNegativeArgumentException.class})
    public static int notNegative(@Nonnull int value, @Nullable String name) {
        if (value < 0) {
            throw new IllegalNegativeArgumentException(name);
        }
        return value;
    }

    @Throws(value={IllegalNegativeArgumentException.class})
    public static long notNegative(@Nonnull long value) {
        if (value < 0L) {
            throw new IllegalNegativeArgumentException();
        }
        return value;
    }

    @Throws(value={IllegalNegativeArgumentException.class})
    public static long notNegative(@Nonnull long value, @Nullable String name) {
        if (value < 0L) {
            throw new IllegalNegativeArgumentException(name);
        }
        return value;
    }

    @Throws(value={IllegalNegativeArgumentException.class})
    public static short notNegative(@Nonnull short value) {
        if (value < 0) {
            throw new IllegalNegativeArgumentException();
        }
        return value;
    }

    @Throws(value={IllegalNegativeArgumentException.class})
    public static short notNegative(@Nonnull short value, @Nullable String name) {
        if (value < 0) {
            throw new IllegalNegativeArgumentException(name);
        }
        return value;
    }

    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T notNull(@Nonnull T reference) {
        if (reference == null) {
            throw new IllegalNullArgumentException();
        }
        return reference;
    }

    @Throws(value={IllegalNullArgumentException.class})
    public static <T> T notNull(@Nonnull T reference, @Nullable String name) {
        if (reference == null) {
            throw new IllegalNullArgumentException(name);
        }
        return reference;
    }

    @Throws(value={IllegalPositiveArgumentException.class})
    public static double notPositive(@Nonnull double value) {
        if (value > 0.0) {
            throw new IllegalPositiveArgumentException();
        }
        return value;
    }

    @Throws(value={IllegalPositiveArgumentException.class})
    public static double notPositive(@Nonnull double value, @Nullable String name) {
        if (value > 0.0) {
            throw new IllegalPositiveArgumentException(name);
        }
        return value;
    }

    @Throws(value={IllegalPositiveArgumentException.class})
    public static float notPositive(@Nonnull float value) {
        if (value > 0.0f) {
            throw new IllegalPositiveArgumentException();
        }
        return value;
    }

    @Throws(value={IllegalPositiveArgumentException.class})
    public static float notPositive(@Nonnull float value, @Nullable String name) {
        if (value > 0.0f) {
            throw new IllegalPositiveArgumentException(name);
        }
        return value;
    }

    @Throws(value={IllegalPositiveArgumentException.class})
    public static int notPositive(@Nonnull int value) {
        if (value > 0) {
            throw new IllegalPositiveArgumentException();
        }
        return value;
    }

    @Throws(value={IllegalPositiveArgumentException.class})
    public static int notPositive(@Nonnull int value, @Nullable String name) {
        if (value > 0) {
            throw new IllegalPositiveArgumentException(name);
        }
        return value;
    }

    @Throws(value={IllegalPositiveArgumentException.class})
    public static long notPositive(@Nonnull long value) {
        if (value > 0L) {
            throw new IllegalPositiveArgumentException();
        }
        return value;
    }

    @Throws(value={IllegalPositiveArgumentException.class})
    public static long notPositive(@Nonnull long value, @Nullable String name) {
        if (value > 0L) {
            throw new IllegalPositiveArgumentException(name);
        }
        return value;
    }

    @Throws(value={IllegalPositiveArgumentException.class})
    public static short notPositive(@Nonnull short value) {
        if (value > 0) {
            throw new IllegalPositiveArgumentException();
        }
        return value;
    }

    @Throws(value={IllegalPositiveArgumentException.class})
    public static short notPositive(@Nonnull short value, @Nullable String name) {
        if (value > 0) {
            throw new IllegalPositiveArgumentException(name);
        }
        return value;
    }

    @Throws(value={IllegalPositionIndexException.class})
    public static int positionIndex(int index, int size) {
        boolean isIndexValid;
        boolean bl = isIndexValid = size >= 0 && index >= 0 && index < size;
        if (!isIndexValid) {
            throw new IllegalPositionIndexException(index, size);
        }
        return index;
    }

    @Throws(value={IllegalRangeException.class})
    public static void range(@Nonnegative int start, @Nonnegative int end, @Nonnegative int size) {
        boolean inputValuesAreValid;
        boolean rangeIsValid = start <= size && end <= size && start <= end;
        boolean bl = inputValuesAreValid = size >= 0 && start >= 0 && end >= 0;
        if (!rangeIsValid || !inputValuesAreValid) {
            throw new IllegalRangeException(start, end, size);
        }
    }

    @Throws(value={IllegalStateOfArgumentException.class})
    public static void stateIsTrue(boolean expression) {
        if (!expression) {
            throw new IllegalStateOfArgumentException();
        }
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class, RuntimeInstantiationException.class})
    public static void stateIsTrue(boolean expression, Class<? extends RuntimeException> clazz) {
        Check.notNull(clazz, "clazz");
        if (!expression) {
            RuntimeException re;
            try {
                re = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeInstantiationException(clazz.getSimpleName(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeInstantiationException(clazz.getSimpleName(), e);
            }
            throw re;
        }
    }

    @Throws(value={IllegalStateOfArgumentException.class})
    public static void stateIsTrue(boolean expression, @Nonnull String description) {
        if (!expression) {
            throw new IllegalStateOfArgumentException(description);
        }
    }

    @Throws(value={IllegalStateOfArgumentException.class})
    public static void stateIsTrue(boolean expression, @Nonnull String descriptionTemplate, Object ... descriptionTemplateArgs) {
        if (!expression) {
            throw new IllegalStateOfArgumentException(descriptionTemplate, descriptionTemplateArgs);
        }
    }

    private Check() {
    }

    protected static final class NumericRegularExpressionHolder {
        private static final Pattern NUMERIC_REGEX = Pattern.compile("[0-9]+");

        protected NumericRegularExpressionHolder() {
        }

        @Nonnull
        public static Pattern getPattern() {
            return NUMERIC_REGEX;
        }
    }
}

