/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.AbstractCompleteCheckpointStore;
import org.apache.flink.runtime.checkpoint.CheckpointSubsumeHelper;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.jobgraph.RestoreMode;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryFactory;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneCompletedCheckpointStore
extends AbstractCompleteCheckpointStore {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneCompletedCheckpointStore.class);
    private final int maxNumberOfCheckpointsToRetain;
    private final ArrayDeque<CompletedCheckpoint> checkpoints;
    private final Executor ioExecutor;

    @VisibleForTesting
    public StandaloneCompletedCheckpointStore(int maxNumberOfCheckpointsToRetain) {
        this(maxNumberOfCheckpointsToRetain, SharedStateRegistry.DEFAULT_FACTORY, Executors.directExecutor(), RestoreMode.DEFAULT);
    }

    public StandaloneCompletedCheckpointStore(int maxNumberOfCheckpointsToRetain, SharedStateRegistryFactory sharedStateRegistryFactory, Executor ioExecutor, RestoreMode restoreMode) {
        this(maxNumberOfCheckpointsToRetain, sharedStateRegistryFactory, new ArrayDeque<CompletedCheckpoint>(maxNumberOfCheckpointsToRetain + 1), ioExecutor, restoreMode);
    }

    private StandaloneCompletedCheckpointStore(int maxNumberOfCheckpointsToRetain, SharedStateRegistryFactory sharedStateRegistryFactory, ArrayDeque<CompletedCheckpoint> checkpoints, Executor ioExecutor, RestoreMode restoreMode) {
        super(sharedStateRegistryFactory.create(ioExecutor, checkpoints, restoreMode));
        Preconditions.checkArgument((maxNumberOfCheckpointsToRetain >= 1 ? 1 : 0) != 0, (Object)"Must retain at least one checkpoint.");
        this.maxNumberOfCheckpointsToRetain = maxNumberOfCheckpointsToRetain;
        this.checkpoints = checkpoints;
        this.ioExecutor = (Executor)Preconditions.checkNotNull((Object)ioExecutor);
    }

    @Override
    @Nullable
    public CompletedCheckpoint addCheckpointAndSubsumeOldestOne(CompletedCheckpoint checkpoint, CheckpointsCleaner checkpointsCleaner, Runnable postCleanup) throws Exception {
        this.checkpoints.addLast(checkpoint);
        CompletedCheckpoint completedCheckpoint = CheckpointSubsumeHelper.subsume(this.checkpoints, this.maxNumberOfCheckpointsToRetain, cc -> {
            cc.markAsDiscardedOnSubsume();
            checkpointsCleaner.addSubsumedCheckpoint(cc);
        }).orElse(null);
        StandaloneCompletedCheckpointStore.findLowest(this.checkpoints).ifPresent(id -> checkpointsCleaner.cleanSubsumedCheckpoints((long)id, this.getSharedStateRegistry().unregisterUnusedState((long)id), postCleanup, this.ioExecutor));
        return completedCheckpoint;
    }

    @Override
    public List<CompletedCheckpoint> getAllCheckpoints() {
        return new ArrayList<CompletedCheckpoint>(this.checkpoints);
    }

    @Override
    public int getNumberOfRetainedCheckpoints() {
        return this.checkpoints.size();
    }

    @Override
    public int getMaxNumberOfRetainedCheckpoints() {
        return this.maxNumberOfCheckpointsToRetain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(JobStatus jobStatus, CheckpointsCleaner checkpointsCleaner) throws Exception {
        super.shutdown(jobStatus, checkpointsCleaner);
        try {
            LOG.info("Shutting down");
            long lowestRetained = Long.MAX_VALUE;
            for (CompletedCheckpoint checkpoint : this.checkpoints) {
                if (checkpoint.shouldBeDiscardedOnShutdown(jobStatus)) {
                    checkpoint.markAsDiscardedOnShutdown(jobStatus).discard();
                    continue;
                }
                LOG.info("Checkpoint with ID {} at '{}' not discarded.", (Object)checkpoint.getCheckpointID(), (Object)checkpoint.getExternalPointer());
                lowestRetained = Math.min(checkpoint.getCheckpointID(), lowestRetained);
            }
            if (jobStatus.isGloballyTerminalState()) {
                checkpointsCleaner.cleanSubsumedCheckpoints(lowestRetained, this.getSharedStateRegistry().unregisterUnusedState(lowestRetained), () -> {}, this.ioExecutor);
            }
        }
        finally {
            this.checkpoints.clear();
        }
    }

    @Override
    public boolean requiresExternalizedCheckpoints() {
        return false;
    }
}

