/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.util.Random;

class Range<T extends Number> {
    private static final String SEP = ",";
    private T min;
    private T max;

    Range(T min, T max) {
        this.min = min;
        this.max = max;
    }

    T getLower() {
        return (T)this.min;
    }

    T getUpper() {
        return (T)this.max;
    }

    public String toString() {
        return this.min + SEP + this.max;
    }

    static long betweenPositive(Random rnd, Range<Long> range) {
        if (((Long)range.getLower()).equals(range.getUpper())) {
            return (Long)range.getLower();
        }
        long nextRnd = rnd.nextLong();
        long normRange = (Long)range.getUpper() - (Long)range.getLower() + 1L;
        return Math.abs(nextRnd % normRange) + (Long)range.getLower();
    }
}

