/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.TestMiniMRChildTask;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.util.Shell;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMiniMRChildTask {
    private static final Log LOG = LogFactory.getLog((String)TestMiniMRChildTask.class.getName());
    private static final String OLD_CONFIGS = "test.old.configs";
    private static final String TASK_OPTS_VAL = "-Xmx200m";
    private static final String MAP_OPTS_VAL = "-Xmx200m";
    private static final String REDUCE_OPTS_VAL = "-Xmx300m";
    private static MiniMRYarnCluster mr;
    private static MiniDFSCluster dfs;
    private static FileSystem fileSys;
    private static Configuration conf;
    private static FileSystem localFs;
    private static Path TEST_ROOT_DIR;
    static Path APP_JAR;

    private void configure(JobConf conf, Path inDir, Path outDir, String input, Class<? extends Mapper> map, Class<? extends Reducer> reduce) throws IOException {
        FileSystem inFs = inDir.getFileSystem((Configuration)conf);
        FileSystem outFs = outDir.getFileSystem((Configuration)conf);
        outFs.delete(outDir, true);
        if (!inFs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = inFs.create(new Path(inDir, "part-0"));
        file.writeBytes(input);
        file.close();
        conf.setJobName("testmap");
        conf.setMapperClass(map);
        conf.setReducerClass(reduce);
        conf.setNumMapTasks(1);
        conf.setNumReduceTasks(0);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
        conf.set("test.build.data", TEST_ROOT_DIR);
    }

    public void launchTest(JobConf conf, Path inDir, Path outDir, String input) throws IOException, InterruptedException, ClassNotFoundException {
        FileSystem outFs = outDir.getFileSystem((Configuration)conf);
        Job job = Job.getInstance((Configuration)conf);
        job.addFileToClassPath(APP_JAR);
        job.setJarByClass(TestMiniMRChildTask.class);
        job.setMaxMapAttempts(1);
        job.waitForCompletion(true);
        boolean succeeded = job.waitForCompletion(true);
        Assert.assertTrue((boolean)succeeded);
        outFs.delete(outDir, true);
    }

    private static void checkEnv(String envName, String expValue, String mode) {
        String envValue = System.getenv(envName).trim();
        if ("append".equals(mode)) {
            if (envValue == null || !envValue.contains(File.pathSeparator)) {
                throw new RuntimeException("Missing env variable");
            }
            String[] parts = envValue.split(File.pathSeparator);
            if (!parts[parts.length - 1].equals(expValue)) {
                throw new RuntimeException("Wrong env variable in append mode");
            }
        } else if (envValue == null || !envValue.equals(expValue)) {
            throw new RuntimeException("Wrong env variable in noappend mode");
        }
    }

    @BeforeClass
    public static void setup() throws IOException {
        dfs = new MiniDFSCluster.Builder(conf).build();
        fileSys = dfs.getFileSystem();
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        if (mr == null) {
            mr = new MiniMRYarnCluster(TestMiniMRChildTask.class.getName());
            Configuration conf = new Configuration();
            mr.init(conf);
            mr.start();
        }
        localFs.copyFromLocalFile(new Path(MiniMRYarnCluster.APPJAR), APP_JAR);
        localFs.setPermission(APP_JAR, new FsPermission("700"));
    }

    @AfterClass
    public static void tearDown() {
        try {
            if (fileSys != null) {
                fileSys.close();
            }
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.stop();
                mr = null;
            }
        }
        catch (IOException ioe) {
            LOG.info((Object)"IO exception in closing file system)");
            ioe.printStackTrace();
        }
    }

    @Test
    public void testMapRedExecutionEnv() {
        try {
            HashMap environment = new HashMap();
            String setupHadoopHomeCommand = Shell.WINDOWS ? "HADOOP_COMMON_HOME=C:\\fake\\PATH\\to\\hadoop\\common\\home" : "HADOOP_COMMON_HOME=/fake/path/to/hadoop/common/home";
            MRApps.setEnvFromInputString(environment, (String)setupHadoopHomeCommand, (Configuration)conf);
            MRApps.setEnvFromInputString(environment, (String)conf.get("mapreduce.admin.user.env", MRJobConfig.DEFAULT_MAPRED_ADMIN_USER_ENV), (Configuration)conf);
            String executionPaths = (String)environment.get(Shell.WINDOWS ? "PATH" : "LD_LIBRARY_PATH");
            String toFind = Shell.WINDOWS ? "C:\\fake\\PATH\\to\\hadoop\\common\\home\\bin" : "/fake/path/to/hadoop/common/home/lib/native";
            Assert.assertTrue((String)("execution path does not include the hadoop lib location " + toFind), (boolean)executionPaths.contains(toFind));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception in testing execution environment for MapReduce task");
            TestMiniMRChildTask.tearDown();
        }
        try {
            JobConf conf = new JobConf(mr.getConfig());
            Path inDir = new Path("input");
            Path outDir = new Path("output");
            String input = "The input";
            this.configure(conf, inDir, outDir, input, ExecutionEnvCheckMapClass.class, IdentityReducer.class);
            this.launchTest(conf, inDir, outDir, input);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception in testing propagation of env setting to child task");
            TestMiniMRChildTask.tearDown();
        }
    }

    @Test
    public void testTaskEnv() {
        try {
            JobConf conf = new JobConf(mr.getConfig());
            Path inDir = new Path("testing/wc/input1");
            Path outDir = new Path("testing/wc/output1");
            FileSystem outFs = outDir.getFileSystem((Configuration)conf);
            this.runTestTaskEnv(conf, inDir, outDir, false);
            outFs.delete(outDir, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception in testing child env");
            TestMiniMRChildTask.tearDown();
        }
    }

    @Test
    public void testTaskOldEnv() {
        try {
            JobConf conf = new JobConf(mr.getConfig());
            Path inDir = new Path("testing/wc/input1");
            Path outDir = new Path("testing/wc/output1");
            FileSystem outFs = outDir.getFileSystem((Configuration)conf);
            this.runTestTaskEnv(conf, inDir, outDir, true);
            outFs.delete(outDir, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception in testing child env");
            TestMiniMRChildTask.tearDown();
        }
    }

    void runTestTaskEnv(JobConf conf, Path inDir, Path outDir, boolean oldConfigs) throws IOException, InterruptedException, ClassNotFoundException {
        String input = "The input";
        this.configure(conf, inDir, outDir, input, EnvCheckMapper.class, EnvCheckReducer.class);
        String mapTaskEnvKey = "mapreduce.map.env";
        String reduceTaskEnvKey = "mapreduce.map.env";
        String mapTaskJavaOptsKey = "mapreduce.map.java.opts";
        String reduceTaskJavaOptsKey = "mapreduce.reduce.java.opts";
        String mapTaskJavaOpts = "-Xmx200m";
        String reduceTaskJavaOpts = "-Xmx300m";
        conf.setBoolean("test.old.configs", oldConfigs);
        if (oldConfigs) {
            reduceTaskEnvKey = "mapred.child.env";
            mapTaskEnvKey = "mapred.child.env";
            reduceTaskJavaOptsKey = "mapred.child.java.opts";
            mapTaskJavaOptsKey = "mapred.child.java.opts";
            reduceTaskJavaOpts = "-Xmx200m";
            mapTaskJavaOpts = "-Xmx200m";
        }
        conf.set(mapTaskEnvKey, Shell.WINDOWS ? "MY_PATH=/tmp,LANG=en_us_8859_1,LD_LIBRARY_PATH=%LD_LIBRARY_PATH%;/tmp,PATH=%PATH%;/tmp,NEW_PATH=%NEW_PATH%;/tmp" : "MY_PATH=/tmp,LANG=en_us_8859_1,LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/tmp,PATH=$PATH:/tmp,NEW_PATH=$NEW_PATH:/tmp");
        conf.set(reduceTaskEnvKey, Shell.WINDOWS ? "MY_PATH=/tmp,LANG=en_us_8859_1,LD_LIBRARY_PATH=%LD_LIBRARY_PATH%;/tmp,PATH=%PATH%;/tmp,NEW_PATH=%NEW_PATH%;/tmp" : "MY_PATH=/tmp,LANG=en_us_8859_1,LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/tmp,PATH=$PATH:/tmp,NEW_PATH=$NEW_PATH:/tmp");
        conf.set("path", System.getenv("PATH"));
        conf.set(mapTaskJavaOptsKey, mapTaskJavaOpts);
        conf.set(reduceTaskJavaOptsKey, reduceTaskJavaOpts);
        Job job = Job.getInstance((Configuration)conf);
        job.addFileToClassPath(APP_JAR);
        job.setJarByClass(TestMiniMRChildTask.class);
        job.setMaxMapAttempts(1);
        job.waitForCompletion(true);
        boolean succeeded = job.waitForCompletion(true);
        Assert.assertTrue((String)"The environment checker job failed.", (boolean)succeeded);
    }

    static /* synthetic */ FileSystem access$000() {
        return localFs;
    }

    static /* synthetic */ FileSystem access$002(FileSystem x0) {
        localFs = x0;
        return localFs;
    }

    static /* synthetic */ void access$100(String x0, String x1, String x2) {
        TestMiniMRChildTask.checkEnv((String)x0, (String)x1, (String)x2);
    }

    static {
        conf = new Configuration();
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
        TEST_ROOT_DIR = new Path("target", TestMiniMRChildTask.class.getName() + "-tmpDir").makeQualified(localFs);
        APP_JAR = new Path(TEST_ROOT_DIR, "MRAppJar.jar");
    }
}

