/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.LargeSorter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class LargeSorter
extends Configured
implements Tool {
    private static final String LS_PREFIX = "mapreduce.large-sorter.";
    public static final String MBS_PER_MAP = "mapreduce.large-sorter.mbs-per-map";
    public static final String NUM_MAP_TASKS = "mapreduce.large-sorter.map-tasks";
    public static final String NUM_REDUCE_TASKS = "mapreduce.large-sorter.reduce-tasks";
    private static final String MAX_VALUE = "mapreduce.large-sorter.max-value";
    private static final String MIN_VALUE = "mapreduce.large-sorter.min-value";
    private static final String MIN_KEY = "mapreduce.large-sorter.min-key";
    private static final String MAX_KEY = "mapreduce.large-sorter.max-key";

    private void verifyNotZero(Configuration conf, String config) {
        if (conf.getInt(config, 1) <= 0) {
            throw new IllegalArgumentException(config + "should be > 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Path outDir = new Path(LargeSorter.class.getName() + System.currentTimeMillis());
        Configuration conf = this.getConf();
        this.verifyNotZero(conf, MBS_PER_MAP);
        this.verifyNotZero(conf, NUM_MAP_TASKS);
        conf.setInt("mapreduce.job.maps", conf.getInt(NUM_MAP_TASKS, 2));
        int ioSortMb = conf.getInt("mapreduce.task.io.sort.mb", 512);
        int mapMb = Math.max(2 * ioSortMb, conf.getInt("mapreduce.map.memory.mb", 1024));
        conf.setInt("mapreduce.map.memory.mb", mapMb);
        conf.set("mapreduce.map.java.opts", "-Xmx" + (mapMb - 200) + "m");
        Job job = Job.getInstance((Configuration)conf);
        job.setJarByClass(LargeSorter.class);
        job.setJobName("large-sorter");
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        job.setOutputKeyClass(BytesWritable.class);
        job.setOutputValueClass(BytesWritable.class);
        job.setInputFormatClass(RandomInputFormat.class);
        job.setMapperClass(RandomMapper.class);
        job.setReducerClass(Discarder.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setNumReduceTasks(conf.getInt(NUM_REDUCE_TASKS, 1));
        Date startTime = new Date();
        System.out.println("Job started: " + startTime);
        int ret = 1;
        try {
            ret = job.waitForCompletion(true) ? 0 : 1;
        }
        finally {
            FileSystem.get((Configuration)conf).delete(outDir, true);
        }
        Date endTime = new Date();
        System.out.println("Job ended: " + endTime);
        System.out.println("The job took " + (endTime.getTime() - startTime.getTime()) / 1000L + " seconds.");
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new LargeSorter(), (String[])args);
        System.exit(res);
    }
}

