/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.processor.StreamPartitioner;

public class Produced<K, V> {
    protected Serde<K> keySerde;
    protected Serde<V> valueSerde;
    protected StreamPartitioner<? super K, ? super V> partitioner;

    private Produced(Serde<K> keySerde, Serde<V> valueSerde, StreamPartitioner<? super K, ? super V> partitioner) {
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.partitioner = partitioner;
    }

    protected Produced(Produced<K, V> produced) {
        this.keySerde = produced.keySerde;
        this.valueSerde = produced.valueSerde;
        this.partitioner = produced.partitioner;
    }

    public static <K, V> Produced<K, V> with(Serde<K> keySerde, Serde<V> valueSerde) {
        return new Produced<K, V>(keySerde, valueSerde, null);
    }

    public static <K, V> Produced<K, V> with(Serde<K> keySerde, Serde<V> valueSerde, StreamPartitioner<? super K, ? super V> partitioner) {
        return new Produced<K, V>(keySerde, valueSerde, partitioner);
    }

    public static <K, V> Produced<K, V> keySerde(Serde<K> keySerde) {
        return new Produced<K, V>(keySerde, null, null);
    }

    public static <K, V> Produced<K, V> valueSerde(Serde<V> valueSerde) {
        return new Produced<K, V>(null, valueSerde, null);
    }

    public static <K, V> Produced<K, V> streamPartitioner(StreamPartitioner<? super K, ? super V> partitioner) {
        return new Produced<K, V>(null, null, partitioner);
    }

    public Produced<K, V> withStreamPartitioner(StreamPartitioner<? super K, ? super V> partitioner) {
        this.partitioner = partitioner;
        return this;
    }

    public Produced<K, V> withValueSerde(Serde<V> valueSerde) {
        this.valueSerde = valueSerde;
        return this;
    }

    public Produced<K, V> withKeySerde(Serde<K> keySerde) {
        this.keySerde = keySerde;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Produced produced = (Produced)o;
        return Objects.equals(this.keySerde, produced.keySerde) && Objects.equals(this.valueSerde, produced.valueSerde) && Objects.equals(this.partitioner, produced.partitioner);
    }

    public int hashCode() {
        return Objects.hash(this.keySerde, this.valueSerde, this.partitioner);
    }
}

