/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Count;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.streams.StreamsMetrics;

public class StreamsMetricsImpl
implements StreamsMetrics {
    private final Metrics metrics;
    private final Map<String, String> tags;
    private final Map<Sensor, Sensor> parentSensors;
    private final Sensor skippedRecordsSensor;
    private final String threadName;
    private final Deque<String> threadLevelSensors = new LinkedList<String>();
    private final Map<String, Deque<String>> taskLevelSensors = new HashMap<String, Deque<String>>();
    private final Map<String, Deque<String>> cacheLevelSensors = new HashMap<String, Deque<String>>();

    public StreamsMetricsImpl(Metrics metrics, String threadName) {
        Objects.requireNonNull(metrics, "Metrics cannot be null");
        this.threadName = threadName;
        this.metrics = metrics;
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put("client-id", threadName);
        this.tags = Collections.unmodifiableMap(tags);
        this.parentSensors = new HashMap<Sensor, Sensor>();
        String group = "stream-metrics";
        this.skippedRecordsSensor = this.threadLevelSensor("skipped-records", Sensor.RecordingLevel.INFO, new Sensor[0]);
        this.skippedRecordsSensor.add(metrics.metricName("skipped-records-rate", "stream-metrics", "The average per-second number of skipped records", tags), (MeasurableStat)new Rate(TimeUnit.SECONDS, (SampledStat)new Count()));
        this.skippedRecordsSensor.add(metrics.metricName("skipped-records-total", "stream-metrics", "The total number of skipped records", tags), (MeasurableStat)new Total());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Sensor threadLevelSensor(String sensorName, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        Deque<String> deque = this.threadLevelSensors;
        synchronized (deque) {
            String fullSensorName = this.threadName + "." + sensorName;
            Sensor sensor = this.metrics.sensor(fullSensorName, recordingLevel, parents);
            this.threadLevelSensors.push(fullSensorName);
            return sensor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAllThreadLevelSensors() {
        Deque<String> deque = this.threadLevelSensors;
        synchronized (deque) {
            while (!this.threadLevelSensors.isEmpty()) {
                this.metrics.removeSensor(this.threadLevelSensors.pop());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Sensor taskLevelSensor(String taskName, String sensorName, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        String key = this.threadName + "." + taskName;
        Map<String, Deque<String>> map = this.taskLevelSensors;
        synchronized (map) {
            if (!this.taskLevelSensors.containsKey(key)) {
                this.taskLevelSensors.put(key, new LinkedList());
            }
            String fullSensorName = key + "." + sensorName;
            Sensor sensor = this.metrics.sensor(fullSensorName, recordingLevel, parents);
            this.taskLevelSensors.get(key).push(fullSensorName);
            return sensor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAllTaskLevelSensors(String taskName) {
        String key = this.threadName + "." + taskName;
        Map<String, Deque<String>> map = this.taskLevelSensors;
        synchronized (map) {
            if (this.taskLevelSensors.containsKey(key)) {
                while (!this.taskLevelSensors.get(key).isEmpty()) {
                    this.metrics.removeSensor(this.taskLevelSensors.get(key).pop());
                }
                this.taskLevelSensors.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Sensor cacheLevelSensor(String taskName, String cacheName, String sensorName, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        String key = this.threadName + "." + taskName + "." + cacheName;
        Map<String, Deque<String>> map = this.cacheLevelSensors;
        synchronized (map) {
            if (!this.cacheLevelSensors.containsKey(key)) {
                this.cacheLevelSensors.put(key, new LinkedList());
            }
            String fullSensorName = key + "." + sensorName;
            Sensor sensor = this.metrics.sensor(fullSensorName, recordingLevel, parents);
            this.cacheLevelSensors.get(key).push(fullSensorName);
            return sensor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAllCacheLevelSensors(String taskName, String cacheName) {
        String key = this.threadName + "." + taskName + "." + cacheName;
        Map<String, Deque<String>> map = this.cacheLevelSensors;
        synchronized (map) {
            if (this.cacheLevelSensors.containsKey(key)) {
                while (!this.cacheLevelSensors.get(key).isEmpty()) {
                    this.metrics.removeSensor(this.cacheLevelSensors.get(key).pop());
                }
                this.cacheLevelSensors.remove(key);
            }
        }
    }

    protected final Map<String, String> tags() {
        return this.tags;
    }

    public final Sensor skippedRecordsSensor() {
        return this.skippedRecordsSensor;
    }

    @Override
    public Sensor addSensor(String name, Sensor.RecordingLevel recordingLevel) {
        return this.metrics.sensor(name, recordingLevel);
    }

    @Override
    public Sensor addSensor(String name, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        return this.metrics.sensor(name, recordingLevel, parents);
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        return Collections.unmodifiableMap(this.metrics.metrics());
    }

    @Override
    public void recordLatency(Sensor sensor, long startNs, long endNs) {
        sensor.record((double)(endNs - startNs));
    }

    @Override
    public void recordThroughput(Sensor sensor, long value) {
        sensor.record((double)value);
    }

    private String groupNameFromScope(String scopeName) {
        return "stream-" + scopeName + "-metrics";
    }

    private String sensorName(String operationName, String entityName) {
        if (entityName == null) {
            return operationName;
        }
        return entityName + "-" + operationName;
    }

    public Map<String, String> tagMap(String ... tags) {
        HashMap<String, String> tagMap = new HashMap<String, String>(this.tags);
        if (tags != null) {
            if (tags.length % 2 != 0) {
                throw new IllegalArgumentException("Tags needs to be specified in key-value pairs");
            }
            for (int i = 0; i < tags.length; i += 2) {
                tagMap.put(tags[i], tags[i + 1]);
            }
        }
        return tagMap;
    }

    private Map<String, String> constructTags(String scopeName, String entityName, String ... tags) {
        String[] updatedTags = Arrays.copyOf(tags, tags.length + 2);
        updatedTags[tags.length] = scopeName + "-id";
        updatedTags[tags.length + 1] = entityName;
        return this.tagMap(updatedTags);
    }

    @Override
    public Sensor addLatencyAndThroughputSensor(String scopeName, String entityName, String operationName, Sensor.RecordingLevel recordingLevel, String ... tags) {
        return this.addLatencyAndThroughputSensor(null, scopeName, entityName, operationName, recordingLevel, tags);
    }

    public Sensor addLatencyAndThroughputSensor(String taskName, String scopeName, String entityName, String operationName, Sensor.RecordingLevel recordingLevel, String ... tags) {
        Map<String, String> tagMap = this.constructTags(scopeName, entityName, tags);
        Map<String, String> allTagMap = this.constructTags(scopeName, "all", tags);
        Sensor parent = this.metrics.sensor(this.sensorName(this.buildUniqueSensorName(operationName, taskName), null), recordingLevel);
        this.addLatencyMetrics(scopeName, parent, operationName, allTagMap);
        this.addThroughputMetrics(scopeName, parent, operationName, allTagMap);
        Sensor sensor = this.metrics.sensor(this.sensorName(this.buildUniqueSensorName(operationName, taskName), entityName), recordingLevel, new Sensor[]{parent});
        this.addLatencyMetrics(scopeName, sensor, operationName, tagMap);
        this.addThroughputMetrics(scopeName, sensor, operationName, tagMap);
        this.parentSensors.put(sensor, parent);
        return sensor;
    }

    @Override
    public Sensor addThroughputSensor(String scopeName, String entityName, String operationName, Sensor.RecordingLevel recordingLevel, String ... tags) {
        return this.addThroughputSensor(null, scopeName, entityName, operationName, recordingLevel, tags);
    }

    public Sensor addThroughputSensor(String taskName, String scopeName, String entityName, String operationName, Sensor.RecordingLevel recordingLevel, String ... tags) {
        Map<String, String> tagMap = this.constructTags(scopeName, entityName, tags);
        Map<String, String> allTagMap = this.constructTags(scopeName, "all", tags);
        Sensor parent = this.metrics.sensor(this.sensorName(this.buildUniqueSensorName(operationName, taskName), null), recordingLevel);
        this.addThroughputMetrics(scopeName, parent, operationName, allTagMap);
        Sensor sensor = this.metrics.sensor(this.sensorName(this.buildUniqueSensorName(operationName, taskName), entityName), recordingLevel, new Sensor[]{parent});
        this.addThroughputMetrics(scopeName, sensor, operationName, tagMap);
        this.parentSensors.put(sensor, parent);
        return sensor;
    }

    private String buildUniqueSensorName(String operationName, String taskName) {
        String task = taskName == null ? "" : taskName + ".";
        return this.threadName + "." + task + operationName;
    }

    private void addLatencyMetrics(String scopeName, Sensor sensor, String opName, Map<String, String> tags) {
        sensor.add(this.metrics.metricName(opName + "-latency-avg", this.groupNameFromScope(scopeName), "The average latency of " + opName + " operation.", tags), (MeasurableStat)new Avg());
        sensor.add(this.metrics.metricName(opName + "-latency-max", this.groupNameFromScope(scopeName), "The max latency of " + opName + " operation.", tags), (MeasurableStat)new Max());
    }

    private void addThroughputMetrics(String scopeName, Sensor sensor, String opName, Map<String, String> tags) {
        sensor.add(this.metrics.metricName(opName + "-rate", this.groupNameFromScope(scopeName), "The average number of occurrence of " + opName + " operation per second.", tags), (MeasurableStat)new Rate(TimeUnit.SECONDS, (SampledStat)new Count()));
        sensor.add(this.metrics.metricName(opName + "-total", this.groupNameFromScope(scopeName), "The total number of occurrence of " + opName + " operations.", tags), (MeasurableStat)new Count());
    }

    @Override
    public void removeSensor(Sensor sensor) {
        Objects.requireNonNull(sensor, "Sensor is null");
        this.metrics.removeSensor(sensor.name());
        Sensor parent = this.parentSensors.get(sensor);
        if (parent != null) {
            this.metrics.removeSensor(parent.name());
        }
    }
}

