/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.ConstantVector;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixTimesOps;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;

public class DiagonalMatrix
extends AbstractMatrix
implements MatrixTimesOps {
    private final Vector diagonal;

    public DiagonalMatrix(Vector values) {
        super(values.size(), values.size());
        this.diagonal = values;
    }

    public DiagonalMatrix(Matrix values) {
        this(values.viewDiagonal());
    }

    public DiagonalMatrix(double value, int size) {
        this(new ConstantVector(value, size));
    }

    public DiagonalMatrix(double[] values) {
        super(values.length, values.length);
        this.diagonal = new DenseVector(values);
    }

    public static DiagonalMatrix identity(int size) {
        return new DiagonalMatrix(1.0, size);
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        throw new UnsupportedOperationException("Can't assign a column to a diagonal matrix");
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        throw new UnsupportedOperationException("Can't assign a row to a diagonal matrix");
    }

    @Override
    public Vector viewDiagonal() {
        return this.diagonal;
    }

    @Override
    public double getQuick(int row, int column) {
        if (row == column) {
            return this.diagonal.get(row);
        }
        return 0.0;
    }

    @Override
    public Matrix like() {
        return new SparseRowMatrix(this.rowSize(), this.columnSize());
    }

    @Override
    public Matrix like(int rows, int columns) {
        return new SparseRowMatrix(rows, columns);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        if (row != column) {
            throw new UnsupportedOperationException("Can't set off-diagonal element");
        }
        this.diagonal.set(row, value);
    }

    @Override
    public int[] getNumNondefaultElements() {
        throw new UnsupportedOperationException("Don't understand how to implement this");
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        return new MatrixView(this, offset, size);
    }

    @Override
    public Matrix times(Matrix other) {
        return this.timesRight(other);
    }

    @Override
    public Matrix timesRight(Matrix that) {
        if (that.numRows() != this.diagonal.size()) {
            throw new IllegalArgumentException("Incompatible number of rows in the right operand of matrix multiplication.");
        }
        Matrix m = that.like();
        for (int row = 0; row < this.diagonal.size(); ++row) {
            m.assignRow(row, that.viewRow(row).times(this.diagonal.getQuick(row)));
        }
        return m;
    }

    @Override
    public Matrix timesLeft(Matrix that) {
        if (that.numCols() != this.diagonal.size()) {
            throw new IllegalArgumentException("Incompatible number of rows in the left operand of matrix-matrix multiplication.");
        }
        Matrix m = that.like();
        for (int col = 0; col < this.diagonal.size(); ++col) {
            m.assignColumn(col, that.viewColumn(col).times(this.diagonal.getQuick(col)));
        }
        return m;
    }
}

