/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.list;

import org.apache.mahout.collections.Arithmetic;
import org.apache.mahout.math.Arrays;
import org.apache.mahout.math.BinarySearch;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.list.AbstractByteList;

public class ByteArrayList
extends AbstractByteList
implements Cloneable {
    private byte[] elements;

    public ByteArrayList() {
        this(10);
    }

    public ByteArrayList(byte[] elements) {
        this.elements(elements);
    }

    public ByteArrayList(int initialCapacity) {
        this(new byte[initialCapacity]);
        this.setSizeRaw(0);
    }

    @Override
    public void add(byte element) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = element;
    }

    @Override
    public void beforeInsert(int index, byte element) {
        if (this.size == index) {
            this.add(element);
            return;
        }
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = element;
        ++this.size;
    }

    @Override
    public int binarySearchFromTo(byte key, int from, int to) {
        return BinarySearch.binarySearchFromTo(this.elements, key, from, to);
    }

    @Override
    public Object clone() {
        ByteArrayList clone = new ByteArrayList((byte[])this.elements.clone());
        clone.setSizeRaw(this.size);
        return clone;
    }

    public ByteArrayList copy() {
        return (ByteArrayList)this.clone();
    }

    protected void countSortFromTo(int from, int to, byte min, byte max) {
        if (this.size == 0) {
            return;
        }
        ByteArrayList.checkRangeFromTo(from, to, this.size);
        int width = max - min + 1;
        int[] counts = new int[width];
        byte[] theElements = this.elements;
        int i = from;
        while (i <= to) {
            int n = theElements[i++] - min;
            counts[n] = counts[n] + 1;
        }
        int fromIndex = from;
        byte val = min;
        int i2 = 0;
        while (i2 < width) {
            int c = counts[i2];
            if (c > 0) {
                if (c == 1) {
                    theElements[fromIndex++] = val;
                } else {
                    int toIndex = fromIndex + c - 1;
                    this.fillFromToWith(fromIndex, toIndex, val);
                    fromIndex = toIndex + 1;
                }
            }
            ++i2;
            val = (byte)(val + 1);
        }
    }

    @Override
    public byte[] elements() {
        return this.elements;
    }

    @Override
    public AbstractByteList elements(byte[] elements) {
        this.elements = elements;
        this.size = elements.length;
        return this;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements = Arrays.ensureCapacity(this.elements, minCapacity);
    }

    @Override
    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (!(otherObj instanceof ByteArrayList)) {
            return super.equals(otherObj);
        }
        if (this == otherObj) {
            return true;
        }
        ByteArrayList other = (ByteArrayList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        byte[] theElements = this.elements();
        byte[] otherElements = other.elements();
        int i = this.size();
        while (--i >= 0) {
            if (theElements[i] == otherElements[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEach(ByteProcedure procedure) {
        byte[] theElements = this.elements;
        int theSize = this.size;
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    @Override
    public byte getQuick(int index) {
        return this.elements[index];
    }

    @Override
    public int indexOfFromTo(byte element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        ByteArrayList.checkRangeFromTo(from, to, this.size);
        byte[] theElements = this.elements;
        for (int i = from; i <= to; ++i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfFromTo(byte element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        ByteArrayList.checkRangeFromTo(from, to, this.size);
        byte[] theElements = this.elements;
        for (int i = to; i >= from; --i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public AbstractByteList partFromTo(int from, int to) {
        if (this.size == 0) {
            return new ByteArrayList(0);
        }
        ByteArrayList.checkRangeFromTo(from, to, this.size);
        byte[] part = new byte[to - from + 1];
        System.arraycopy(this.elements, from, part, 0, to - from + 1);
        return new ByteArrayList(part);
    }

    @Override
    public boolean removeAll(AbstractByteList other) {
        double M;
        if (!(other instanceof ByteArrayList)) {
            return super.removeAll(other);
        }
        if (other.isEmpty()) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        byte[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * Arithmetic.log2(N) < M * N) {
            ByteArrayList sortedList = (ByteArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    @Override
    public void replaceFromToWithFrom(int from, int to, AbstractByteList other, int otherFrom) {
        if (!(other instanceof ByteArrayList)) {
            super.replaceFromToWithFrom(from, to, other, otherFrom);
            return;
        }
        int length = to - from + 1;
        if (length > 0) {
            ByteArrayList.checkRangeFromTo(from, to, this.size());
            ByteArrayList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            System.arraycopy(((ByteArrayList)other).elements, otherFrom, this.elements, from, length);
        }
    }

    @Override
    public boolean retainAll(AbstractByteList other) {
        double M;
        if (!(other instanceof ByteArrayList)) {
            return super.retainAll(other);
        }
        int limit = other.size() - 1;
        int j = 0;
        byte[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M = (double)mySize)) * Arithmetic.log2(N) < M * N) {
            ByteArrayList sortedList = (ByteArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    @Override
    public void reverse() {
        int limit = this.size / 2;
        int j = this.size - 1;
        byte[] theElements = this.elements;
        int i = 0;
        while (i < limit) {
            byte tmp = theElements[i];
            theElements[i++] = theElements[j];
            theElements[j--] = tmp;
        }
    }

    @Override
    public void set(int index, byte element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.elements[index] = element;
    }

    @Override
    public void setQuick(int index, byte element) {
        this.elements[index] = element;
    }

    @Override
    public void sortFromTo(int from, int to) {
        if (this.size == 0) {
            return;
        }
        ByteArrayList.checkRangeFromTo(from, to, this.size);
        byte min = this.elements[from];
        byte max = this.elements[from];
        byte[] theElements = this.elements;
        int i = from + 1;
        while (i <= to) {
            byte elem;
            if ((elem = theElements[i++]) > max) {
                max = elem;
                continue;
            }
            if (elem >= min) continue;
            min = elem;
        }
        double N = (double)to - (double)from + 1.0;
        double quickSortEstimate = N * Math.log(N) / 0.6931471805599453;
        double width = (double)max - (double)min + 1.0;
        double countSortEstimate = Math.max(width, N);
        int widthThreshold = 10000;
        if (width < (double)widthThreshold && countSortEstimate < quickSortEstimate) {
            this.countSortFromTo(from, to, min, max);
        } else {
            this.quickSortFromTo(from, to);
        }
    }

    @Override
    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

