/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompositeMap
implements Map<String, Object> {
    private MavenProject mavenProject;
    private Map<String, Object> properties;

    protected CompositeMap(MavenProject mavenProject, Map<String, Object> properties) {
        if (mavenProject == null) {
            throw new IllegalArgumentException("no project specified");
        }
        this.mavenProject = mavenProject;
        this.properties = properties == null ? new HashMap() : properties;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        String expression = (String)key;
        if (expression.startsWith("project.") || expression.startsWith("pom.")) {
            try {
                Object evaluated = ReflectionValueExtractor.evaluate((String)expression, (Object)this.mavenProject);
                if (evaluated != null) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.properties.containsKey(key) || this.mavenProject.getProperties().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) {
        Object value;
        if (!(key instanceof String)) {
            return null;
        }
        String expression = (String)key;
        if (expression.startsWith("project.") || expression.startsWith("pom.")) {
            try {
                Object evaluated = ReflectionValueExtractor.evaluate((String)expression, (Object)this.mavenProject);
                if (evaluated != null) {
                    return evaluated;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return (value = this.properties.get(key)) != null ? value : this.mavenProject.getProperties().get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.mavenProject.getProperties().isEmpty() && this.properties.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }
}

