/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial;

import java.util.Objects;
import java.util.Optional;

public class FunctionKey {
    private final String name;
    private final String altName;

    private FunctionKey(String name, String altName) {
        this.name = name;
        this.altName = altName;
    }

    public static FunctionKey apply(String name, String altName) {
        return new FunctionKey(name, altName);
    }

    public static FunctionKey apply(String name) {
        return new FunctionKey(name, null);
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getAltName() {
        return Optional.ofNullable(this.altName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionKey that = (FunctionKey)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.altName, that.altName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.altName);
    }

    public String toString() {
        return "SpatialFunctionKey{" + this.name + "}";
    }
}

