/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.common.encode;

import java.io.IOException;
import java.io.InputStream;
import org.simpleframework.common.encode.Base64Encoder;

public class Base64InputStream
extends InputStream {
    private char[] encoded;
    private byte[] decoded;
    private byte[] temp;
    private int count;

    public Base64InputStream(String source) {
        this.encoded = source.toCharArray();
        this.temp = new byte[1];
    }

    public int read() throws IOException {
        int count = this.read(this.temp);
        if (count == -1) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    public int read(byte[] array, int offset, int length) throws IOException {
        if (this.decoded == null) {
            this.decoded = Base64Encoder.decode(this.encoded);
        }
        if (this.count >= this.decoded.length) {
            return -1;
        }
        int size = Math.min(length, this.decoded.length - this.count);
        if (size > 0) {
            System.arraycopy(this.decoded, this.count, array, offset, size);
            this.count += size;
        }
        return size;
    }

    public String toString() {
        return new String(this.encoded);
    }
}

