/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaAscpLogisticsSellerWritelogisticsnodeResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlibabaAscpLogisticsSellerWritelogisticsnodeRequest
extends BaseTaobaoRequest<AlibabaAscpLogisticsSellerWritelogisticsnodeResponse> {
    private Long lpOrderId;
    private String nodes;

    public void setLpOrderId(Long lpOrderId) {
        this.lpOrderId = lpOrderId;
    }

    public Long getLpOrderId() {
        return this.lpOrderId;
    }

    public void setNodes(String nodes) {
        this.nodes = nodes;
    }

    public void setNodes(List<LogisticsNodeTopDTO> nodes) {
        this.nodes = new JSONWriter(false, true).write(nodes);
    }

    public String getNodes() {
        return this.nodes;
    }

    @Override
    public String getApiMethodName() {
        return "alibaba.ascp.logistics.seller.writelogisticsnode";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("lp_order_id", (Object)this.lpOrderId);
        txtParams.put("nodes", this.nodes);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<AlibabaAscpLogisticsSellerWritelogisticsnodeResponse> getResponseClass() {
        return AlibabaAscpLogisticsSellerWritelogisticsnodeResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.lpOrderId, "lpOrderId");
        RequestCheckUtils.checkObjectMaxListSize(this.nodes, 100, "nodes");
    }

    public static class LogisticsNodeTopDTO
    extends TaobaoObject {
        private static final long serialVersionUID = 4452346273556868421L;
        @ApiField(value="action")
        private String action;
        @ApiField(value="delivery")
        private DeliveryTopDTO delivery;
        @ApiField(value="location")
        private LocationTopDTO location;
        @ApiField(value="operate_time")
        private Long operateTime;

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public DeliveryTopDTO getDelivery() {
            return this.delivery;
        }

        public void setDelivery(DeliveryTopDTO delivery) {
            this.delivery = delivery;
        }

        public LocationTopDTO getLocation() {
            return this.location;
        }

        public void setLocation(LocationTopDTO location) {
            this.location = location;
        }

        public Long getOperateTime() {
            return this.operateTime;
        }

        public void setOperateTime(Long operateTime) {
            this.operateTime = operateTime;
        }
    }

    public static class LocationTopDTO
    extends TaobaoObject {
        private static final long serialVersionUID = 4352521892548722686L;
        @ApiField(value="city")
        private String city;
        @ApiField(value="district")
        private String district;
        @ApiField(value="lat")
        private String lat;
        @ApiField(value="lng")
        private String lng;
        @ApiField(value="province")
        private String province;
        @ApiField(value="town")
        private String town;

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getDistrict() {
            return this.district;
        }

        public void setDistrict(String district) {
            this.district = district;
        }

        public String getLat() {
            return this.lat;
        }

        public void setLat(String lat) {
            this.lat = lat;
        }

        public String getLng() {
            return this.lng;
        }

        public void setLng(String lng) {
            this.lng = lng;
        }

        public String getProvince() {
            return this.province;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public String getTown() {
            return this.town;
        }

        public void setTown(String town) {
            this.town = town;
        }
    }

    public static class DeliveryTopDTO
    extends TaobaoObject {
        private static final long serialVersionUID = 7142697422123181366L;
        @ApiField(value="name")
        private String name;
        @ApiField(value="phone")
        private String phone;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }
    }
}

