/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.api;

import cc.lechun.balance.api.StorageCardManagerApi;
import cc.lechun.balance.dto.StorageCardDTO;
import cc.lechun.balance.entity.storage.StorageCardEntity;
import cc.lechun.balance.entity.storage.StorageCardEntityExample;
import cc.lechun.balance.iservice.storage.StorageCardInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StorageCardManagerApiService
implements StorageCardManagerApi {
    @Autowired
    private StorageCardInterface storageCardInterface;

    public BaseJsonVo<List<StorageCardDTO>> findStorageCard(PageForm pageForm, StorageCardDTO storageCardDTO) {
        JSONObject jsonObject = new JSONObject();
        String batchDtoStr = JSONObject.toJSONString((Object)storageCardDTO);
        StorageCardEntity storageCardEntity = (StorageCardEntity)JSONObject.parseObject((String)batchDtoStr, StorageCardEntity.class);
        PageInfo pageInfo = this.storageCardInterface.queryStorageCardInfo(pageForm.getCurrentPage(), pageForm.getPageSize(), storageCardEntity);
        return BaseJsonVo.success((Object)pageInfo);
    }

    public BaseJsonVo<List<StorageCardDTO>> saveStorageCard(StorageCardDTO storageCardDTO) {
        JSONObject jsonObject = new JSONObject();
        String batchDtoStr = JSONObject.toJSONString((Object)storageCardDTO);
        StorageCardEntity storageCardEntity = (StorageCardEntity)JSONObject.parseObject((String)batchDtoStr, StorageCardEntity.class);
        if (storageCardEntity == null) {
            return BaseJsonVo.error((String)"\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)storageCardEntity.getGiftTitle())) {
            return BaseJsonVo.error((String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BaseJsonVo json = this.validationStorageInfo(storageCardEntity.getGiftTitle());
        if (!json.isSuccess()) {
            return json;
        }
        List storageCardEntityList = this.storageCardInterface.validationStorageCashInfo(storageCardEntity);
        if (storageCardEntityList != null && storageCardEntityList.size() > 0) {
            return BaseJsonVo.error((String)"\u8d2d\u4e70\u91d1\u989d\u548c\u8d60\u9001\u91d1\u989d\u5df2\u5b58\u5728");
        }
        storageCardEntity.setId(IDGenerate.getUniqueIdStr());
        Date nowDate = DateUtils.now();
        storageCardEntity.setCreateTime(nowDate);
        String[] proId = storageCardDTO.getProId().split(",");
        storageCardEntity.setProId(proId[0]);
        storageCardEntity.setProName(proId[1]);
        this.storageCardInterface.saveStorageCard(storageCardEntity);
        return BaseJsonVo.success((Object)"\u751f\u6210\u6210\u529f");
    }

    public BaseJsonVo<List<StorageCardDTO>> findStorageCardsWithSales() {
        return null;
    }

    public BaseJsonVo<List<StorageCardDTO>> findStorageCards() {
        StorageCardEntityExample example = new StorageCardEntityExample();
        example.createCriteria().andGiftStateEqualTo(Integer.valueOf(1));
        example.setOrderByClause("create_time");
        List storageCardEntityList = this.storageCardInterface.selectByExample((Object)example);
        ArrayList<StorageCardDTO> storageCardDTOList = new ArrayList<StorageCardDTO>();
        if (storageCardEntityList != null && storageCardEntityList.size() > 0) {
            for (StorageCardEntity storageCard : storageCardEntityList) {
                StorageCardDTO storageCardDTO = new StorageCardDTO();
                storageCardDTO.setId(storageCard.getId());
                storageCardDTO.setGiftTitle(storageCard.getGiftTitle());
                storageCardDTO.setGiftImg(storageCard.getGiftImg());
                storageCardDTO.setGiftCash(storageCard.getGiftCash());
                storageCardDTO.setFreeCash(storageCard.getFreeCash());
                storageCardDTO.setGiftState(storageCard.getGiftState());
                storageCardDTO.setPlatformGroupId(storageCard.getPlatformGroupId());
                storageCardDTO.setCreateTime(storageCard.getCreateTime());
                storageCardDTO.setCreateBy(storageCard.getCreateBy());
                storageCardDTO.setProId(storageCard.getProId());
                storageCardDTO.setProName(storageCard.getProName());
                storageCardDTOList.add(storageCardDTO);
            }
        }
        return BaseJsonVo.success(storageCardDTOList);
    }

    public BaseJsonVo generateStorageCard(StorageCardDTO storageCardDto) {
        JSONObject jsonObject = new JSONObject();
        String storageCardDtoStr = JSONObject.toJSONString((Object)storageCardDto);
        StorageCardEntity storageCardEntity = (StorageCardEntity)JSONObject.parseObject((String)storageCardDtoStr, StorageCardEntity.class);
        this.storageCardInterface.createStorageCard(storageCardEntity);
        return BaseJsonVo.success((Object)"\u751f\u6210\u6210\u529f");
    }

    public BaseJsonVo validCard(String cardId) {
        this.storageCardInterface.updateStorageCard(cardId, 1);
        return BaseJsonVo.success((Object)"\u6210\u529f");
    }

    public BaseJsonVo invalidCard(String cardId, int cardState) {
        StorageCardEntity storageCardEntity = new StorageCardEntity();
        storageCardEntity.setId(cardId);
        List storageCardEntityList = this.storageCardInterface.queryStorageCardInfoList(storageCardEntity);
        if (storageCardEntityList != null && storageCardEntityList.size() > 0) {
            storageCardEntity = (StorageCardEntity)storageCardEntityList.get(0);
        }
        if (cardState == 1 && storageCardEntity.getGiftState() == 2) {
            storageCardEntity.setGiftState(Integer.valueOf(cardState));
            this.storageCardInterface.updateStorageCardState(storageCardEntity);
        }
        if (cardState == 2 && storageCardEntity.getGiftState() == 1) {
            storageCardEntity.setGiftState(Integer.valueOf(cardState));
            this.storageCardInterface.updateStorageCardState(storageCardEntity);
        }
        if (cardState == 0 && storageCardEntity.getGiftState() != 0) {
            storageCardEntity.setGiftState(Integer.valueOf(cardState));
            this.storageCardInterface.updateStorageCardState(storageCardEntity);
        }
        this.storageCardInterface.updateStorageCard(cardId, cardState);
        return BaseJsonVo.success((Object)"\u6210\u529f");
    }

    public BaseJsonVo validationStorageInfo(String giftTitle) {
        if (StringUtils.isNotEmpty((CharSequence)giftTitle)) {
            StorageCardEntity storageCardEntity = new StorageCardEntity();
            storageCardEntity.setGiftTitle(giftTitle);
            List storageCardEntityList = this.storageCardInterface.validationStorageInfo(storageCardEntity);
            if (storageCardEntityList != null && storageCardEntityList.size() > 0) {
                return BaseJsonVo.error((String)"\u6807\u9898\u4e0d\u80fd\u91cd\u590d");
            }
        }
        return BaseJsonVo.success((Object)"\u6210\u529f");
    }

    public BaseJsonVo getStorageCardByProId(String proId) {
        StorageCardEntity storageCardEntity = new StorageCardEntity();
        storageCardEntity.setProId(proId);
        List storageCardEntityList = this.storageCardInterface.validationStorageInfo(storageCardEntity);
        if (storageCardEntityList != null && storageCardEntityList.size() > 0) {
            return BaseJsonVo.error((String)"\u6b64\u5546\u54c1\u5df2\u88ab\u7ed1\u5b9a");
        }
        return BaseJsonVo.success((Object)"\u6210\u529f");
    }
}

