/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.service.storage;

import cc.lechun.balance.dao.storage.StorageCardMapper;
import cc.lechun.balance.entity.storage.StorageCardEntity;
import cc.lechun.balance.entity.storage.StorageCardEntityExample;
import cc.lechun.balance.iservice.storage.StorageCardInterface;
import cc.lechun.balance.service.BaseService;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StorageCardService
extends BaseService<StorageCardEntity, String, StorageCardEntityExample>
implements StorageCardInterface {
    @Autowired
    private StorageCardMapper storageCardMapper;

    public void testExample() {
        StorageCardEntityExample var1 = new StorageCardEntityExample();
        var1.createCriteria().andCreateTimeBetween(new Date(), new Date()).andGiftTitleBetween("", "");
        List storageCardEntityList = this.selectByExample((Object)var1);
    }

    public PageInfo queryStorageCardInfo(int currentPage, int pageSize, StorageCardEntity storageCardEntity) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List storageCardEntityList = this.storageCardMapper.queryStorageCardInfoList(storageCardEntity);
        PageInfo pg = page.toPageInfo();
        pg.setList(storageCardEntityList);
        return pg;
    }

    public List<StorageCardEntity> queryStorageCardInfoList(StorageCardEntity storageCardEntity) {
        return this.storageCardMapper.queryStorageCardInfoList(storageCardEntity);
    }

    public int updateStorageCardState(StorageCardEntity storageCardEntity) {
        return this.storageCardMapper.updateStorageCardState(storageCardEntity);
    }

    public int saveStorageCard(StorageCardEntity storageCardEntity) {
        return this.storageCardMapper.insertSelective((Object)storageCardEntity);
    }

    public List<StorageCardEntity> findStorageCardInfo(StorageCardEntity storageCardEntity) {
        ArrayList<StorageCardEntity> storageCardList = new ArrayList();
        storageCardList = this.storageCardMapper.getList((Object)storageCardEntity);
        return storageCardList;
    }

    public int createStorageCard(StorageCardEntity storageCardEntity) {
        String storageCardNo = IDGenerate.getUniqueIdStr();
        storageCardEntity.setId(storageCardNo);
        return this.storageCardMapper.insertSelective((Object)storageCardEntity);
    }

    public int updateStorageCard(String Id, int giftState) {
        StorageCardEntity storageCardEntity = (StorageCardEntity)this.storageCardMapper.selectByPrimaryKey((Serializable)((Object)Id));
        if (storageCardEntity != null) {
            storageCardEntity.setGiftState(Integer.valueOf(giftState));
            return this.storageCardMapper.updateByPrimaryKeySelective((Object)storageCardEntity);
        }
        return 1;
    }

    public StorageCardEntity selectByProductId(String productId) {
        StorageCardEntityExample entityExample = new StorageCardEntityExample();
        entityExample.createCriteria().andProIdEqualTo(productId).andGiftStateEqualTo(Integer.valueOf(1));
        List entityList = this.selectByExample((Object)entityExample);
        return entityList != null && entityList.size() > 0 ? (StorageCardEntity)entityList.get(0) : null;
    }

    public List<StorageCardEntity> validationStorageInfo(StorageCardEntity storageCardEntity) {
        return this.storageCardMapper.validationStorageInfo(storageCardEntity);
    }

    public List<StorageCardEntity> validationStorageCashInfo(StorageCardEntity storageCardEntity) {
        return this.storageCardMapper.validationStorageCashInfo(storageCardEntity);
    }

    public BaseJsonVo importCards() {
        this.storageCardMapper.truncate();
        List oldData = this.storageCardMapper.findOldData();
        oldData.forEach(map -> {
            StorageCardEntity e = new StorageCardEntity();
            e.setId(IDGenerate.getUniqueIdStr());
            e.setGiftTitle((String)map.get("gift_title"));
            e.setGiftImg("");
            e.setGiftCash(new BigDecimal(((Float)map.get("pay_cash")).floatValue()));
            e.setFreeCash(new BigDecimal((Integer)map.get("give_cash")));
            e.setGiftState(Integer.valueOf((Integer)map.get("state")));
            e.setPlatformGroupId(Integer.valueOf(1000));
            e.setCreateTime(new Date());
            e.setCreateBy("IMPORT");
            this.storageCardMapper.insert((Object)e);
        });
        return BaseJsonVo.success(null);
    }
}

