/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.service.account;

import cc.lechun.balance.api.UserBalanceApi;
import cc.lechun.balance.common.constants.BalanceTypeEnum;
import cc.lechun.balance.common.constants.DetailTypeEnum;
import cc.lechun.balance.dao.account.UserBalanceChangeMapper;
import cc.lechun.balance.dao.account.UserBalanceDetailMapper;
import cc.lechun.balance.dao.account.UserBalanceDetailReleMapper;
import cc.lechun.balance.dao.account.UserBalanceMapper;
import cc.lechun.balance.entity.account.UserBalanceChangeEntity;
import cc.lechun.balance.entity.account.UserBalanceDetailEntity;
import cc.lechun.balance.entity.account.UserBalanceDetailReleEntity;
import cc.lechun.balance.entity.account.UserBalanceEntity;
import cc.lechun.balance.entity.account.UserBalanceEntityExample;
import cc.lechun.balance.iservice.account.UserBalanceInterface;
import cc.lechun.balance.service.BaseService;
import cc.lechun.balance.service.account.UserBalanceService;
import cc.lechun.framework.common.utils.cache.RedisLock;
import cc.lechun.framework.common.utils.cache.RedisLockParameter;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserBalanceService
extends BaseService<UserBalanceEntity, String, UserBalanceEntityExample>
implements UserBalanceInterface {
    @Autowired
    UserBalanceMapper userBalanceMapper;
    @Autowired
    UserBalanceDetailMapper userBalanceDetailMapper;
    @Autowired
    UserBalanceChangeMapper userBalanceChangeMapper;
    @Autowired
    UserBalanceDetailReleMapper userBalanceDetailReleMapper;
    @Autowired
    UserBalanceApi userBalanceApi;

    public UserBalanceEntity selectByCustomerId(String customerId) {
        UserBalanceEntity entity = (UserBalanceEntity)this.userBalanceMapper.selectByPrimaryKey((Serializable)((Object)customerId));
        if (entity == null || entity.getCustomerId() == null) {
            entity = new UserBalanceEntity();
            entity.setCustomerId(customerId);
            entity.setUsableTotalBalance(BigDecimal.ZERO);
            entity.setUsableStoreBalance(BigDecimal.ZERO);
            entity.setUsableFreeBalance(BigDecimal.ZERO);
            entity.setUsableGiftBalance(BigDecimal.ZERO);
            entity.setTotalStoreBalance(BigDecimal.ZERO);
            entity.setTotalFreeBalance(BigDecimal.ZERO);
            entity.setTotalGiftBalance(BigDecimal.ZERO);
            entity.setCreateTime(DateUtils.now());
            entity.setBalanceState(Integer.valueOf(1));
            entity.setCreateBy(customerId);
            this.userBalanceMapper.insertSelective((Object)entity);
        }
        return entity;
    }

    public BaseJsonVo<UserBalanceEntity> increaseAccount(String customerId, BigDecimal increaseAmount, BalanceTypeEnum balanceType, String operator, int increaseType) {
        UserBalanceEntity userBalanceEntity;
        if (increaseAmount == null) {
            increaseAmount = BigDecimal.ZERO;
        }
        if ((userBalanceEntity = (UserBalanceEntity)this.userBalanceMapper.selectByPrimaryKey((Serializable)((Object)customerId))) == null) {
            userBalanceEntity = new UserBalanceEntity();
            userBalanceEntity.setCustomerId(customerId);
            userBalanceEntity.setBalanceState(Integer.valueOf(1));
            userBalanceEntity.setUsableTotalBalance(increaseAmount);
            switch (1.$SwitchMap$cc$lechun$balance$common$constants$BalanceTypeEnum[balanceType.ordinal()]) {
                case 1: {
                    userBalanceEntity.setUsableStoreBalance(increaseAmount);
                    userBalanceEntity.setTotalStoreBalance(increaseAmount);
                    break;
                }
                case 2: {
                    userBalanceEntity.setUsableFreeBalance(increaseAmount);
                    userBalanceEntity.setTotalFreeBalance(increaseAmount);
                    break;
                }
                case 3: {
                    userBalanceEntity.setUsableGiftBalance(increaseAmount);
                    userBalanceEntity.setTotalGiftBalance(increaseAmount);
                    break;
                }
            }
            userBalanceEntity.setCreateBy(operator);
            userBalanceEntity.setCreateTime(new Date());
            this.userBalanceMapper.insertSelective((Object)userBalanceEntity);
        } else {
            Date updateTime = new Date();
            userBalanceEntity.setUpdateBy(operator);
            userBalanceEntity.setUpdateTime(updateTime);
            switch (1.$SwitchMap$cc$lechun$balance$common$constants$BalanceTypeEnum[balanceType.ordinal()]) {
                case 1: {
                    userBalanceEntity.setUsableStoreBalance(userBalanceEntity.getUsableStoreBalance().add(increaseAmount));
                    if (increaseType == 2) {
                        userBalanceEntity.setTotalStoreBalance(userBalanceEntity.getTotalStoreBalance().add(increaseAmount));
                    }
                    this.userBalanceMapper.increaseStore(customerId, increaseAmount, operator, updateTime, increaseType);
                    break;
                }
                case 2: {
                    userBalanceEntity.setUsableFreeBalance(userBalanceEntity.getUsableFreeBalance().add(increaseAmount));
                    if (increaseType == 2) {
                        userBalanceEntity.setTotalFreeBalance(userBalanceEntity.getTotalFreeBalance().add(increaseAmount));
                    }
                    this.userBalanceMapper.increaseFree(customerId, increaseAmount, operator, updateTime, increaseType);
                    break;
                }
                case 3: {
                    userBalanceEntity.setUsableGiftBalance(userBalanceEntity.getUsableGiftBalance().add(increaseAmount));
                    if (increaseType == 2) {
                        userBalanceEntity.setTotalGiftBalance(userBalanceEntity.getTotalGiftBalance().add(increaseAmount));
                    }
                    this.userBalanceMapper.increaseGift(customerId, increaseAmount, operator, updateTime, increaseType);
                    break;
                }
            }
        }
        userBalanceEntity.setUsableTotalBalance(userBalanceEntity.getUsableTotalBalance().add(increaseAmount));
        this.remoteCache((Serializable)((Object)customerId));
        return BaseJsonVo.success((Object)userBalanceEntity);
    }

    public BaseJsonVo<UserBalanceEntity> decreaseAccount(String customerId, BigDecimal decreaseAmount, BalanceTypeEnum balanceType, String operator, int decreaseType) {
        UserBalanceEntity userBalanceEntity = (UserBalanceEntity)this.userBalanceMapper.selectByPrimaryKey((Serializable)((Object)customerId));
        if (userBalanceEntity == null) {
            return BaseJsonVo.error((String)"\u8d26\u6237\u4f59\u989d\u5f02\u5e38\uff1a\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        if (userBalanceEntity.getUsableTotalBalance().compareTo(decreaseAmount) < 0) {
            return BaseJsonVo.error((String)"\u8d26\u6237\u4f59\u989d\u5f02\u5e38\uff1a\u8be5\u7528\u6237\u50a8\u503c\u5c0f\u4e8e\u8be5\u7b14\u50a8\u503c\u5269\u4f59");
        }
        if (decreaseAmount.compareTo(new BigDecimal("0")) <= 0) {
            BaseJsonVo.success((Object)userBalanceEntity);
        }
        Date updateTime = new Date();
        userBalanceEntity.setUpdateBy(operator);
        userBalanceEntity.setUpdateTime(updateTime);
        switch (1.$SwitchMap$cc$lechun$balance$common$constants$BalanceTypeEnum[balanceType.ordinal()]) {
            case 1: {
                userBalanceEntity.setUsableStoreBalance(userBalanceEntity.getUsableStoreBalance().subtract(decreaseAmount));
                if (decreaseType == 1) {
                    userBalanceEntity.setTotalStoreBalance(userBalanceEntity.getTotalStoreBalance().subtract(decreaseAmount));
                }
                this.userBalanceMapper.decreaseStore(customerId, decreaseAmount, operator, updateTime, decreaseType);
                break;
            }
            case 2: {
                userBalanceEntity.setUsableFreeBalance(userBalanceEntity.getUsableFreeBalance().subtract(decreaseAmount));
                if (decreaseType == 1) {
                    userBalanceEntity.setTotalFreeBalance(userBalanceEntity.getTotalFreeBalance().subtract(decreaseAmount));
                }
                this.userBalanceMapper.decreaseFree(customerId, decreaseAmount, operator, updateTime, decreaseType);
                break;
            }
            case 3: {
                userBalanceEntity.setUsableGiftBalance(userBalanceEntity.getUsableGiftBalance().subtract(decreaseAmount));
                if (decreaseType == 1) {
                    userBalanceEntity.setTotalGiftBalance(userBalanceEntity.getTotalGiftBalance().subtract(decreaseAmount));
                }
                this.userBalanceMapper.decreaseGift(customerId, decreaseAmount, operator, updateTime, decreaseType);
                break;
            }
        }
        this.remoteCache((Serializable)((Object)userBalanceEntity.getCustomerId()));
        userBalanceEntity.setUsableTotalBalance(userBalanceEntity.getUsableTotalBalance().subtract(decreaseAmount));
        return BaseJsonVo.success((Object)userBalanceEntity);
    }

    public void importData() {
        this.logger.info("########################################\u5f00\u59cb\u5237detail");
        int i = 0;
        while (true) {
            this.logger.info("#####detail\u7b2c[" + i + "]\u9875");
            List balanceDetails = this.userBalanceMapper.findOldBalanceDetail(i * 100000);
            balanceDetails.forEach(balanceDetail -> {
                UserBalanceDetailEntity e = new UserBalanceDetailEntity();
                e.setId(IDGenerate.getUniqueIdStr());
                e.setCustomerId((String)balanceDetail.get("userId"));
                e.setDetailType(Integer.valueOf((String)balanceDetail.get("type")));
                if ("1".equals(balanceDetail.get("sub_type"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.STORE.getName());
                } else if ("2".equals(balanceDetail.get("sub_type"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ACTIVE_FREE.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.ACTIVE_FREE.getName());
                    e.setRemark((String)balanceDetail.get("msg"));
                } else if ("3".equals(balanceDetail.get("sub_type"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER_REFUND.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.ORDER_REFUND.getName());
                } else if ("5".equals(balanceDetail.get("sub_type"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ACTIVE_FREE.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.ACTIVE_FREE.getName());
                    e.setRemark((String)balanceDetail.get("msg"));
                } else if ("6".equals(balanceDetail.get("sub_type"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER_CONSUME_CASHBACK.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.ORDER_CONSUME_CASHBACK.getName());
                } else if ("7".equals(balanceDetail.get("sub_type"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE_FREE.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.STORE_FREE.getName());
                } else if ("8".equals(balanceDetail.get("sub_type"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.GIFT_CHARGE.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.GIFT_CHARGE.getName());
                } else if ("9".equals(balanceDetail.get("sub_type")) && "\u3010\u6263\u9664\u3011\u50a8\u503c\u9000\u6b3e,\u6263\u9664\u8fd4\u73b0".equals(balanceDetail.get("msg"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE_REFUND_REDUCT_CASHBACK.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.STORE_REFUND_REDUCT_CASHBACK.getName());
                } else if ("9".equals(balanceDetail.get("sub_type")) && "\u3010\u6263\u9664\u3011\u8ba2\u5355\u9000\u6b3e,\u6263\u9664\u8fd4\u73b0".equals(balanceDetail.get("msg"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER_REFUND_REDUCT_CASHBACK.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.ORDER_REFUND_REDUCT_CASHBACK.getName());
                } else if ("10".equals(balanceDetail.get("sub_type"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER_REFUND_REDUCT_CASHBACK.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.ORDER_REFUND_REDUCT_CASHBACK.getName());
                } else if ("11".equals(balanceDetail.get("sub_type"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE_REFUND.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.STORE_REFUND.getName());
                } else if ("12".equals(balanceDetail.get("sub_type")) || "20".equals(balanceDetail.get("sub_type")) && "\u3010\u589e\u52a0\u3011\u7cfb\u7edf\u589e\u52a0\u50a8\u503c".equals(balanceDetail.get("msg"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.MANUAL_INCREASE.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.MANUAL_INCREASE.getName());
                } else if ("13".equals(balanceDetail.get("sub_type")) || "21".equals(balanceDetail.get("sub_type")) && "\u3010\u51cf\u5c11\u3011\u7cfb\u7edf\u6263\u9664\u50a8\u503c".equals(balanceDetail.get("msg"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.MANUAL_DECREASE.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.MANUAL_DECREASE.getName());
                } else if ("20".equals(balanceDetail.get("sub_type")) && "\u3010\u6d88\u8d39\u3011\u8d2d\u4e70\u5546\u54c1".equals(balanceDetail.get("msg"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.ORDER.getName());
                } else if ("21".equals(balanceDetail.get("sub_type")) && "\u3010\u9000\u6b3e\u3011\u8ba2\u5355\u53d6\u6d88".equals(balanceDetail.get("msg"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER_CANCEL.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.ORDER_CANCEL.getName());
                } else if ("99".equals(balanceDetail.get("sub_type"))) {
                    e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ACTIVE_FREE.getValue()));
                    e.setDetailSubTypeDesc(DetailTypeEnum.ACTIVE_FREE.getName());
                    e.setRemark((String)balanceDetail.get("msg"));
                }
                e.setChangeMoney(PriceUtils.format((BigDecimal)new BigDecimal((Integer)balanceDetail.get("pay_money")).divide(new BigDecimal(100))));
                e.setAccountTotal(PriceUtils.format((BigDecimal)new BigDecimal((Integer)balanceDetail.get("wealth")).divide(new BigDecimal(100))));
                e.setOrderMainNo((String)balanceDetail.get("order_id"));
                e.setGiftId(balanceDetail.get("gift_id") == null ? null : String.valueOf(balanceDetail.get("gift_id")));
                e.setGiftTitle((String)balanceDetail.get("gift_title"));
                if ("20".equals(balanceDetail.get("sub_type"))) {
                    e.setDetailStatus(Integer.valueOf(0));
                }
                e.setCreateTime((Date)balanceDetail.get("create_time"));
                e.setCreateBy("IMPORT");
                if (StringUtils.isEmpty((String)e.getRemark())) {
                    e.setRemark((String)balanceDetail.get("note"));
                }
                this.userBalanceMapper.updateOldBalanceDetail(((Integer)balanceDetail.get("id")).intValue(), e.getId());
                if (e.getDetailType() == 1) {
                    UserBalanceChangeEntity ec = new UserBalanceChangeEntity();
                    ec.setDetailId(e.getId());
                    ec.setIncomeTotalMoney(e.getChangeMoney());
                    ec.setUsableMoney(PriceUtils.format((BigDecimal)new BigDecimal((Integer)balanceDetail.get("remain_pay_money")).divide(new BigDecimal(100))));
                    ec.setCreateTime(e.getCreateTime());
                    ec.setCreateBy("IMPORT");
                    this.userBalanceChangeMapper.insert((Object)ec);
                }
                if (e.getDetailType() == 21) {
                    this.userBalanceMapper.updateOldBalanceDetailMoney(e.getOrderMainNo(), e.getChangeMoney(), BigDecimal.ZERO, 1);
                } else if (e.getDetailType() == 3) {
                    this.userBalanceMapper.updateOldBalanceDetailMoney(e.getOrderMainNo(), BigDecimal.ZERO, e.getChangeMoney(), 2);
                }
                this.userBalanceDetailMapper.insert((Object)e);
            });
            if (balanceDetails.size() < 100000) break;
            ++i;
        }
        this.logger.info("########################################\u5f00\u59cb\u5237rele");
        i = 0;
        while (true) {
            this.logger.info("#####rele\u7b2c[" + i + "]\u9875");
            List balanceDetailReles = this.userBalanceMapper.findOldBalanceDetailRele(i * 100000);
            balanceDetailReles.forEach(balanceDetailRele -> {
                UserBalanceDetailReleEntity e = new UserBalanceDetailReleEntity();
                e.setId(IDGenerate.getUniqueIdStr());
                e.setExpendId((String)balanceDetailRele.get("expend_id"));
                e.setIncomeId((String)balanceDetailRele.get("income_id"));
                e.setPayMoney(PriceUtils.format((BigDecimal)new BigDecimal((Integer)balanceDetailRele.get("pay_money")).divide(new BigDecimal(100))));
                e.setCancelMoney(balanceDetailRele.get("cancle_money") == null ? null : new BigDecimal((Integer)balanceDetailRele.get("cancle_money")));
                e.setRefundMoney(balanceDetailRele.get("refund_money") == null ? null : new BigDecimal((Integer)balanceDetailRele.get("refund_money")));
                e.setCreateTime((Date)balanceDetailRele.get("create_time"));
                e.setCreateBy("IMPORT");
                this.userBalanceDetailReleMapper.insert((Object)e);
            });
            if (balanceDetailReles.size() < 100000) break;
            ++i;
        }
        this.logger.info("########################################\u5f00\u59cb\u5237balance");
        List balances = this.userBalanceMapper.findOldBalance();
        String[] customerId = new String[]{new String("")};
        BigDecimal[] usabel = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        BigDecimal[] total = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        balances.forEach(balance -> {
            if (!customerId[0].equals(balance.get("customer_id"))) {
                if (StringUtils.isNotEmpty((String)customerId[0])) {
                    UserBalanceEntity e = new UserBalanceEntity();
                    e.setCustomerId(customerId[0]);
                    e.setUsableTotalBalance(PriceUtils.format((BigDecimal)usabel[0].divide(new BigDecimal(100))));
                    e.setUsableStoreBalance(PriceUtils.format((BigDecimal)usabel[1]));
                    e.setUsableFreeBalance(PriceUtils.format((BigDecimal)usabel[3]));
                    e.setUsableGiftBalance(PriceUtils.format((BigDecimal)usabel[2]));
                    e.setTotalStoreBalance(PriceUtils.format((BigDecimal)total[0]));
                    e.setTotalFreeBalance(PriceUtils.format((BigDecimal)total[2]));
                    e.setTotalGiftBalance(PriceUtils.format((BigDecimal)total[1]));
                    e.setBalanceState(Integer.valueOf(1));
                    e.setCreateTime(new Date());
                    e.setCreateBy("IMPORT");
                    this.userBalanceMapper.insertSelective((Object)e);
                }
                customerId[0] = (String)balance.get("customer_id");
                usabel[0] = BigDecimal.ZERO;
                usabel[1] = BigDecimal.ZERO;
                usabel[2] = BigDecimal.ZERO;
                usabel[3] = BigDecimal.ZERO;
                total[0] = BigDecimal.ZERO;
                total[1] = BigDecimal.ZERO;
                total[2] = BigDecimal.ZERO;
            }
            usabel[0] = new BigDecimal((Integer)balance.get("wealth"));
            if (DetailTypeEnum.STORE.getValue() == ((Integer)balance.get("detail_sub_type")).intValue()) {
                usabel[1] = usabel[1].add((BigDecimal)balance.get("sum_usable_money"));
            } else if (DetailTypeEnum.GIFT_CHARGE.getValue() == ((Integer)balance.get("detail_sub_type")).intValue()) {
                usabel[2] = usabel[2].add((BigDecimal)balance.get("sum_usable_money"));
            } else {
                usabel[3] = usabel[3].add((BigDecimal)balance.get("sum_usable_money"));
            }
            if (DetailTypeEnum.STORE.getValue() == ((Integer)balance.get("detail_sub_type")).intValue()) {
                total[0] = total[0].add((BigDecimal)balance.get("sum_total_money"));
            } else if (DetailTypeEnum.GIFT_CHARGE.getValue() == ((Integer)balance.get("detail_sub_type")).intValue()) {
                total[1] = total[1].add((BigDecimal)balance.get("sum_total_money"));
            } else {
                total[2] = total[2].add((BigDecimal)balance.get("sum_total_money"));
            }
        });
        UserBalanceEntity e = new UserBalanceEntity();
        e.setCustomerId(customerId[0]);
        e.setUsableTotalBalance(PriceUtils.format((BigDecimal)usabel[0].divide(new BigDecimal(100))));
        e.setUsableStoreBalance(PriceUtils.format((BigDecimal)usabel[1]));
        e.setUsableFreeBalance(PriceUtils.format((BigDecimal)usabel[3]));
        e.setUsableGiftBalance(PriceUtils.format((BigDecimal)usabel[2]));
        e.setTotalStoreBalance(PriceUtils.format((BigDecimal)total[0]));
        e.setTotalFreeBalance(PriceUtils.format((BigDecimal)total[2]));
        e.setTotalGiftBalance(PriceUtils.format((BigDecimal)total[1]));
        e.setBalanceState(Integer.valueOf(1));
        e.setCreateTime(new Date());
        e.setCreateBy("IMPORT");
        this.userBalanceMapper.insertSelective((Object)e);
        this.logger.info("\u5237\u5b8c\u4e86");
    }

    public void updateData() {
        this.logger.info("########################################\u5f00\u59cb\u589e\u91cf\u5237detail");
        List balanceDetails = this.userBalanceMapper.findOldBalanceDetailIncrement();
        balanceDetails.forEach(balanceDetail -> {
            UserBalanceDetailEntity e = new UserBalanceDetailEntity();
            e.setId(IDGenerate.getUniqueIdStr());
            e.setCustomerId((String)balanceDetail.get("userId"));
            e.setDetailType(Integer.valueOf((String)balanceDetail.get("type")));
            if ("1".equals(balanceDetail.get("sub_type"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.STORE.getName());
            } else if ("2".equals(balanceDetail.get("sub_type"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ACTIVE_FREE.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.ACTIVE_FREE.getName());
                e.setRemark((String)balanceDetail.get("msg"));
            } else if ("3".equals(balanceDetail.get("sub_type"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER_REFUND.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.ORDER_REFUND.getName());
            } else if ("5".equals(balanceDetail.get("sub_type"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ACTIVE_FREE.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.ACTIVE_FREE.getName());
                e.setRemark((String)balanceDetail.get("msg"));
            } else if ("6".equals(balanceDetail.get("sub_type"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER_CONSUME_CASHBACK.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.ORDER_CONSUME_CASHBACK.getName());
            } else if ("7".equals(balanceDetail.get("sub_type"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE_FREE.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.STORE_FREE.getName());
            } else if ("8".equals(balanceDetail.get("sub_type"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.GIFT_CHARGE.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.GIFT_CHARGE.getName());
            } else if ("9".equals(balanceDetail.get("sub_type")) && "\u3010\u6263\u9664\u3011\u50a8\u503c\u9000\u6b3e,\u6263\u9664\u8fd4\u73b0".equals(balanceDetail.get("msg"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE_REFUND_REDUCT_CASHBACK.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.STORE_REFUND_REDUCT_CASHBACK.getName());
            } else if ("9".equals(balanceDetail.get("sub_type")) && "\u3010\u6263\u9664\u3011\u8ba2\u5355\u9000\u6b3e,\u6263\u9664\u8fd4\u73b0".equals(balanceDetail.get("msg"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER_REFUND_REDUCT_CASHBACK.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.ORDER_REFUND_REDUCT_CASHBACK.getName());
            } else if ("10".equals(balanceDetail.get("sub_type"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER_REFUND_REDUCT_CASHBACK.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.ORDER_REFUND_REDUCT_CASHBACK.getName());
            } else if ("11".equals(balanceDetail.get("sub_type"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.STORE_REFUND.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.STORE_REFUND.getName());
            } else if ("12".equals(balanceDetail.get("sub_type")) || "20".equals(balanceDetail.get("sub_type")) && "\u3010\u589e\u52a0\u3011\u7cfb\u7edf\u589e\u52a0\u50a8\u503c".equals(balanceDetail.get("msg"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.MANUAL_INCREASE.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.MANUAL_INCREASE.getName());
            } else if ("13".equals(balanceDetail.get("sub_type")) || "21".equals(balanceDetail.get("sub_type")) && "\u3010\u51cf\u5c11\u3011\u7cfb\u7edf\u6263\u9664\u50a8\u503c".equals(balanceDetail.get("msg"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.MANUAL_DECREASE.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.MANUAL_DECREASE.getName());
            } else if ("20".equals(balanceDetail.get("sub_type")) && "\u3010\u6d88\u8d39\u3011\u8d2d\u4e70\u5546\u54c1".equals(balanceDetail.get("msg"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.ORDER.getName());
            } else if ("21".equals(balanceDetail.get("sub_type")) && "\u3010\u9000\u6b3e\u3011\u8ba2\u5355\u53d6\u6d88".equals(balanceDetail.get("msg"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ORDER_CANCEL.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.ORDER_CANCEL.getName());
            } else if ("99".equals(balanceDetail.get("sub_type"))) {
                e.setDetailSubType(Integer.valueOf(DetailTypeEnum.ACTIVE_FREE.getValue()));
                e.setDetailSubTypeDesc(DetailTypeEnum.ACTIVE_FREE.getName());
                e.setRemark((String)balanceDetail.get("msg"));
            }
            e.setChangeMoney(PriceUtils.format((BigDecimal)new BigDecimal((Integer)balanceDetail.get("pay_money")).divide(new BigDecimal(100))));
            e.setAccountTotal(PriceUtils.format((BigDecimal)new BigDecimal((Integer)balanceDetail.get("wealth")).divide(new BigDecimal(100))));
            e.setOrderMainNo((String)balanceDetail.get("order_id"));
            e.setGiftId(balanceDetail.get("gift_id") == null ? null : String.valueOf(balanceDetail.get("gift_id")));
            e.setGiftTitle((String)balanceDetail.get("gift_title"));
            if ("20".equals(balanceDetail.get("sub_type"))) {
                e.setDetailStatus(Integer.valueOf(0));
            }
            e.setCreateTime((Date)balanceDetail.get("create_time"));
            e.setCreateBy("IMPORT");
            if (StringUtils.isEmpty((String)e.getRemark())) {
                e.setRemark((String)balanceDetail.get("note"));
            }
            this.userBalanceMapper.updateOldBalanceDetail(((Integer)balanceDetail.get("id")).intValue(), e.getId());
            if (e.getDetailType() == 1) {
                UserBalanceChangeEntity ec = new UserBalanceChangeEntity();
                ec.setDetailId(e.getId());
                ec.setIncomeTotalMoney(e.getChangeMoney());
                ec.setUsableMoney(PriceUtils.format((BigDecimal)new BigDecimal((Integer)balanceDetail.get("remain_pay_money")).divide(new BigDecimal(100))));
                ec.setCreateTime(e.getCreateTime());
                ec.setCreateBy("IMPORT");
                this.userBalanceChangeMapper.insert((Object)ec);
            }
            if (e.getDetailType() == 21) {
                this.userBalanceMapper.updateOldBalanceDetailMoney(e.getOrderMainNo(), e.getChangeMoney(), BigDecimal.ZERO, 1);
            } else if (e.getDetailType() == 3) {
                this.userBalanceMapper.updateOldBalanceDetailMoney(e.getOrderMainNo(), BigDecimal.ZERO, e.getChangeMoney(), 2);
            }
            this.userBalanceDetailMapper.insert((Object)e);
        });
        this.logger.info("########################################\u5f00\u59cb\u589e\u91cf\u5237rele");
        List balanceDetailReles = this.userBalanceMapper.findOldBalanceDetailReleIncrement();
        balanceDetailReles.forEach(balanceDetailRele -> {
            UserBalanceDetailReleEntity e = new UserBalanceDetailReleEntity();
            e.setId(IDGenerate.getUniqueIdStr());
            e.setExpendId((String)balanceDetailRele.get("expend_id"));
            e.setIncomeId((String)balanceDetailRele.get("income_id"));
            e.setPayMoney(PriceUtils.format((BigDecimal)new BigDecimal((Integer)balanceDetailRele.get("pay_money")).divide(new BigDecimal(100))));
            e.setCancelMoney(balanceDetailRele.get("cancle_money") == null ? null : new BigDecimal((Integer)balanceDetailRele.get("cancle_money")));
            e.setRefundMoney(balanceDetailRele.get("refund_money") == null ? null : new BigDecimal((Integer)balanceDetailRele.get("refund_money")));
            e.setCreateTime((Date)balanceDetailRele.get("create_time"));
            e.setCreateBy("IMPORT");
            this.userBalanceDetailReleMapper.insert((Object)e);
        });
        this.logger.info("########################################\u5f00\u59cb\u5168\u91cf\u5237balance");
        List balances = this.userBalanceMapper.findOldBalance();
        String[] customerId = new String[]{new String("")};
        BigDecimal[] usabel = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        BigDecimal[] total = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        balances.forEach(balance -> {
            if (!customerId[0].equals(balance.get("customer_id"))) {
                if (StringUtils.isNotEmpty((String)customerId[0])) {
                    UserBalanceEntity e = new UserBalanceEntity();
                    e.setCustomerId(customerId[0]);
                    e.setUsableTotalBalance(PriceUtils.format((BigDecimal)usabel[0].divide(new BigDecimal(100))));
                    e.setUsableStoreBalance(PriceUtils.format((BigDecimal)usabel[1]));
                    e.setUsableFreeBalance(PriceUtils.format((BigDecimal)usabel[3]));
                    e.setUsableGiftBalance(PriceUtils.format((BigDecimal)usabel[2]));
                    e.setTotalStoreBalance(PriceUtils.format((BigDecimal)total[0]));
                    e.setTotalFreeBalance(PriceUtils.format((BigDecimal)total[2]));
                    e.setTotalGiftBalance(PriceUtils.format((BigDecimal)total[1]));
                    e.setBalanceState(Integer.valueOf(1));
                    e.setCreateTime(new Date());
                    e.setCreateBy("IMPORT");
                    this.userBalanceMapper.insertSelective((Object)e);
                }
                customerId[0] = (String)balance.get("customer_id");
                usabel[0] = BigDecimal.ZERO;
                usabel[1] = BigDecimal.ZERO;
                usabel[2] = BigDecimal.ZERO;
                usabel[3] = BigDecimal.ZERO;
                total[0] = BigDecimal.ZERO;
                total[1] = BigDecimal.ZERO;
                total[2] = BigDecimal.ZERO;
            }
            usabel[0] = new BigDecimal((Integer)balance.get("wealth"));
            if (DetailTypeEnum.STORE.getValue() == ((Integer)balance.get("detail_sub_type")).intValue()) {
                usabel[1] = usabel[1].add((BigDecimal)balance.get("sum_usable_money"));
            } else if (DetailTypeEnum.GIFT_CHARGE.getValue() == ((Integer)balance.get("detail_sub_type")).intValue()) {
                usabel[2] = usabel[2].add((BigDecimal)balance.get("sum_usable_money"));
            } else {
                usabel[3] = usabel[3].add((BigDecimal)balance.get("sum_usable_money"));
            }
            if (DetailTypeEnum.STORE.getValue() == ((Integer)balance.get("detail_sub_type")).intValue()) {
                total[0] = total[0].add((BigDecimal)balance.get("sum_total_money"));
            } else if (DetailTypeEnum.GIFT_CHARGE.getValue() == ((Integer)balance.get("detail_sub_type")).intValue()) {
                total[1] = total[1].add((BigDecimal)balance.get("sum_total_money"));
            } else {
                total[2] = total[2].add((BigDecimal)balance.get("sum_total_money"));
            }
        });
        UserBalanceEntity e = new UserBalanceEntity();
        e.setCustomerId(customerId[0]);
        e.setUsableTotalBalance(PriceUtils.format((BigDecimal)usabel[0].divide(new BigDecimal(100))));
        e.setUsableStoreBalance(PriceUtils.format((BigDecimal)usabel[1]));
        e.setUsableFreeBalance(PriceUtils.format((BigDecimal)usabel[3]));
        e.setUsableGiftBalance(PriceUtils.format((BigDecimal)usabel[2]));
        e.setTotalStoreBalance(PriceUtils.format((BigDecimal)total[0]));
        e.setTotalFreeBalance(PriceUtils.format((BigDecimal)total[2]));
        e.setTotalGiftBalance(PriceUtils.format((BigDecimal)total[1]));
        e.setBalanceState(Integer.valueOf(1));
        e.setCreateTime(new Date());
        e.setCreateBy("IMPORT");
        this.userBalanceMapper.insertSelective((Object)e);
        this.logger.info("\u5237\u5b8c\u4e86");
    }

    public void fixData() {
        this.logger.info("########################################\u5f00\u59cb\u62b9\u5e73balance");
        List needAdds = this.userBalanceMapper.findNeedAdd();
        needAdds.forEach(needAdd -> this.userBalanceApi.increaseManual((String)needAdd.get("customer_id"), (BigDecimal)needAdd.get("balance_change"), "fixData", "\u7cfb\u7edf\u5bfc\u5165"));
        List needMinuss = this.userBalanceMapper.findNeedMinus();
        needMinuss.forEach(needMinus -> this.userBalanceApi.reduceManual((String)needMinus.get("customer_id"), (BigDecimal)needMinus.get("balance_change"), "fixData", "\u7cfb\u7edf\u5bfc\u5165"));
        this.logger.info("########################################\u62b9\u5b8c\u4e86");
    }

    @RedisLock(key="BalanceLock", expire=1L, waitTime=60L)
    public void testRedisLock(@RedisLockParameter String customerId, int i) {
        this.logger.info(customerId + i + "\uff1a\u8fdb\u5165\u4e86testRedisLock");
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.logger.info(customerId + i + "\uff1a\u79bb\u5f00\u4e86");
    }
}

