/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.service.specialCard;

import cc.lechun.balance.dao.specialCard.SpecialCardMapper;
import cc.lechun.balance.entity.specialCard.SpecialCardEntity;
import cc.lechun.balance.entity.specialCard.SpecialCardEntityExample;
import cc.lechun.balance.entity.specialCard.SpecialCardLogEntity;
import cc.lechun.balance.iservice.specialCard.SpecialCardInterface;
import cc.lechun.balance.iservice.specialCard.SpecialCardLogInterface;
import cc.lechun.balance.service.BaseService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SpecialCardService
extends BaseService<SpecialCardEntity, String, SpecialCardEntityExample>
implements SpecialCardInterface {
    @Autowired
    SpecialCardMapper specialCardMapper;
    @Autowired
    SpecialCardLogInterface specialCardLogInterface;

    public BaseJsonVo payOrder(String cardNo, BigDecimal orderAmount) {
        BaseJsonVo vo = this.specialCardMapper.reduce(cardNo, orderAmount) == 0 ? BaseJsonVo.error((String)"\u6263\u51cf\u5931\u8d25") : BaseJsonVo.success((Object)"");
        this.remoteCache((Serializable)((Object)cardNo));
        return vo;
    }

    @Transactional
    public BaseJsonVo cancelOrder(SpecialCardLogEntity cardLog) {
        SpecialCardEntity card = (SpecialCardEntity)this.selectByPrimaryKey((Serializable)((Object)cardLog.getCardNo()));
        int cancelResult = this.specialCardMapper.cancel(cardLog.getCardNo(), cardLog.getChangeMoney());
        this.remoteCache((Serializable)((Object)cardLog.getCardNo()));
        if (cancelResult <= 0) {
            return BaseJsonVo.error((String)"\u9000\u8fd8\u4f59\u989d\u5931\u8d25");
        }
        cardLog.setLogId(null);
        cardLog.setLogType(Integer.valueOf(2));
        cardLog.setCreateTime(DateUtils.now());
        cardLog.setTotalAccount(card.getUsableAmount().add(cardLog.getChangeMoney()));
        return this.specialCardLogInterface.insert((Object)cardLog) == 0 ? BaseJsonVo.error((String)"\u8bb0\u5f55\u53d6\u6d88\u65e5\u5fd7\u5931\u8d25") : BaseJsonVo.success((Object)"");
    }

    public BaseJsonVo refundOrder(SpecialCardEntity specialCardEntity, String customerId, String operator) {
        SpecialCardEntity card = new SpecialCardEntity();
        card.setCardNo(specialCardEntity.getCardNo());
        card.setUsableAmount(BigDecimal.ZERO);
        card.setStatus(Integer.valueOf(2));
        int refundResult = this.updateByPrimaryKey((Object)card);
        if (refundResult <= 0) {
            return BaseJsonVo.error((String)"\u66f4\u65b0\u5361\u72b6\u6001\u5931\u8d25");
        }
        SpecialCardLogEntity cardLog = new SpecialCardLogEntity();
        cardLog.setLogType(Integer.valueOf(3));
        cardLog.setOrderMainNo("");
        cardLog.setCardNo(specialCardEntity.getCardNo());
        cardLog.setCustomerId(customerId);
        cardLog.setCreateTime(DateUtils.now());
        cardLog.setTotalAccount(BigDecimal.ZERO);
        cardLog.setChangeMoney(specialCardEntity.getUsableAmount());
        cardLog.setRemark(operator);
        return this.specialCardLogInterface.insert((Object)cardLog) == 0 ? BaseJsonVo.error((String)"\u8bb0\u5f55\u9000\u6b3e\u65e5\u5fd7\u5931\u8d25") : BaseJsonVo.success((Object)"");
    }

    @Transactional
    public BaseJsonVo recordRefundOrder(String cardNo, BigDecimal refundAmount, BigDecimal usableAmount, String orderMainNo, String customerId, String operator) {
        int recordResult = this.specialCardMapper.recordRefundOrder(cardNo, refundAmount);
        this.remoteCache((Serializable)((Object)cardNo));
        if (recordResult > 0) {
            SpecialCardLogEntity cardLog = new SpecialCardLogEntity();
            cardLog.setLogType(Integer.valueOf(3));
            cardLog.setOrderMainNo(orderMainNo);
            cardLog.setCardNo(cardNo);
            cardLog.setCustomerId(customerId);
            cardLog.setCreateTime(DateUtils.now());
            cardLog.setTotalAccount(usableAmount);
            cardLog.setChangeMoney(refundAmount);
            cardLog.setRemark(operator);
            return this.specialCardLogInterface.insert((Object)cardLog) == 0 ? BaseJsonVo.error((String)"\u8bb0\u5f55\u9000\u6b3e\u65e5\u5fd7\u5931\u8d25") : BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"\u8bb0\u5f55\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
    }

    @Transactional
    public BaseJsonVo recordRefundUndelivered(String cardNo, BigDecimal refundAmount, BigDecimal usableAmount, String customerId, String operator) {
        int recordResult = this.specialCardMapper.recordRefundUndelivered(cardNo, refundAmount);
        this.remoteCache((Serializable)((Object)cardNo));
        if (recordResult > 0) {
            SpecialCardLogEntity cardLog = new SpecialCardLogEntity();
            cardLog.setLogType(Integer.valueOf(2));
            cardLog.setOrderMainNo("");
            cardLog.setCardNo(cardNo);
            cardLog.setCustomerId(customerId);
            cardLog.setCreateTime(DateUtils.now());
            cardLog.setTotalAccount(usableAmount);
            cardLog.setChangeMoney(refundAmount);
            cardLog.setRemark(operator);
            return this.specialCardLogInterface.insert((Object)cardLog) == 0 ? BaseJsonVo.error((String)"\u8bb0\u5f55\u9000\u6b3e\u65e5\u5fd7\u5931\u8d25") : BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"\u8bb0\u5f55\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
    }

    public BaseJsonVo recordCancelOrder(String cardNo, BigDecimal refundAmount, BigDecimal usableAmount, String orderMainNo, String customerId, String operator) {
        int recordResult = this.specialCardMapper.recordCancelOrder(cardNo, refundAmount);
        this.remoteCache((Serializable)((Object)cardNo));
        if (recordResult > 0) {
            SpecialCardLogEntity cardLog = new SpecialCardLogEntity();
            cardLog.setLogType(Integer.valueOf(4));
            cardLog.setOrderMainNo(orderMainNo);
            cardLog.setCardNo(cardNo);
            cardLog.setCustomerId(customerId);
            cardLog.setCreateTime(DateUtils.now());
            cardLog.setTotalAccount(usableAmount.add(refundAmount));
            cardLog.setChangeMoney(refundAmount);
            cardLog.setRemark(operator);
            return this.specialCardLogInterface.insert((Object)cardLog) == 0 ? BaseJsonVo.error((String)"\u8bb0\u5f55\u9000\u6b3e\u65e5\u5fd7\u5931\u8d25") : BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"\u8bb0\u5f55\u9000\u6b3e\u91d1\u989d\u5931\u8d25");
    }

    public BigDecimal getSpecialTotal(String customerId, Integer cardType) {
        return this.specialCardMapper.getSpecialTotal(customerId, cardType);
    }

    public List<SpecialCardEntity> getUsableSpecialList(String customerId, Integer cardType) {
        return this.specialCardMapper.getUsableSpecialList(customerId, cardType);
    }
}

