/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.authority.service;

import cc.lechun.authority.dao.MallRoleMapper;
import cc.lechun.authority.entity.MallRoleEntity;
import cc.lechun.authority.iservice.SysResourceInterface;
import cc.lechun.authority.iservice.SysRoleInterface;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysRoleService
implements SysRoleInterface {
    @Autowired
    private MallRoleMapper mallRoleMapper;
    @Autowired
    SysResourceInterface sysResourceInterface;

    @Override
    public MallRoleEntity getMallRole(int roleId) {
        return (MallRoleEntity)this.mallRoleMapper.selectByPrimaryKey(Integer.valueOf(roleId));
    }

    @Override
    public BaseJsonVo saveMallRole(MallRoleEntity mallRoleEntity) {
        BaseJsonVo rs = this.validRole(mallRoleEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        this.mallRoleMapper.insertSelective(mallRoleEntity);
        return rs;
    }

    @Override
    public BaseJsonVo updateMallRole(MallRoleEntity mallRoleEntity) {
        BaseJsonVo rs = this.validRole(mallRoleEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        this.mallRoleMapper.updateByPrimaryKeySelective(mallRoleEntity);
        return rs;
    }

    private BaseJsonVo validRole(MallRoleEntity mallRoleEntity) {
        if (StringUtil.isEmpty((String)mallRoleEntity.getRoleName())) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u89d2\u8272\u540d\u79f0");
        }
        if (mallRoleEntity.getPlatformGroupId() == null) {
            return BaseJsonVo.paramError((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u516c\u53f8");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo getMallRoleList(int pageNum, int pageSize, String roleName, int platformGroupId, String userId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallRoleMapper.getMallRoleList(roleName, platformGroupId, userId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public List<MallRoleEntity> getAllRoles() {
        return this.mallRoleMapper.getList(new MallRoleEntity());
    }

    @Override
    public BaseJsonVo getRoleResources(Integer roleId) {
        List<Map<String, Object>> roleResources = this.mallRoleMapper.getRoleResource(roleId);
        ArrayList targetRoleResources = new ArrayList();
        roleResources.forEach(roleResource -> {
            if (roleResource.get("resourceParentId") == null || (Integer)roleResource.get("resourceParentId") == 0) {
                this.findChildren(roleResources, (Map<String, Object>)roleResource);
                targetRoleResources.add(roleResource);
            }
        });
        return BaseJsonVo.success(targetRoleResources);
    }

    private void findChildren(List<Map<String, Object>> list, Map<String, Object> parentResourceMap) {
        parentResourceMap.put("children", new ArrayList());
        List<Map> children = list.stream().filter(resource -> ((Integer)resource.get("resourceParentId")).intValue() == ((Integer)parentResourceMap.get("resourceId")).intValue()).collect(Collectors.toList());
        children.forEach(child -> {
            ((List)parentResourceMap.get("children")).add(child);
            this.findChildren(list, (Map<String, Object>)child);
        });
    }

    @Override
    public void deleteRoleResource(Integer roleId) {
        this.mallRoleMapper.deleteRoleResource(roleId);
    }
}

