/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.authority.service;

import cc.lechun.authority.dao.MallResourceGroupMapper;
import cc.lechun.authority.dao.MallResourceGroupRelationMapper;
import cc.lechun.authority.dao.MallResourceGroupUserMapper;
import cc.lechun.authority.dao.MallResourceMapper;
import cc.lechun.authority.entity.MallResourceEntity;
import cc.lechun.authority.entity.MallResourceGroupEntity;
import cc.lechun.authority.entity.MallResourceGroupRelationEntity;
import cc.lechun.authority.entity.MallResourceGroupUserEntity;
import cc.lechun.authority.iservice.SysResourceInterface;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysResourceService
extends BaseService<MallResourceEntity, Integer>
implements SysResourceInterface {
    @Autowired
    private MallResourceMapper mallResourceMapper;
    @Autowired
    private MallResourceGroupMapper mallResourceGroupMapper;
    @Autowired
    private MallResourceGroupUserMapper mallResourceGroupUserMapper;
    @Autowired
    private MallResourceGroupRelationMapper mallResourceGroupRelationMapper;

    @Override
    public BaseJsonVo saveMallResource(MallResourceEntity mallResourceEntity) {
        BaseJsonVo rs = this.valid(mallResourceEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        if (mallResourceEntity.getResourceParentId() == null || mallResourceEntity.getResourceParentId() == 0) {
            return BaseJsonVo.error((String)"\u4e0d\u5141\u8bb8\u65b0\u5efa\u6839\u76ee\u5f55\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458");
        }
        MallResourceEntity parent = (MallResourceEntity)this.mallResourceMapper.selectByPrimaryKey(mallResourceEntity.getResourceParentId());
        if (parent == null || parent.getResourceId() == null || parent.getResourceId() == 0) {
            return BaseJsonVo.error((String)"\u4e0a\u7ea7\u83dc\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458");
        }
        mallResourceEntity.setServiceId(parent.getServiceId());
        this.mallResourceMapper.insertSelective(mallResourceEntity);
        return rs;
    }

    @Override
    public BaseJsonVo updateMallResource(MallResourceEntity mallResourceEntity) {
        BaseJsonVo rs = this.valid(mallResourceEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        MallResourceEntity parent = (MallResourceEntity)this.mallResourceMapper.selectByPrimaryKey(mallResourceEntity.getResourceParentId());
        if (parent == null || parent.getResourceId() == null || parent.getResourceId() == 0) {
            return BaseJsonVo.error((String)"\u4e0a\u7ea7\u83dc\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458");
        }
        mallResourceEntity.setServiceId(parent.getServiceId());
        this.mallResourceMapper.updateByPrimaryKeySelective(mallResourceEntity);
        return rs;
    }

    @Override
    public PageInfo getMallResourceList(int pageNum, int pageSize, String resourceName, Integer roleId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallResourceMapper.getAllMallResourceList(resourceName, 1, roleId);
        PageInfo rs = page.toPageInfo();
        List list = rs.getList();
        ArrayList parentResources = new ArrayList();
        list.forEach(parentResource -> {
            if (parentResource.getResourceParentId() == null || parentResource.getResourceParentId() == 0) {
                Map parentResourceMap = ObjectConvert.objectConvertToObjectMap((Object)parentResource);
                this.findChildren(list, parentResourceMap);
                parentResources.add(parentResourceMap);
            }
        });
        rs.setList(parentResources);
        rs.setTotal(Long.valueOf(parentResources.size()).longValue());
        return rs;
    }

    private void findChildren(List<MallResourceEntity> list, Map<String, Object> parentResourceMap) {
        parentResourceMap.put("children", new ArrayList());
        List<MallResourceEntity> children = list.stream().filter(resource -> resource.getResourceParentId().intValue() == ((Integer)parentResourceMap.get("resourceId")).intValue()).collect(Collectors.toList());
        children.forEach(child -> {
            Map childMap = ObjectConvert.objectConvertToObjectMap((Object)child);
            ((List)parentResourceMap.get("children")).add(childMap);
            this.findChildren(list, childMap);
        });
    }

    @Override
    public PageInfo getMallParentResourceList(int pageNum, int pageSize, String resourceName, Integer resourceType, Integer roleId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallResourceMapper.getMallParentResourceList(resourceName, resourceType, roleId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public PageInfo getMallleafResourceList(int pageNum, int pageSize, int resourceParentId, Integer roleId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallResourceMapper.getMallleafResourceList(resourceParentId, roleId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    private BaseJsonVo valid(MallResourceEntity mallResourceEntity) {
        if (StringUtil.isEmpty((String)mallResourceEntity.getResourceName())) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u8d44\u6e90\u540d\u79f0");
        }
        if (mallResourceEntity.getResourceType() == null || mallResourceEntity.getResourceType() == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u8d44\u6e90\u7c7b\u578b");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo getResourceGroupList(Integer pageNum, Integer pageSize, Integer resourceId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallResourceGroupMapper.getPageList(resourceId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public BaseJsonVo getResourceGroupUsers(Integer groupId) {
        MallResourceGroupUserEntity param = new MallResourceGroupUserEntity();
        param.setGroupId(groupId);
        return BaseJsonVo.success((Object)this.mallResourceGroupUserMapper.getList(param));
    }

    @Override
    public BaseJsonVo saveResourceGroup(MallResourceGroupEntity mallResourceGroupEntity) {
        if (mallResourceGroupEntity.getGroupId() != null) {
            MallResourceGroupEntity origin = (MallResourceGroupEntity)this.mallResourceGroupMapper.selectByPrimaryKey(mallResourceGroupEntity.getGroupId());
            if (mallResourceGroupEntity.getGroupType() != origin.getGroupType()) {
                this.mallResourceGroupUserMapper.deleteByGroupId(mallResourceGroupEntity.getGroupId());
            }
            return BaseJsonVo.success((Object)this.mallResourceGroupMapper.updateByPrimaryKey(mallResourceGroupEntity));
        }
        return BaseJsonVo.success((Object)this.mallResourceGroupMapper.insert(mallResourceGroupEntity));
    }

    @Override
    @Transactional
    public BaseJsonVo saveResourceGroupUser(Integer groupId, String[] userIds) {
        this.mallResourceGroupUserMapper.deleteByGroupId(groupId);
        for (String userId : userIds) {
            MallResourceGroupUserEntity entity = new MallResourceGroupUserEntity();
            entity.setGroupId(groupId);
            entity.setUserId(userId);
            this.mallResourceGroupUserMapper.insert(entity);
        }
        return BaseJsonVo.success(null);
    }

    @Override
    @Transactional
    public BaseJsonVo saveResourceGroupRelations(Integer groupId, String[] relations) {
        this.mallResourceGroupRelationMapper.deleteByGroupId(groupId);
        for (String visibleGroupId : relations) {
            if (StringUtils.isEmpty((String)visibleGroupId)) continue;
            MallResourceGroupRelationEntity entity = new MallResourceGroupRelationEntity();
            entity.setGroupId(groupId);
            entity.setVisibleGroupId(Integer.valueOf(visibleGroupId));
            this.mallResourceGroupRelationMapper.insert(entity);
        }
        return BaseJsonVo.success(null);
    }

    @Override
    @Transactional
    public BaseJsonVo delResourceGroup(Integer groupId) {
        this.mallResourceGroupMapper.deleteByPrimaryKey(groupId);
        this.mallResourceGroupUserMapper.deleteByGroupId(groupId);
        this.mallResourceGroupRelationMapper.deleteByGroupId(groupId);
        return BaseJsonVo.success(null);
    }

    @Override
    public Set<String> findAssociateUsers(String userId, Integer resourceId) {
        return this.mallResourceGroupUserMapper.findAssociateUsers(userId, resourceId);
    }

    @Override
    public Set<String> findAssociateGroupUsers(String userId, Integer resourceId) {
        return this.mallResourceGroupUserMapper.findAssociateGroupUsers(userId, resourceId);
    }

    @Override
    public MallResourceEntity getResourceWithPath(String resourcePath) {
        MallResourceEntity param = new MallResourceEntity();
        param.setResourceHtmlUrl(resourcePath);
        List list = this.mallResourceMapper.getList(param);
        if (list != null && list.size() > 0) {
            return (MallResourceEntity)list.get(0);
        }
        return null;
    }

    @Override
    public List<MallResourceGroupEntity> getAllResourceGroups(Integer resourceId) {
        MallResourceGroupEntity param = new MallResourceGroupEntity();
        param.setResourceId(resourceId);
        return this.mallResourceGroupMapper.getList(param);
    }

    @Override
    public List<MallResourceGroupRelationEntity> getResourceVisibleGroups(Integer resourceId, Integer groupId) {
        MallResourceGroupRelationEntity param = new MallResourceGroupRelationEntity();
        param.setGroupId(groupId);
        return this.mallResourceGroupRelationMapper.getList(param);
    }
}

