/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.authority.Repository.shiro;

import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.codec.binary.Hex;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.SerializationUtils;

@Service
public class RedisSessionDao
extends AbstractSessionDAO {
    private long expireTime = 2592000L;
    @Autowired
    private RedisCacheUtil redisCacheUtil;

    public RedisSessionDao() {
    }

    public RedisSessionDao(long expireTime) {
        this.expireTime = expireTime;
    }

    public void update(Session session) throws UnknownSessionException {
        System.out.println("===============update================");
        if (session == null || session.getId() == null) {
            return;
        }
        session.setTimeout(this.expireTime);
        this.saveSession(session);
    }

    public void delete(Session session) {
        System.out.println("===============delete================");
        if (null == session) {
            return;
        }
        this.redisCacheUtil.remove(this.getKey(session.getId().toString()));
    }

    public Collection<Session> getActiveSessions() {
        return null;
    }

    private String getKey(String sessionId) {
        return "shiro_redis_session_" + sessionId;
    }

    protected Serializable doCreate(Session session) {
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.saveSession(session);
        return sessionId;
    }

    private void saveSession(Session session) {
        if (session != null && session.getId() != null) {
            byte[] value = SerializationUtils.serialize((Object)session);
            String str = Hex.encodeHexString((byte[])value);
            this.redisCacheUtil.set(this.getKey(session.getId().toString()), (Object)str, Long.valueOf(this.expireTime));
        }
    }

    protected Session doReadSession(Serializable sessionId) {
        if (sessionId == null) {
            return null;
        }
        String value = (String)this.redisCacheUtil.get(this.getKey(sessionId.toString()));
        if (value == null) {
            return null;
        }
        try {
            Session session;
            byte[] b = Hex.decodeHex((char[])value.toCharArray());
            Object obj = SerializationUtils.deserialize((byte[])b);
            Session session2 = session = obj instanceof Session ? (Session)obj : null;
            if (session == null) {
                // empty if block
            }
            return session;
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }
}

