/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.authority.service;

import cc.lechun.authority.dao.DingDepartmentMapper;
import cc.lechun.authority.dao.DingDeptManagerMapper;
import cc.lechun.authority.dao.DingStaffMapper;
import cc.lechun.authority.dao.MallUserManagerMapper;
import cc.lechun.authority.entity.DingDepartmentEntity;
import cc.lechun.authority.entity.DingDeptManagerEntity;
import cc.lechun.authority.entity.DingStaffEntity;
import cc.lechun.authority.entity.MallUserEntity;
import cc.lechun.authority.entity.MallUserManagerEntity;
import cc.lechun.authority.iservice.DingDeptStaffInterface;
import cc.lechun.authority.iservice.MallUserInterface;
import cc.lechun.baseservice.cache.RedisService;
import cc.lechun.baseservice.service.DingTalk.DingTalkService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.aliyun.dingtalkcontact_1_0.Client;
import com.aliyun.dingtalkcontact_1_0.models.ListEmpLeaveRecordsHeaders;
import com.aliyun.dingtalkcontact_1_0.models.ListEmpLeaveRecordsRequest;
import com.aliyun.dingtalkcontact_1_0.models.ListEmpLeaveRecordsResponse;
import com.aliyun.dingtalkcontact_1_0.models.ListEmpLeaveRecordsResponseBody;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiSmartworkHrmEmployeeV2ListRequest;
import com.dingtalk.api.request.OapiV2DepartmentGetRequest;
import com.dingtalk.api.request.OapiV2DepartmentListsubRequest;
import com.dingtalk.api.request.OapiV2UserListRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiSmartworkHrmEmployeeV2ListResponse;
import com.dingtalk.api.response.OapiV2DepartmentGetResponse;
import com.dingtalk.api.response.OapiV2DepartmentListsubResponse;
import com.dingtalk.api.response.OapiV2UserListResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DingDeptStaffService
implements DingDeptStaffInterface {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String appKey = "dingnvopco41y58jmbey";
    private String appSecret = "7vPy4iFzrHorL2bah1JofAhCdtZcDRQ00jl6A46yhfU00LAFVHwGO4XVbeDT54aK";
    private String robotCode = "dingnvopco41y58jmbey";
    @Autowired
    RedisService redisService;
    @Autowired
    DingDepartmentMapper dingDepartmentMapper;
    @Autowired
    MallUserInterface mallUserInterface;
    @Autowired
    DingTalkService dingTalkService;
    @Autowired
    DingStaffMapper dingStaffMapper;
    @Autowired
    DingDeptManagerMapper dingDeptManagerMapper;
    @Autowired
    MallUserManagerMapper mallUserManagerMapper;

    @Override
    public BaseJsonVo<String> getAccessToken() throws ApiException {
        String accessToken;
        String redisKey = "dingding_" + this.appKey + this.appSecret;
        Object o = this.redisService.get(redisKey);
        String string = accessToken = o != null ? o.toString() : "";
        if (StringUtils.isEmpty((String)accessToken)) {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
            OapiGettokenRequest req = new OapiGettokenRequest();
            req.setAppkey(this.appKey);
            req.setAppsecret(this.appSecret);
            req.setHttpMethod("GET");
            OapiGettokenResponse rsp = (OapiGettokenResponse)client.execute((TaobaoRequest)req);
            this.logger.info("\u9489\u9489TOKEN\uff1a{}", (Object)rsp.getBody());
            accessToken = rsp.getAccessToken();
            this.redisService.save(redisKey, (Object)accessToken, 7000L);
        }
        return BaseJsonVo.success((Object)accessToken);
    }

    @Override
    public BaseJsonVo getDingDept(Long deptId, Integer count) throws ApiException {
        BaseJsonVo<String> accessToken = this.getAccessToken();
        if (!accessToken.isSuccess()) {
            return accessToken;
        }
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/listsub");
        OapiV2DepartmentListsubRequest req = new OapiV2DepartmentListsubRequest();
        req.setDeptId(Long.valueOf(deptId == null ? 1L : deptId));
        req.setLanguage("zh_CN");
        OapiV2DepartmentListsubResponse rsp = (OapiV2DepartmentListsubResponse)client.execute((TaobaoRequest)req, (String)accessToken.getValue());
        if (rsp.getErrcode() != 0L) {
            return BaseJsonVo.error((String)rsp.getErrmsg());
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count + 1);
        for (OapiV2DepartmentListsubResponse.DeptBaseResponse deptBaseResponse : rsp.getResult()) {
            try {
                this.saveDingDepartDetail(deptBaseResponse.getDeptId().intValue());
            }
            catch (Exception e) {
                this.logger.error("\u4fdd\u5b58\u9489\u9489\u90e8\u95e8\u660e\u7ec6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
            this.getDingDept(deptBaseResponse.getDeptId(), count);
            this.getDingStaff(deptBaseResponse.getDeptId());
        }
        return BaseJsonVo.success((String)"\u540c\u6b65\u5b8c\u6210", null);
    }

    @Override
    public BaseJsonVo getDingStaff(Long deptId) throws ApiException {
        BaseJsonVo<String> accessToken = this.getAccessToken();
        if (!accessToken.isSuccess()) {
            return accessToken;
        }
        Long cursor = 0L;
        Boolean hasMore = true;
        do {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/list");
            OapiV2UserListRequest req = new OapiV2UserListRequest();
            req.setDeptId(deptId);
            req.setCursor(cursor);
            req.setSize(Long.valueOf(100L));
            req.setOrderField("modify_desc");
            req.setContainAccessLimit(Boolean.valueOf(false));
            req.setLanguage("zh_CN");
            OapiV2UserListResponse rsp = (OapiV2UserListResponse)client.execute((TaobaoRequest)req, (String)accessToken.getValue());
            if (rsp.getErrcode() != 0L) {
                return BaseJsonVo.error((String)rsp.getErrmsg());
            }
            OapiV2UserListResponse.PageResult result = rsp.getResult();
            hasMore = result.getHasMore();
            cursor = result.getNextCursor();
            if (result.getList() == null || result.getList().isEmpty()) continue;
            result.getList().forEach(user -> {
                List depts;
                String deptStr;
                this.logger.info("\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)JsonUtils.toJson((Object)user, (boolean)false));
                if (StringUtils.isEmpty((String)user.getEmail())) {
                    return;
                }
                if (user.getEmail().contains("yangyixuan")) {
                    this.logger.info("\u6768\u6021\u8431\u7684\u90ae\u7bb1\u662f:{}", (Object)user.getEmail());
                }
                MallUserEntity userEntity = this.mallUserInterface.getSysUser4name(user.getEmail());
                if (user.getEmail().contains("yangyixuan")) {
                    this.logger.info("\u6768\u6021\u8431\u7684\u90ae\u7bb1\u67e5\u627eentity\u662f:{}", (Object)JsonUtils.toJson((Object)userEntity, (boolean)false));
                }
                Boolean insert = false;
                if (userEntity == null) {
                    userEntity = new MallUserEntity();
                    userEntity.setUserName(user.getEmail());
                    userEntity.setUserId(IDGenerate.getUniqueIdStr());
                    userEntity.setPassword("18cfad9683e5f838241f611ddab2e81d");
                    userEntity.setCreateTime(new Date());
                    userEntity.setStatus(1);
                    insert = true;
                }
                if (StringUtils.isNotEmpty((String)user.getUserid())) {
                    userEntity.setDingdingId(user.getUserid());
                }
                String string = deptStr = (depts = user.getDeptIdList()) != null && !depts.isEmpty() ? depts.stream().map(String::valueOf).collect(Collectors.joining(",")) : "";
                if (StringUtils.isNotEmpty((String)deptStr)) {
                    userEntity.setDingdingDeptId(deptStr);
                }
                if (StringUtils.isNotEmpty((String)user.getName())) {
                    userEntity.setUserNick(user.getName());
                }
                if (StringUtils.isNotEmpty((String)user.getAvatar())) {
                    userEntity.setAvatar(user.getAvatar());
                }
                if (StringUtils.isNotEmpty((String)user.getUnionid())) {
                    userEntity.setDingdingUnionId(user.getUnionid());
                }
                if (StringUtils.isNotEmpty((String)user.getMobile())) {
                    userEntity.setMobile(user.getMobile());
                }
                if (user.getHiredDate() != null) {
                    userEntity.setInDate(new Date(user.getHiredDate()));
                }
                if (insert.booleanValue()) {
                    this.mallUserInterface.insertSelective(userEntity);
                } else {
                    this.mallUserInterface.updateByPrimaryKeySelective(userEntity);
                }
                try {
                    this.saveStaffDetail((OapiV2UserListResponse.ListUserResponse)user);
                }
                catch (Exception e) {
                    this.logger.error("\u4fdd\u5b58\u9489\u9489\u90e8\u95e8\u660e\u7ec6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                }
                if (insert.booleanValue()) {
                    // empty if block
                }
            });
        } while (hasMore.booleanValue());
        return BaseJsonVo.success((String)"\u540c\u6b65\u5b8c\u6210", null);
    }

    public static Client createClient() throws Exception {
        Config config = new Config();
        config.protocol = "https";
        config.regionId = "central";
        return new Client(config);
    }

    @Override
    public BaseJsonVo syncLeaveStaff(String startTime) throws Exception {
        block6: {
            BaseJsonVo accessToken = this.dingTalkService.getAccessToken();
            if (!accessToken.isSuccess()) {
                return accessToken;
            }
            String nextToken = "0";
            Client client = DingDeptStaffService.createClient();
            ListEmpLeaveRecordsHeaders listEmpLeaveRecordsHeaders = new ListEmpLeaveRecordsHeaders();
            listEmpLeaveRecordsHeaders.xAcsDingtalkAccessToken = (String)accessToken.getValue();
            startTime = StringUtils.isNotEmpty((String)startTime) ? startTime : DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-7), (String)"yyyy-MM-dd") + "T00:00:00Z";
            String endTime = DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy-MM-dd") + "T00:00:00Z";
            this.logger.info("\u5f00\u59cb\u65f6\u95f4:{},\u7ed3\u675f\u65f6\u95f4:{}", (Object)startTime, (Object)endTime);
            ListEmpLeaveRecordsRequest listEmpLeaveRecordsRequest = new ListEmpLeaveRecordsRequest().setStartTime(startTime).setEndTime(endTime).setNextToken(nextToken).setMaxResults(Integer.valueOf(50));
            try {
                ListEmpLeaveRecordsResponse listEmpLeaveRecordsResponse = client.listEmpLeaveRecordsWithOptions(listEmpLeaveRecordsRequest, listEmpLeaveRecordsHeaders, new RuntimeOptions());
                this.logger.info("\u79bb\u804c\u4eba\u5458\uff1a{}", (Object)JsonUtils.toJson((Object)listEmpLeaveRecordsResponse, (boolean)false));
                if (listEmpLeaveRecordsResponse.getStatusCode() == null || listEmpLeaveRecordsResponse.getStatusCode() != 200) {
                    this.logger.error("\u540c\u6b65\u79bb\u804c\u4eba\u5458\u5931\u8d25\uff0ccode={}", (Object)listEmpLeaveRecordsResponse.getStatusCode());
                    return BaseJsonVo.error((String)("\u540c\u6b65\u5931\u8d25\uff1a" + listEmpLeaveRecordsResponse.getStatusCode()));
                }
                ListEmpLeaveRecordsResponseBody body = listEmpLeaveRecordsResponse.getBody();
                nextToken = body.getNextToken();
                List records = body.getRecords();
                records.forEach(record -> {
                    MallUserEntity param = new MallUserEntity();
                    param.setDingdingId(record.getUserId());
                    List list = this.mallUserInterface.getList(param);
                    if (list != null && !list.isEmpty()) {
                        list.forEach(userEntity -> {
                            userEntity.setStatus(-1);
                            if (userEntity.getMobile() == null) {
                                userEntity.setMobile(record.getMobile());
                            }
                            this.mallUserInterface.updateByPrimaryKeySelective(userEntity);
                        });
                    }
                });
            }
            catch (TeaException err) {
                if (!Common.empty((String)err.code) && !Common.empty((String)err.message)) {
                    this.logger.error("\u62a5\u95191\uff1aerr.code={}\uff0cerr.message={}", new Object[]{err.code, err.message, err});
                }
            }
            catch (Exception _err) {
                TeaException err = new TeaException(_err.getMessage(), (Throwable)_err);
                if (Common.empty((String)err.code) || Common.empty((String)err.message)) break block6;
                this.logger.error("\u62a5\u95192\uff1aerr.code={}\uff0cerr.message={}", new Object[]{err.code, err.message, err});
            }
        }
        return BaseJsonVo.success((String)"\u79bb\u804c\u4eba\u5458\u540c\u6b65\u5b8c\u6210", null);
    }

    @Override
    public BaseJsonVo getTreeDingdingDepts() {
        List lists = this.dingDepartmentMapper.getList(new DingDepartmentEntity());
        ArrayList result = new ArrayList();
        List lists1 = lists.stream().filter(c -> c.getParentId() != null && c.getParentId().equals(1)).collect(Collectors.toList());
        for (DingDepartmentEntity dept : lists1) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("deptId", dept.getDingDeptId());
            map.put("deptName", dept.getDeptName());
            List<Map<String, Object>> o = this.getDeptChildren(lists, dept.getDingDeptId());
            if (o.size() > 0) {
                map.put("children", o);
            }
            result.add(map);
        }
        return BaseJsonVo.success(result);
    }

    private List<Map<String, Object>> getDeptChildren(List<DingDepartmentEntity> list, Integer deptId) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List lists1 = list.stream().filter(c -> c.getParentId() != null && c.getParentId().equals(deptId)).collect(Collectors.toList());
        for (DingDepartmentEntity dept : lists1) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("deptId", dept.getDingDeptId());
            map.put("deptName", dept.getDeptName());
            List<Map<String, Object>> o = this.getDeptChildren(list, dept.getDingDeptId());
            if (o.size() > 0) {
                map.put("children", o);
            }
            result.add(map);
        }
        return result;
    }

    @Override
    public BaseJsonVo saveDingDepartDetail(Integer deptId) throws ApiException {
        BaseJsonVo<String> accessToken = this.getAccessToken();
        if (!accessToken.isSuccess()) {
            return accessToken;
        }
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/get");
        OapiV2DepartmentGetRequest req = new OapiV2DepartmentGetRequest();
        req.setDeptId(Long.valueOf(deptId.intValue()));
        req.setLanguage("zh_CN");
        OapiV2DepartmentGetResponse rsp = (OapiV2DepartmentGetResponse)client.execute((TaobaoRequest)req, (String)accessToken.getValue());
        if (!rsp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u90e8\u95e8\u8be6\u60c5\u5931\u8d25\uff1a{}", (Object)rsp.getErrmsg());
            return BaseJsonVo.error((String)rsp.getErrmsg());
        }
        OapiV2DepartmentGetResponse.DeptGetResponse result = rsp.getResult();
        DingDepartmentEntity dept = new DingDepartmentEntity();
        dept.setDingDeptId(deptId);
        dept.setDeptName(result.getName());
        dept.setParentId(result.getParentId().intValue());
        dept.setSourceIdentifier(result.getSourceIdentifier());
        dept.setCreateDeptGroup(result.getCreateDeptGroup() != null && result.getCreateDeptGroup() != false ? 1 : 0);
        dept.setAutoAddUser(result.getAutoAddUser() != null && result.getAutoAddUser() != false ? 1 : 0);
        dept.setAutoApproveApply(result.getAutoApproveApply() != null && result.getAutoApproveApply() != false ? 1 : 0);
        dept.setFromUnionOrg(result.getFromUnionOrg() != null && result.getFromUnionOrg() != false ? 1 : 0);
        dept.setTags(result.getTags());
        dept.setDeptOrder(result.getOrder().intValue());
        dept.setDeptGroupChatId(result.getDeptGroupChatId());
        dept.setGroupContainSubDept(result.getGroupContainSubDept() != null && result.getGroupContainSubDept() != false ? 1 : 0);
        dept.setOrgDeptOwner(result.getOrgDeptOwner());
        dept.setDeptManagerUseridList(JsonUtils.toJson((Object)result.getDeptManagerUseridList(), (boolean)false));
        this.logger.info("\u67e5\u627e\u90e8\u95e8\u7ba1\u7406\u5458:deptId={},name={},manager={}", new Object[]{deptId, result.getName(), dept.getDeptManagerUseridList()});
        this.dingDeptManagerMapper.deleteByDeptId(deptId);
        if (result.getDeptManagerUseridList() != null && !result.getDeptManagerUseridList().isEmpty()) {
            result.getDeptManagerUseridList().forEach(managerId -> {
                DingDeptManagerEntity deptManagerEntity = new DingDeptManagerEntity();
                deptManagerEntity.setDeptId(deptId);
                deptManagerEntity.setManagerId((String)managerId);
                this.dingDeptManagerMapper.insert(deptManagerEntity);
                this.logger.info("\u4fdd\u5b58\u90e8\u95e8\u7ba1\u7406\u5458\u8868\uff1a{}", (Object)JsonUtils.toJson((Object)deptManagerEntity, (boolean)false));
            });
        }
        dept.setOuterDept(result.getOuterDept() != null && result.getOuterDept() != false ? 1 : 0);
        dept.setOuterPermitDepts(JsonUtils.toJson((Object)result.getOuterPermitDepts(), (boolean)false));
        dept.setOuterPermitUsers(JsonUtils.toJson((Object)result.getOuterPermitUsers(), (boolean)false));
        dept.setHideDept(result.getHideDept() != null && result.getHideDept() != false ? 1 : 0);
        dept.setUserPermits(JsonUtils.toJson((Object)result.getUserPermits(), (boolean)false));
        dept.setDeptPermits(JsonUtils.toJson((Object)result.getDeptPermits(), (boolean)false));
        this.dingDepartmentMapper.insertOrUpdate(dept);
        return BaseJsonVo.success((Object)dept);
    }

    @Override
    public BaseJsonVo saveStaffDetail(OapiV2UserListResponse.ListUserResponse user) {
        if (user == null) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        DingStaffEntity staffEntity = new DingStaffEntity();
        staffEntity.setUserId(user.getUserid());
        staffEntity.setUnionId(user.getUnionid());
        staffEntity.setName(user.getName());
        staffEntity.setAvatar(user.getAvatar());
        staffEntity.setStateCode(user.getStateCode());
        staffEntity.setMobile(user.getMobile());
        staffEntity.setHideMobile(user.getHideMobile() != null && user.getHideMobile() != false ? 1 : 0);
        staffEntity.setTelephone(user.getTelephone());
        staffEntity.setJobNumber(user.getJobNumber());
        staffEntity.setTitle(user.getTitle());
        staffEntity.setEmail(user.getEmail());
        staffEntity.setOrgEmail(user.getOrgEmail());
        staffEntity.setWorkPlace(user.getWorkPlace());
        staffEntity.setRemark(user.getRemark());
        staffEntity.setDeptIdList(JsonUtils.toJson((Object)user.getDeptIdList(), (boolean)false));
        staffEntity.setDeptOrder(user.getDeptOrder().intValue());
        staffEntity.setExtension(user.getExtension());
        staffEntity.setHiredDate(new Date(user.getHiredDate()));
        staffEntity.setActive(user.getActive() != null && user.getActive() != false ? 1 : 0);
        staffEntity.setAdmin(user.getAdmin() != null && user.getAdmin() != false ? 1 : 0);
        staffEntity.setBoss(user.getBoss() != null && user.getBoss() != false ? 1 : 0);
        staffEntity.setLeader(user.getLeader() != null && user.getLeader() != false ? 1 : 0);
        staffEntity.setExclusiveAccount(user.getExclusiveAccount() != null && user.getExclusiveAccount() != false ? 1 : 0);
        this.dingStaffMapper.insertOrUpdate(staffEntity);
        return BaseJsonVo.success((Object)staffEntity);
    }

    @Override
    public BaseJsonVo syncStaffRegularDate() throws ApiException {
        BaseJsonVo<String> accessToken = this.getAccessToken();
        if (!accessToken.isSuccess()) {
            return accessToken;
        }
        int currentSize = 0;
        int limitStart = 0;
        do {
            List<String> dingdingIds = this.mallUserInterface.getUnRegularUser(limitStart);
            currentSize = dingdingIds.size();
            BaseJsonVo b = this.syncStaffRegularDateBatch(accessToken, dingdingIds);
            if (!b.isSuccess()) {
                return b;
            }
            limitStart += 100;
        } while (currentSize == 100);
        return BaseJsonVo.success((Object)"\u540c\u6b65\u5b8c\u6210");
    }

    private BaseJsonVo syncStaffRegularDateBatch(BaseJsonVo<String> accessToken, List<String> dingdingIds) throws ApiException {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/smartwork/hrm/employee/v2/list");
        OapiSmartworkHrmEmployeeV2ListRequest req = new OapiSmartworkHrmEmployeeV2ListRequest();
        req.setUseridList(String.join((CharSequence)",", dingdingIds));
        req.setFieldFilterList("sys01-regularTime,sys00-reportManager");
        req.setAgentid(Long.valueOf(823943560L));
        OapiSmartworkHrmEmployeeV2ListResponse rsp = (OapiSmartworkHrmEmployeeV2ListResponse)client.execute((TaobaoRequest)req, (String)accessToken.getValue());
        this.logger.info(rsp.getBody());
        if (rsp.getErrcode() != 0L) {
            return BaseJsonVo.error((String)rsp.getErrmsg());
        }
        List result = rsp.getResult();
        result.forEach(item -> {
            if (StringUtils.isNotEmpty((String)item.getUserid())) {
                MallUserEntity param = new MallUserEntity();
                param.setDingdingId(item.getUserid());
                List list = this.mallUserInterface.getList(param);
                if (list != null && !list.isEmpty()) {
                    String[] rDate = new String[]{null};
                    String[] leader = new String[]{null};
                    if (item.getFieldDataList() != null && !item.getFieldDataList().isEmpty()) {
                        item.getFieldDataList().forEach(field -> {
                            if (field.getFieldValueList() != null && !field.getFieldValueList().isEmpty() && ((OapiSmartworkHrmEmployeeV2ListResponse.FieldValueVo)field.getFieldValueList().get(0)).getValue() != null) {
                                if ("sys01-regularTime".equals(field.getFieldCode())) {
                                    rDate[0] = ((OapiSmartworkHrmEmployeeV2ListResponse.FieldValueVo)field.getFieldValueList().get(0)).getValue();
                                } else if ("sys00-reportManager".equals(field.getFieldCode())) {
                                    leader[0] = ((OapiSmartworkHrmEmployeeV2ListResponse.FieldValueVo)field.getFieldValueList().get(0)).getValue();
                                }
                            }
                        });
                    }
                    list.forEach(user -> {
                        Boolean edit = false;
                        if (rDate[0] != null) {
                            user.setrDate(DateUtils.getDateFromString((String)rDate[0]));
                            edit = true;
                        }
                        if (leader[0] != null) {
                            MallUserEntity param2 = new MallUserEntity();
                            param2.setUserNick(leader[0]);
                            param2.setStatus(1);
                            List list1 = this.mallUserInterface.getList(param2);
                            if (list1 == null || list1.isEmpty()) {
                                this.logger.error("{}\u7684\u4e0a\u7ea7{}\uff0c\u67e5\u4e0d\u5230", (Object)user.getUserNick(), (Object)leader[0]);
                            }
                            user.setDingdingLeaderId(((MallUserEntity)list1.get(0)).getDingdingLeaderId());
                            edit = true;
                        }
                        if (edit.booleanValue()) {
                            this.mallUserInterface.updateByPrimaryKeySelective(user);
                        }
                    });
                }
            }
        });
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo buildManager2() {
        HashSet hasAdded = new HashSet();
        List<MallUserEntity> userList = this.mallUserInterface.getAllActiveUsers();
        userList.forEach(user -> {
            String[] dingdingDeptIds;
            this.mallUserManagerMapper.deleteByUserId(user.getUserId());
            if (StringUtils.isEmpty((String)user.getDingdingDeptId())) {
                return;
            }
            String dingdingDeptIdsStr = user.getDingdingDeptId();
            for (String dingdingDeptIdStr : dingdingDeptIds = dingdingDeptIdsStr.split(",")) {
                Integer dingdingDeptId = Integer.valueOf(dingdingDeptIdStr);
                DingDeptManagerEntity param = new DingDeptManagerEntity();
                param.setDeptId(dingdingDeptId);
                List deptManagerList = this.dingDeptManagerMapper.getList(param);
                if (deptManagerList != null && !deptManagerList.isEmpty()) {
                    deptManagerList.forEach(deptManager -> {
                        MallUserEntity managerUserEntity = this.mallUserInterface.getUserByDingdingID(deptManager.getManagerId());
                        if (!managerUserEntity.getUserId().equals(user.getUserId())) {
                            if (!user.getUserId().equals(managerUserEntity.getUserId()) && !hasAdded.contains(user.getUserId() + managerUserEntity.getUserId())) {
                                MallUserManagerEntity userManager = new MallUserManagerEntity();
                                userManager.setUserId(user.getUserId());
                                userManager.setManagerUserId(managerUserEntity.getUserId());
                                this.mallUserManagerMapper.insert(userManager);
                                hasAdded.add(userManager.getUserId() + userManager.getManagerUserId());
                            }
                        } else {
                            List<String> deapManagerUserId = this.findDeapManagerUserId(((DingDepartmentEntity)this.dingDepartmentMapper.selectByPrimaryKey(deptManager.getDeptId())).getParentId());
                            if (deapManagerUserId != null && !deapManagerUserId.isEmpty()) {
                                deapManagerUserId.forEach(deapMangerUserId -> {
                                    if (!user.getUserId().equals(deapMangerUserId) && !hasAdded.contains(user.getUserId() + deapMangerUserId)) {
                                        MallUserManagerEntity userManager = new MallUserManagerEntity();
                                        userManager.setUserId(user.getUserId());
                                        userManager.setManagerUserId((String)deapMangerUserId);
                                        this.mallUserManagerMapper.insert(userManager);
                                        hasAdded.add(userManager.getUserId() + userManager.getManagerUserId());
                                    }
                                });
                            }
                        }
                    });
                    continue;
                }
                List<String> deapManagerUserId = this.findDeapManagerUserId(((DingDepartmentEntity)this.dingDepartmentMapper.selectByPrimaryKey(dingdingDeptId)).getParentId());
                if (deapManagerUserId == null || deapManagerUserId.isEmpty()) continue;
                deapManagerUserId.forEach(deapMangerUserId -> {
                    if (!user.getUserId().equals(deapMangerUserId) && !hasAdded.contains(user.getUserId() + deapMangerUserId)) {
                        MallUserManagerEntity userManager = new MallUserManagerEntity();
                        userManager.setUserId(user.getUserId());
                        userManager.setManagerUserId((String)deapMangerUserId);
                        this.mallUserManagerMapper.insert(userManager);
                        hasAdded.add(userManager.getUserId() + userManager.getManagerUserId());
                    }
                });
            }
        });
        return BaseJsonVo.success((Object)"\u6574\u7406\u76f4\u5c5eLeader\u5b8c\u6210");
    }

    private List<String> findDeapManagerUserId(Integer deptId) {
        DingDepartmentEntity currentDept;
        ArrayList<String> managerUserId = new ArrayList<String>();
        while ((currentDept = (DingDepartmentEntity)this.dingDepartmentMapper.selectByPrimaryKey(deptId)) != null) {
            DingDeptManagerEntity param = new DingDeptManagerEntity();
            param.setDeptId(deptId);
            List deptManagerList = this.dingDeptManagerMapper.getList(param);
            if (deptManagerList != null && !deptManagerList.isEmpty()) {
                for (DingDeptManagerEntity dingDeptManagerEntity : deptManagerList) {
                    MallUserEntity managerUserEntity = this.mallUserInterface.getUserByDingdingID(dingDeptManagerEntity.getManagerId());
                    managerUserId.add(managerUserEntity.getUserId());
                }
                break;
            }
            deptId = currentDept.getParentId();
        }
        return managerUserId;
    }

    @Override
    public BaseJsonVo buildManager() {
        HashMap deptManager = new HashMap();
        HashMap deptManager2 = new HashMap();
        HashSet hasAdded = new HashSet();
        List<MallUserEntity> userList = this.mallUserInterface.getAllActiveUsers();
        this.logger.info("\u67e5\u8be2\u5230{}\u4e2a\uff0cuserList={}", (Object)userList.size(), (Object)JsonUtils.toJson(userList, (boolean)false));
        userList.forEach(user -> {
            String[] dingdingDeptIds;
            this.logger.info("\u7528\u6237[{}]\u5f00\u59cb\u627eLeader", (Object)user.getUserNick());
            if (StringUtils.isEmpty((String)user.getDingdingDeptId())) {
                return;
            }
            this.logger.info("\u7528\u6237[{}]\u5f00\u59cb\u627eLeader-2", (Object)user.getUserNick());
            block0: for (String dingdingDeptIdStr : dingdingDeptIds = user.getDingdingDeptId().split(",")) {
                this.logger.info("\u7528\u6237[{}]\u5f00\u59cb\u627eLeader,\u627e\u90e8\u95e8[{}]\u7684Leader", (Object)user.getUserNick(), (Object)dingdingDeptIdStr);
                Integer dingdingDeptId = Integer.valueOf(dingdingDeptIdStr);
                if (deptManager.containsKey(dingdingDeptId) && !user.getUserId().equals(deptManager.get(dingdingDeptId))) {
                    MallUserManagerEntity param2 = new MallUserManagerEntity();
                    param2.setUserId(user.getUserId());
                    this.mallUserManagerMapper.deleteByEntity(param2);
                    param2.setManagerUserId((String)deptManager.get(dingdingDeptId));
                    param2.setId(null);
                    if (!param2.getManagerUserId().equals(param2.getUserId()) && !hasAdded.contains(param2.getUserId() + param2.getManagerUserId())) {
                        this.mallUserManagerMapper.insert(param2);
                        hasAdded.add(param2.getUserId() + param2.getManagerUserId());
                    }
                    if (!deptManager2.containsKey(dingdingDeptId)) continue;
                    param2.setManagerUserId((String)deptManager2.get(dingdingDeptId));
                    param2.setId(null);
                    if (param2.getManagerUserId().equals(param2.getUserId()) || hasAdded.contains(param2.getUserId() + param2.getManagerUserId())) continue;
                    this.mallUserManagerMapper.insert(param2);
                    hasAdded.add(param2.getUserId() + param2.getManagerUserId());
                    continue;
                }
                Integer searchDeptId = dingdingDeptId;
                while (true) {
                    DingDeptManagerEntity param = new DingDeptManagerEntity();
                    param.setDeptId(searchDeptId);
                    List deptManagerList = this.dingDeptManagerMapper.getList(param);
                    List deptManagerListFiltered = deptManagerList.stream().filter(deptManager1 -> !deptManager1.getManagerId().equals(user.getUserId())).collect(Collectors.toList());
                    if (deptManagerListFiltered != null && !deptManagerListFiltered.isEmpty()) {
                        MallUserManagerEntity param2 = new MallUserManagerEntity();
                        param2.setUserId(user.getUserId());
                        this.mallUserManagerMapper.deleteByEntity(param2);
                        for (DingDeptManagerEntity dingDeptManagerEntity : deptManagerListFiltered) {
                            MallUserEntity mallUserEntity = this.mallUserInterface.getUserByDingdingID(dingDeptManagerEntity.getManagerId());
                            param2.setManagerUserId(mallUserEntity.getUserId());
                            param2.setId(null);
                            if (!param2.getManagerUserId().equals(param2.getUserId()) && !hasAdded.contains(param2.getUserId() + param2.getManagerUserId())) {
                                this.mallUserManagerMapper.insert(param2);
                                hasAdded.add(param2.getUserId() + param2.getManagerUserId());
                            }
                            if (deptManager.containsKey(searchDeptId) && !((String)deptManager.get(searchDeptId)).equals(mallUserEntity.getUserId())) {
                                deptManager2.put(searchDeptId, mallUserEntity.getUserId());
                                continue;
                            }
                            deptManager.put(searchDeptId, mallUserEntity.getUserId());
                        }
                        continue block0;
                    }
                    DingDepartmentEntity currentSearchDepart = (DingDepartmentEntity)this.dingDepartmentMapper.selectByPrimaryKey(searchDeptId);
                    if (currentSearchDepart == null || currentSearchDepart.getParentId() == null || currentSearchDepart.getParentId() == 1) continue block0;
                    searchDeptId = currentSearchDepart.getParentId();
                }
            }
        });
        return BaseJsonVo.success((Object)"\u6574\u7406\u76f4\u5c5eLeader\u5b8c\u6210");
    }

    @Override
    public BaseJsonVo<Map<String, String>> getManager(String userIdOrEmailOrDingDingId) {
        if (StringUtils.isEmpty((String)userIdOrEmailOrDingDingId)) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        MallUserEntity mallUserEntity = (MallUserEntity)this.mallUserInterface.selectByPrimaryKey((Serializable)((Object)userIdOrEmailOrDingDingId));
        if (mallUserEntity == null) {
            mallUserEntity = new MallUserEntity();
            mallUserEntity.setDingdingId(userIdOrEmailOrDingDingId);
            List list = this.mallUserInterface.getList(mallUserEntity);
            if (list != null && !list.isEmpty()) {
                mallUserEntity = (MallUserEntity)list.get(0);
            } else {
                mallUserEntity = new MallUserEntity();
                mallUserEntity.setUserName(userIdOrEmailOrDingDingId);
                List list2 = this.mallUserInterface.getList(mallUserEntity);
                if (list2 != null && !list2.isEmpty()) {
                    mallUserEntity = (MallUserEntity)list2.get(0);
                }
            }
        }
        if (mallUserEntity == null) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)mallUserEntity.getDingdingLeaderId())) {
            return BaseJsonVo.error((String)"\u7528\u6237\u6ca1\u6709\u4e0a\u7ea7");
        }
        MallUserEntity manager = this.mallUserInterface.getUserByDingdingID(mallUserEntity.getDingdingLeaderId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", manager.getUserId());
        map.put("userNick", manager.getUserNick());
        map.put("dingdingId", manager.getDingdingId());
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo<List<Map<String, String>>> getAllManager(String userIdOrEmailOrDingDingId) {
        BaseJsonVo<Map<String, String>> managerRst;
        ArrayList<Object> allManager = new ArrayList<Object>();
        int[] i = new int[]{1};
        while ((managerRst = this.getManager(userIdOrEmailOrDingDingId)).isSuccess() && !((Map)managerRst.getValue()).isEmpty()) {
            ((Map)managerRst.getValue()).put("level", String.valueOf(i[0]));
            allManager.add(managerRst.getValue());
            userIdOrEmailOrDingDingId = (String)((Map)managerRst.getValue()).get("userId");
            i[0] = i[0] + 1;
        }
        return BaseJsonVo.success(allManager);
    }

    @Override
    public BaseJsonVo<List<Map<String, String>>> getDirectSubs(String userIdOrEmailOrDingDingId) {
        if (StringUtils.isEmpty((String)userIdOrEmailOrDingDingId)) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        MallUserEntity mallUserEntity = (MallUserEntity)this.mallUserInterface.selectByPrimaryKey((Serializable)((Object)userIdOrEmailOrDingDingId));
        if (mallUserEntity == null) {
            mallUserEntity = new MallUserEntity();
            mallUserEntity.setDingdingId(userIdOrEmailOrDingDingId);
            List list = this.mallUserInterface.getList(mallUserEntity);
            if (list != null && !list.isEmpty()) {
                mallUserEntity = (MallUserEntity)list.get(0);
            } else {
                mallUserEntity = new MallUserEntity();
                mallUserEntity.setUserName(userIdOrEmailOrDingDingId);
                List list2 = this.mallUserInterface.getList(mallUserEntity);
                if (list2 != null && !list2.isEmpty()) {
                    mallUserEntity = (MallUserEntity)list2.get(0);
                }
            }
        }
        if (mallUserEntity == null) {
            return BaseJsonVo.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        MallUserEntity param = new MallUserEntity();
        param.setDingdingLeaderId(mallUserEntity.getDingdingId());
        List subEntities = this.mallUserInterface.getList(param);
        ArrayList subs = new ArrayList();
        subEntities.forEach(sub -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userId", sub.getUserId());
            map.put("userNick", sub.getUserNick());
            map.put("dingdingId", sub.getDingdingId());
            subs.add(map);
        });
        return BaseJsonVo.success(subs);
    }
}

