/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.authority.service;

import cc.lechun.authority.dao.MallRoleDataMapper;
import cc.lechun.authority.entity.MallRoleDataEntity;
import cc.lechun.authority.iservice.MallRoleDataInterface;
import cc.lechun.authority.iservice.SysUserInterface;
import cc.lechun.framework.core.baseclass.BaseService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallRoleDataService
extends BaseService<MallRoleDataEntity, Long>
implements MallRoleDataInterface {
    @Resource
    private MallRoleDataMapper mallRoleDataMapper;
    @Autowired
    SysUserInterface sysUserInterface;

    @Override
    public void saveRoleData(MallRoleDataEntity roleDataEntity) {
        this.mallRoleDataMapper.insertSelective(roleDataEntity);
    }

    @Override
    public void deleteRoleData(long id) {
        this.mallRoleDataMapper.deleteByPrimaryKey(Long.valueOf(id));
    }

    @Override
    public List<MallRoleDataEntity> getMallRoleDataList(Integer roleId, int dataType) {
        if (dataType == 0) {
            new ArrayList();
        }
        MallRoleDataEntity search = new MallRoleDataEntity();
        search.setDataType(dataType);
        search.setRoleId(roleId);
        return this.getList(search, 0L);
    }

    @Override
    public Map<Integer, List<String>> getRoleDataRight(String userId, String pageRouterUrl, Integer dataType) {
        if (pageRouterUrl.startsWith("/")) {
            pageRouterUrl = pageRouterUrl.substring(1);
        }
        if (pageRouterUrl.endsWith("/")) {
            pageRouterUrl = pageRouterUrl.substring(0, pageRouterUrl.length() - 1);
        }
        return this.sysUserInterface.getRoleDataRight(userId, pageRouterUrl, dataType);
    }

    @Override
    public void deleteRoleDatas(Integer roleId, Integer dataType) {
        if (roleId == null) {
            return;
        }
        this.mallRoleDataMapper.deleteRoleDatas(roleId, dataType);
    }
}

