/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.authority.service;

import cc.lechun.authority.apiInvoke.mall.AccessToken2Invoke;
import cc.lechun.authority.dao.MallRoleResourceMapper;
import cc.lechun.authority.dao.MallUserMapper;
import cc.lechun.authority.dao.MallUserRoleMapper;
import cc.lechun.authority.entity.MallRoleResourceEntity;
import cc.lechun.authority.entity.MallUserEntity;
import cc.lechun.authority.entity.MallUserEntityVo;
import cc.lechun.authority.entity.MallUserMenuRsVo;
import cc.lechun.authority.entity.MallUserMenuVo;
import cc.lechun.authority.entity.MallUserRoleEntity;
import cc.lechun.authority.iservice.SysUserInterface;
import cc.lechun.authority.service.RoleDataType;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.sms.aicall.util.HttpClientUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class SysUserService
implements SysUserInterface {
    private static final Logger logger = LoggerFactory.getLogger(SysUserService.class);
    @Autowired
    MallUserMapper mallUserMapper;
    @Autowired
    MallUserRoleMapper mallUserRoleMapper;
    @Autowired
    MallRoleResourceMapper mallRoleResourceMapper;
    @Autowired
    RedisCacheUtil redisCacheUtil;
    @Autowired
    SysUserInterface sysUserInterface;
    @Autowired
    private AccessToken2Invoke accessTokenInvoke;

    @Override
    @InvalidateSingleCache(namespace="getFinancialSubordinate")
    public BaseJsonVo saveMallUser(MallUserEntity mallUserEntity) {
        BaseJsonVo rs = this.validUser(mallUserEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        mallUserEntity.setUserId(IDGenerate.getUniqueID() + "");
        mallUserEntity.setCreateTime(DateUtils.now());
        mallUserEntity.setUserType(1);
        mallUserEntity.setPassword(MD5.sign((String)"lechun", (String)mallUserEntity.getPassword()));
        this.mallUserMapper.insertSelective(mallUserEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public MallUserEntity loginQw(String code, String state, String scope) {
        logger.info("code={}\uff0cstate={}\uff0cscope={}", new Object[]{code, state, scope});
        BaseJsonVo<String> jsonVo = this.accessTokenInvoke.getAccessTokenValueByPlatformId(7);
        if (jsonVo.isSuccess()) {
            String accessToken = (String)jsonVo.getValue();
            String urlStr = String.format("https://qyapi.weixin.qq.com/cgi-bin/auth/getuserinfo?access_token=%s&code=%s", accessToken, code);
            logger.info("urlStr={} ", (Object)urlStr);
            String result = HttpClientUtils.doGetWithUrl((String)urlStr);
            logger.info("urlStr={}\uff0cresult={}", (Object)urlStr, (Object)result);
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (Objects.equals(jsonObject.getInteger("errcode"), 0)) {
                if (jsonObject.containsKey((Object)"userid")) {
                    MallUserEntity query = new MallUserEntity();
                    query.setQyWeixinUserid(jsonObject.getString("userid"));
                    MallUserEntity userEntity = (MallUserEntity)this.mallUserMapper.getSingle(query);
                    if (userEntity == null) {
                        logger.error("\u7528\u6237:{}\u672a\u8bbe\u7f6e\u4f01\u5fae\u5e10\u53f7", (Object)jsonObject.getString("userid"));
                        throw new RuntimeException("\u7528\u6237\u672a\u8bbe\u7f6e\u4f01\u5fae\u5e10\u53f7");
                    }
                    if (userEntity.getStatus() != 1) {
                        logger.error("\u7528\u6237:{}\u5df2\u88ab\u7981\u7528", (Object)userEntity.getUserName());
                        throw new RuntimeException("\u7528\u6237\u5df2\u88ab\u7981\u7528");
                    }
                    return userEntity;
                }
                logger.error("\u7528\u6237\u672a\u52a0\u5165\u4f01\u5fae");
                throw new RuntimeException("\u7528\u6237\u672a\u52a0\u5165\u4f01\u5fae");
            }
            logger.error("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u51fa\u9519:{}", (Object)jsonObject.getString("errmsg"));
            throw new RuntimeException(jsonObject.getString("errmsg"));
        }
        logger.error("\u67e5\u8be2accessToken\u51fa\u9519:{}", (Object)jsonVo.getMessage());
        throw new RuntimeException(jsonVo.getMessage());
    }

    @Override
    @InvalidateSingleCache(namespace="getFinancialSubordinate")
    public BaseJsonVo updateMallUser(MallUserEntity mallUserEntity) {
        BaseJsonVo rs = this.validUser(mallUserEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        if (!StringUtils.isEmpty((String)mallUserEntity.getPassword())) {
            mallUserEntity.setPassword(MD5.sign((String)"lechun", (String)mallUserEntity.getPassword()));
        }
        this.mallUserMapper.updateByPrimaryKeySelective(mallUserEntity);
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo validUser(MallUserEntity mallUserEntity) {
        if (StringUtils.isEmpty((String)mallUserEntity.getUserName())) {
            return BaseJsonVo.paramError((String)"\u767b\u5f55\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mallUserEntity.getUserNick())) {
            return BaseJsonVo.paramError((String)"\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mallUserEntity.getUserId()) && StringUtils.isEmpty((String)mallUserEntity.getPassword())) {
            return BaseJsonVo.paramError((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mallUserEntity.getPlatformGroupId() == null) {
            return BaseJsonVo.paramError((String)"\u6240\u5c5e\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @ReadThroughSingleCache(namespace="SysUserService.getMallUserList", expiration=7200)
    public PageInfo getMallUserList(@ParameterValueKeyProvider(order=0) Integer pageNum, @ParameterValueKeyProvider(order=1) Integer pageSize, @ParameterValueKeyProvider(order=2) String userName, @ParameterValueKeyProvider(order=3) String userNick, @ParameterValueKeyProvider(order=4) Integer platformGroupId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallUserList(userName, userNick, platformGroupId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    @ReadThroughSingleCache(namespace="getMallUserNickName", expiration=7200)
    public String getMallUserNickName(@ParameterValueKeyProvider String user_id) {
        MallUserEntity mallUserEntity = this.getMallUser(user_id);
        return mallUserEntity == null ? "" : mallUserEntity.getUserNick();
    }

    @Override
    public MallUserEntity getMallUser(@ParameterValueKeyProvider String user_id) {
        return (MallUserEntity)this.mallUserMapper.selectByPrimaryKey((Serializable)((Object)user_id));
    }

    @Override
    public MallUserEntity getSysUser4name(String user_name) {
        return this.mallUserMapper.getSysUser4name(user_name);
    }

    @Override
    public List<MallUserMenuRsVo> getSysUserMenu(String user_id, String serviceId, String btnShow) {
        List<MallUserMenuVo> ls = this.mallUserMapper.getUserMenuList(user_id, serviceId, btnShow);
        ArrayList<MallUserMenuRsVo> rs = new ArrayList<MallUserMenuRsVo>();
        ls.stream().collect(Collectors.groupingBy(o -> o.getParentResourceId())).entrySet().forEach(longListEntry -> {
            Optional<MallUserMenuVo> any = ls.stream().filter(m -> m.getResourceId().equals(longListEntry.getKey())).findAny();
            if (any.isPresent()) {
                any.get().setMenu_list((List)longListEntry.getValue());
                any.get().getMenu_list().sort((o1, o2) -> o1.getParentResourceOrder() - o2.getParentResourceOrder());
                return;
            }
            MallUserMenuRsVo rsvo = new MallUserMenuRsVo();
            rsvo.setMenu_list((List)longListEntry.getValue());
            rsvo.setParentResourceId((Long)longListEntry.getKey());
            rsvo.setParentResourceName(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceName());
            rsvo.setParentResourceIcon(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceIcon());
            rsvo.setParentResourceOrder(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceOrder());
            rsvo.setResourceHtmlUrl(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceHtmlUrl());
            rsvo.getMenu_list().sort((o1, o2) -> o1.getParentResourceOrder() - o2.getParentResourceOrder());
            rs.add(rsvo);
        });
        rs.sort((o1, o2) -> o1.getParentResourceOrder() - o2.getParentResourceOrder());
        return rs;
    }

    @Override
    public List<Integer> getSysUserRoleList(String user_id) {
        return this.mallUserMapper.getSysUserRoleList(user_id);
    }

    @Override
    public List<String> getSysUserResourceList(String user_id) {
        return this.mallUserMapper.getSysUserResourceList(user_id);
    }

    @Override
    public PageInfo getMallUserRoleList(int pageNum, int pageSize, String userId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallUserRoleList(userId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public void saveUserRole(MallUserRoleEntity mallUserRoleEntity) {
        this.mallUserRoleMapper.insertSelective(mallUserRoleEntity);
    }

    @Override
    public void deleteUserRole(int id) {
        this.mallUserRoleMapper.deleteByPrimaryKey(Integer.valueOf(id));
    }

    @Override
    public PageInfo getMallRoleResourceList(int pageNum, int pageSize, String roleId, int resourceType) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallRoleResourceList(roleId, resourceType);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public void saveRoleResource(MallRoleResourceEntity mallRoleResourceEntity) {
        this.mallRoleResourceMapper.insertSelective(mallRoleResourceEntity);
    }

    @Override
    public void deleteRoleResource(long id) {
        this.mallRoleResourceMapper.deleteByPrimaryKey(Long.valueOf(id));
    }

    @Override
    public BaseJsonVo syncSysUsers() {
        this.mallUserMapper.syncSysUsers();
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo getBaseUserList(int type, String userId) {
        List<Map<String, String>> users = this.mallUserMapper.getBaseUserList(type);
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String resourcePath = request.getParameter("pageRouterUrl");
        return BaseJsonVo.success(users);
    }

    @Override
    public Integer getRoleUserCount(Integer roleId) {
        Integer count = this.mallUserRoleMapper.getUserCount(roleId);
        return count == null ? 0 : count;
    }

    @Override
    public Set<String> getSubordinate(String userId) {
        Set<String> subordinate = this.mallUserMapper.findAllSubordinate(userId);
        HashSet<String> rtn = new HashSet<String>();
        rtn.addAll(subordinate);
        if (subordinate != null) {
            for (String s : subordinate) {
                rtn.addAll(this.getSubordinate(s));
            }
        }
        return rtn;
    }

    @Override
    @ReadThroughSingleCache(namespace="getFinancialSubordinate", expiration=300)
    public Set<String> getFinancialSubordinate(@ParameterValueKeyProvider(order=0) String userId) {
        Set<String> allFinancialSubordinate = this.mallUserMapper.findAllFinancialSubordinate(userId);
        return allFinancialSubordinate;
    }

    @Override
    public Boolean isLeadershipRelation(String leaderId, String subordinateId) {
        if (this.getSubordinate(leaderId).contains(subordinateId)) {
            return true;
        }
        return false;
    }

    public Set<String> getLeaderInfo(String userId) {
        Set<String> leadeInfo = this.mallUserMapper.findLeaderByUserId(userId);
        HashSet<String> rtn = new HashSet<String>();
        rtn.addAll(leadeInfo);
        if (leadeInfo != null && leadeInfo.size() > 0 && !leadeInfo.contains(userId)) {
            for (String s : leadeInfo) {
                rtn.addAll(this.getLeaderInfo(s));
            }
        }
        return rtn;
    }

    @Override
    @ReadThroughSingleCache(namespace="isLeadershipRelationNew", expiration=300)
    public Boolean isLeadershipRelationNew(@ParameterValueKeyProvider(order=0) String leaderId, @ParameterValueKeyProvider(order=1) String subordinateId) {
        if (this.getLeaderInfo(subordinateId).contains(leaderId)) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean isLeadership(String leaderId, String subordinateId) {
        String key = "isLeadership_" + leaderId + "_" + subordinateId;
        Object o = this.redisCacheUtil.get(key);
        if (o != null) {
            return (Boolean)o;
        }
        MallUserEntity param = new MallUserEntity();
        param.setLeader(leaderId);
        param.setUserId(subordinateId);
        List list = this.mallUserMapper.getList(param);
        if (list == null || list.size() == 0) {
            this.redisCacheUtil.set(key, (Object)false, Long.valueOf(300L));
            return false;
        }
        this.redisCacheUtil.set(key, (Object)true, Long.valueOf(300L));
        return true;
    }

    @Override
    @ReadThroughSingleCache(namespace="getSysUserList4RoleId", expiration=300)
    public List<MallUserEntity> getSysUserList4RoleId(@ParameterValueKeyProvider(order=0) Integer roleId) {
        return this.mallUserMapper.getSysUserList4RoleId(roleId);
    }

    @Override
    public List<MallUserEntityVo> getMallUserInfoByParam(String userName, String userNick, String dingdingId, Integer platformGroupId) {
        return this.mallUserMapper.getMallUserInfoByParam(userName, userNick, dingdingId, platformGroupId);
    }

    @Override
    public int updateUserDingDingIdById(String userId, String dingdingId) {
        return this.mallUserMapper.updateUserDingDingIdById(userId, dingdingId);
    }

    @Override
    public List<MallUserEntity> getSysUserListByStatus() {
        return this.mallUserMapper.getSysUserListByStatus();
    }

    @Override
    public List<Map<String, Object>> getDeparts() {
        return this.mallUserMapper.getDeparts();
    }

    @Override
    public List<MallUserEntity> getEqualDeptUser(String userId) {
        MallUserEntity user = this.getMallUser(userId);
        if (user != null && user.getDeptId() != null) {
            MallUserEntity param = new MallUserEntity();
            param.setDeptId(user.getDeptId());
            return this.mallUserMapper.getList(param);
        }
        return new ArrayList<MallUserEntity>();
    }

    @Override
    public MallUserEntity getMallUserByMobile(String mobile) {
        if (StringUtils.isEmpty((String)mobile)) {
            return null;
        }
        MallUserEntity param = new MallUserEntity();
        param.setMobile(mobile);
        List list = this.mallUserMapper.getList(param);
        if (list != null && list.size() > 0) {
            return (MallUserEntity)list.get(0);
        }
        return null;
    }

    @Override
    public BaseJsonVo updateSysUserPwd(String userId, String pwd) {
        this.mallUserMapper.updateSysUserPwd(userId, pwd);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateUserLoginTime(String userId) {
        MallUserEntity user = new MallUserEntity();
        user.setUserId(userId);
        user.setLastLoginTimee(new Date());
        int i = this.mallUserMapper.updateByPrimaryKeySelective(user);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateUserAccessTime(String userId) {
        MallUserEntity user = new MallUserEntity();
        user.setUserId(userId);
        user.setLastAccessTime(new Date());
        int i = this.mallUserMapper.updateByPrimaryKeySelective(user);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public Map<Integer, List<String>> getRoleDataRight(String userId, @Nullable String pageRouterUrl, @Nullable Integer dataType) {
        HttpServletRequest request;
        if (StringUtils.isEmpty((String)userId)) {
            return new HashMap<Integer, List<String>>();
        }
        if (StringUtils.isEmpty((String)pageRouterUrl) && (request = RequestDetail.getCurrentRequest()) != null) {
            pageRouterUrl = request.getParameter("pageRouterUrl");
        }
        if (StringUtils.isEmpty((String)pageRouterUrl) && dataType == null) {
            return new HashMap<Integer, List<String>>();
        }
        LinkedHashMap<Integer, List<String>> map = new LinkedHashMap<Integer, List<String>>();
        if (dataType == null) {
            for (Map<String, Object> s : RoleDataType.getList()) {
                int type = (Integer)s.get("value");
                List<String> tmp = this.mallUserRoleMapper.getRoleDataRight(userId, pageRouterUrl, type);
                if (tmp.size() <= 0) continue;
                map.put(type, tmp);
            }
        } else {
            List<String> tmp = this.mallUserRoleMapper.getRoleDataRight(userId, pageRouterUrl, dataType);
            if (tmp.size() > 0) {
                map.put(dataType, tmp);
            }
        }
        return map;
    }
}

