/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.authority.Repository.shiro;

import cc.lechun.authority.Repository.shiro.EasyTypeToken;
import cc.lechun.authority.entity.MallUserEntity;
import cc.lechun.authority.iservice.SysUserInterface;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.springframework.beans.factory.annotation.Autowired;

public class MyShiroRealm
extends AuthorizingRealm {
    @Autowired
    SysUserInterface sysUserInterface;
    @Autowired
    RedisCacheUtil redisCacheUtil;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        Map map = (Map)super.getAvailablePrincipal(principalCollection);
        MallUserEntity user = (MallUserEntity)ObjectConvert.mapConvertToObject((Map)map, MallUserEntity.class);
        if (user != null) {
            SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
            List<Integer> userRoleList = this.sysUserInterface.getSysUserRoleList(user.getUserId());
            info.setRoles(userRoleList.stream().map(value -> value + "").distinct().collect(Collectors.toSet()));
            List<String> userResouceList = this.sysUserInterface.getSysUserResourceList(user.getUserId());
            return info;
        }
        return null;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        if (authenticationToken instanceof UsernamePasswordToken) {
            UsernamePasswordToken token = (UsernamePasswordToken)authenticationToken;
            token.setRememberMe(true);
            MallUserEntity user = this.sysUserInterface.getSysUser4name(token.getUsername());
            if (user != null && user.getStatus() == 1) {
                Map map = ObjectConvert.objectConvertToMap((Object)user);
                return new SimpleAuthenticationInfo((Object)map, (Object)user.getPassword(), ByteSource.Util.bytes((String)"lechun"), this.getName());
            }
            throw new UnknownAccountException("\u65e0\u6548\u7528\u6237");
        }
        if (authenticationToken instanceof EasyTypeToken) {
            EasyTypeToken token = (EasyTypeToken)authenticationToken;
            token.setRememberMe(true);
            System.out.printf("\u514d\u5bc6\u767b\u5f55:{}", token.getUsername());
            MallUserEntity user = this.sysUserInterface.getSysUser4name(token.getUsername());
            if (user != null && user.getStatus() == 1) {
                Map map = ObjectConvert.objectConvertToMap((Object)user);
                return new SimpleAuthenticationInfo((Object)map, (Object)user.getPassword(), ByteSource.Util.bytes((String)"lechun"), this.getName());
            }
            throw new UnknownAccountException("\u65e0\u6548\u7528\u6237");
        }
        throw new UnknownAccountException("\u672a\u77e5\u7684\u767b\u5f55\u65b9\u5f0f");
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof UsernamePasswordToken || token instanceof EasyTypeToken;
    }
}

