/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.authority.config;

import cc.lechun.authority.Repository.shiro.EasyCredentialsMatch;
import cc.lechun.authority.Repository.shiro.MyFormAuthenticationFilter;
import cc.lechun.authority.Repository.shiro.MyRolesAuthorizationFilter;
import cc.lechun.authority.Repository.shiro.MySessionManager;
import cc.lechun.authority.Repository.shiro.MyShiroRealm;
import cc.lechun.authority.Repository.shiro.RedisSessionDao;
import cc.lechun.authority.Repository.sys.ResourceRepository;
import cc.lechun.authority.sys.MallRoleResouceVo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroConfiguration {
    @Autowired
    private ResourceRepository resourceRepository;

    @Bean(name={"shiroFilter"})
    public ShiroFilterFactoryBean getShiroFilterFactoryBean() {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setLoginUrl("/auth/login");
        LinkedHashMap<String, Object> filters = new LinkedHashMap<String, Object>();
        filters.put("roles", (Object)new MyRolesAuthorizationFilter());
        filters.put("authc", (Object)new MyFormAuthenticationFilter());
        shiroFilterFactoryBean.setFilters(filters);
        shiroFilterFactoryBean.setSecurityManager((SecurityManager)this.getDefaultWebSecurityManager());
        shiroFilterFactoryBean.setFilterChainDefinitionMap(this.getFilterChainDefinitionMap());
        return shiroFilterFactoryBean;
    }

    public Map<String, String> getFilterChainDefinitionMap() {
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        filterChainDefinitionMap.put("/auth/login", "anon");
        filterChainDefinitionMap.put("/auth/logout", "anon");
        List<MallRoleResouceVo> ls = this.resourceRepository.getRoleResource();
        ls.forEach(mallRoleResouceVo -> {});
        filterChainDefinitionMap.put("/**", "anon");
        return filterChainDefinitionMap;
    }

    @Bean(name={"sessionManager"})
    public DefaultWebSessionManager getDefaultWebSessionManager() {
        MySessionManager defaultWebSessionManager = new MySessionManager();
        defaultWebSessionManager.setSessionDAO((SessionDAO)this.getRedisSessionDao());
        return defaultWebSessionManager;
    }

    @Bean(name={"securityManager"})
    public DefaultWebSecurityManager getDefaultWebSecurityManager() {
        DefaultWebSecurityManager dwsm = new DefaultWebSecurityManager();
        dwsm.setRealm((Realm)this.myShiroRealm());
        dwsm.setRememberMeManager((RememberMeManager)this.rememberMeManager());
        dwsm.setSessionManager((SessionManager)this.getDefaultWebSessionManager());
        return dwsm;
    }

    @Bean(name={"myShiroRealm"})
    public MyShiroRealm myShiroRealm() {
        MyShiroRealm realm = new MyShiroRealm();
        realm.setCredentialsMatcher((CredentialsMatcher)this.customCredentialsMatch());
        return realm;
    }

    @Bean
    public CookieRememberMeManager rememberMeManager() {
        CookieRememberMeManager cookieRememberMeManager = new CookieRememberMeManager();
        cookieRememberMeManager.setCookie((Cookie)this.rememberMeCookie());
        cookieRememberMeManager.setCipherKey(Base64.decode((String)"4AvVhJkmnY0FSA3SDFAdag=="));
        return cookieRememberMeManager;
    }

    @Bean
    public SimpleCookie rememberMeCookie() {
        SimpleCookie simpleCookie = new SimpleCookie("rememberMe");
        simpleCookie.setMaxAge(259200);
        simpleCookie.setName("LECHUNAUTH");
        simpleCookie.setDomain(".lechun.cc");
        return simpleCookie;
    }

    @Bean
    public EasyCredentialsMatch customCredentialsMatch() {
        EasyCredentialsMatch customCredentialsMatch = new EasyCredentialsMatch();
        customCredentialsMatch.setHashAlgorithmName("md5");
        customCredentialsMatch.setHashIterations(1);
        customCredentialsMatch.setStoredCredentialsHexEncoded(true);
        return customCredentialsMatch;
    }

    @Bean
    public RedisSessionDao getRedisSessionDao() {
        return new RedisSessionDao();
    }
}

