/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.authority.service;

import cc.lechun.authority.dao.MallLoginLogMapper;
import cc.lechun.authority.entity.MallLoginLogEntity;
import cc.lechun.authority.iservice.MallLoginLogInterface;
import cc.lechun.framework.common.utils.web.IpUtil;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallLoginLogService
implements MallLoginLogInterface {
    private static final Logger log = LoggerFactory.getLogger(MallLoginLogService.class);
    @Autowired
    private MallLoginLogMapper mallLoginLogMapper;

    @Override
    public void loginLog(HttpServletRequest request, String userName, boolean success, String reason) {
        try {
            MallLoginLogEntity logEntity = new MallLoginLogEntity();
            logEntity.setLoginName(userName);
            logEntity.setHeader(request.getHeader("User-Agent"));
            logEntity.setLoginTime(new Date());
            logEntity.setIp(IpUtil.getCliectIp((HttpServletRequest)request));
            logEntity.setSuccess(success ? "success" : "fail");
            logEntity.setReason(reason.length() >= 500 ? reason.substring(0, 500) : reason);
            this.mallLoginLogMapper.insert(logEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

