/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.authority.service;

import cc.lechun.authority.dao.MallRoleResourceMapper;
import cc.lechun.authority.dao.MallUserMapper;
import cc.lechun.authority.dao.MallUserRoleMapper;
import cc.lechun.authority.entity.MallRoleResourceEntity;
import cc.lechun.authority.entity.MallUserEntityVo;
import cc.lechun.authority.entity.MallUserMenuRsVo;
import cc.lechun.authority.entity.MallUserMenuVo;
import cc.lechun.authority.entity.MallUserRoleEntity;
import cc.lechun.authority.iservice.MallUserInterface;
import cc.lechun.authority.iservice.SysUserInterface;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.login.MallUserEntity;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.string.ChangeToPinYinJP;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class MallUserService
extends BaseService<cc.lechun.authority.entity.MallUserEntity, String>
implements MallUserInterface {
    @Resource
    private MallUserMapper mallUserMapper;
    @Autowired
    MallUserRoleMapper mallUserRoleMapper;
    @Autowired
    MallRoleResourceMapper mallRoleResourceMapper;
    @Autowired
    RedisCacheUtil redisCacheUtil;
    @Autowired
    SysUserInterface sysUserInterface;
    @Autowired
    ChangeToPinYinJP pinYinHelper;

    @Override
    public BaseJsonVo<Pair<String, String>> getDistributorUser(String employeeId) {
        this.logger.info("\u804c\u5458:{}", (Object)employeeId);
        cc.lechun.authority.entity.MallUserEntity query = new cc.lechun.authority.entity.MallUserEntity();
        query.setEmployeeId(employeeId);
        cc.lechun.authority.entity.MallUserEntity mallUserEntity = (cc.lechun.authority.entity.MallUserEntity)this.mallUserMapper.getSingle(query);
        if (mallUserEntity != null) {
            this.logger.info("employeeId={},userId={},nickName={}", new Object[]{employeeId, mallUserEntity.getUserId(), mallUserEntity.getUserNick()});
            return BaseJsonVo.success((Object)Pair.of((Object)mallUserEntity.getUserId(), (Object)mallUserEntity.getUserNick()));
        }
        return BaseJsonVo.error((String)"\u804c\u5458\u4e0d\u5b58\u5728");
    }

    @Override
    public BaseJsonVo getAllUserOptionList(Integer financialDeptId) {
        PageInfo pageInfo = ((MallUserService)SpringContextUtil.getBean(this.getClass())).getMallUserList(1, 10000, null, null, 1000);
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List result = pageInfo.getList().stream().filter(u -> {
                if (financialDeptId == null || financialDeptId == 0) {
                    return true;
                }
                return Objects.equals(u.getFinancialDeptId(), financialDeptId);
            }).map(u -> Pair.of((Object)u.getUserId(), (Object)u.getUserNick())).collect(Collectors.toList());
            return BaseJsonVo.success(result);
        }
        return BaseJsonVo.error((String)"\u65e0\u7528\u6237");
    }

    @Override
    @InvalidateSingleCache(namespace="getFinancialSubordinate")
    public BaseJsonVo saveMallUser(cc.lechun.authority.entity.MallUserEntity mallUserEntity) {
        BaseJsonVo rs = this.validUser(mallUserEntity);
        if (!rs.isSuccess()) {
            return rs;
        }
        mallUserEntity.setUserId(IDGenerate.getUniqueID() + "");
        mallUserEntity.setCreateTime(DateUtils.now());
        mallUserEntity.setUserType(1);
        mallUserEntity.setPassword(MD5.sign((String)"lechun", (String)mallUserEntity.getPassword()));
        this.mallUserMapper.insertSelective(mallUserEntity);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @InvalidateSingleCache(namespace="getFinancialSubordinate")
    public BaseJsonVo updateMallUser(cc.lechun.authority.entity.MallUserEntity mallUserEntity) {
        if (!StringUtils.isEmpty((String)mallUserEntity.getPassword())) {
            mallUserEntity.setPassword(MD5.sign((String)"lechun", (String)mallUserEntity.getPassword()));
        } else {
            BaseJsonVo rs = this.validUser(mallUserEntity);
            if (!rs.isSuccess()) {
                return rs;
            }
        }
        this.mallUserMapper.updateByPrimaryKeySelective(mallUserEntity);
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo validUser(cc.lechun.authority.entity.MallUserEntity mallUserEntity) {
        if (StringUtils.isEmpty((String)mallUserEntity.getUserName())) {
            return BaseJsonVo.paramError((String)"\u767b\u5f55\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mallUserEntity.getUserNick())) {
            return BaseJsonVo.paramError((String)"\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        mallUserEntity.setPlatformId("4");
        mallUserEntity.setPlatformGroupId(1000);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo getMallUserList(@ParameterValueKeyProvider(order=0) Integer pageNum, @ParameterValueKeyProvider(order=1) Integer pageSize, @ParameterValueKeyProvider(order=2) String userName, @ParameterValueKeyProvider(order=3) String userNick, @ParameterValueKeyProvider(order=4) Integer platformGroupId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallUserList(userName, userNick, platformGroupId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public List<cc.lechun.authority.entity.MallUserEntity> getAllSysUserWithoutPage(String nameOrEmail) {
        return this.mallUserMapper.getAllSysUser(nameOrEmail);
    }

    @Override
    @ReadThroughSingleCache(namespace="getMallUserNickName", expiration=7200)
    public String getMallUserNickName(@ParameterValueKeyProvider String user_id) {
        cc.lechun.authority.entity.MallUserEntity mallUserEntity = this.getMallUser(user_id);
        return mallUserEntity == null ? "" : mallUserEntity.getUserNick();
    }

    @Override
    public cc.lechun.authority.entity.MallUserEntity getMallUser(@ParameterValueKeyProvider String user_id) {
        return (cc.lechun.authority.entity.MallUserEntity)this.mallUserMapper.selectByPrimaryKey((Serializable)((Object)user_id));
    }

    @Override
    @ReadThroughSingleCache(namespace="SysUserService.getUserNickName", expiration=300)
    public BaseJsonVo getUserNickName(@ParameterValueKeyProvider String userId) {
        cc.lechun.authority.entity.MallUserEntity mallUserEntity = ((MallUserService)AopContext.currentProxy()).getMallUser(userId);
        return mallUserEntity != null ? BaseJsonVo.success((Object)mallUserEntity.getUserNick()) : BaseJsonVo.error((String)"\u7528\u6237\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5userId\u662f\u5426\u6b63\u786e");
    }

    @Override
    public cc.lechun.authority.entity.MallUserEntity getSysUser4name(String user_name) {
        return this.mallUserMapper.getSysUser4name(user_name);
    }

    @Override
    public List<MallUserMenuRsVo> getSysUserMenu(String user_id) {
        List<MallUserMenuVo> ls = this.mallUserMapper.getUserMenuList(user_id, "LECHUN-AMS", null);
        ArrayList<MallUserMenuRsVo> rs = new ArrayList<MallUserMenuRsVo>();
        ls.stream().collect(Collectors.groupingBy(o -> o.getParentResourceId())).entrySet().forEach(longListEntry -> {
            MallUserMenuRsVo rsvo = new MallUserMenuRsVo();
            rsvo.setMenu_list((List)longListEntry.getValue());
            rsvo.setParentResourceId((Long)longListEntry.getKey());
            rsvo.setParentResourceName(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceName());
            rsvo.setParentResourceIcon(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceIcon());
            rsvo.setParentResourceOrder(((MallUserMenuVo)((List)longListEntry.getValue()).get(0)).getParentResourceOrder());
            rsvo.getMenu_list().sort((o1, o2) -> o1.getParentResourceOrder() - o2.getParentResourceOrder());
            rs.add(rsvo);
        });
        rs.sort((o1, o2) -> o1.getParentResourceOrder() - o2.getParentResourceOrder());
        return rs;
    }

    @Override
    public List<Integer> getSysUserRoleList(String user_id) {
        return this.mallUserMapper.getSysUserRoleList(user_id);
    }

    @Override
    public List<String> getSysUserResourceList(String user_id) {
        return this.mallUserMapper.getSysUserResourceList(user_id);
    }

    @Override
    public PageInfo getMallUserRoleList(int pageNum, int pageSize, String userId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallUserRoleList(userId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public void saveUserRole(MallUserRoleEntity mallUserRoleEntity) {
        this.mallUserRoleMapper.insertSelective(mallUserRoleEntity);
    }

    @Override
    public void deleteUserRole(int id) {
        this.mallUserRoleMapper.deleteByPrimaryKey(Integer.valueOf(id));
    }

    @Override
    public PageInfo getMallRoleResourceList(int pageNum, int pageSize, String roleId, int resourceType) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.mallUserMapper.getMallRoleResourceList(roleId, resourceType);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public void saveRoleResource(MallRoleResourceEntity mallRoleResourceEntity) {
        this.mallRoleResourceMapper.insertSelective(mallRoleResourceEntity);
    }

    @Override
    public void deleteRoleResource(long id) {
        this.mallRoleResourceMapper.deleteByPrimaryKey(Long.valueOf(id));
    }

    @Override
    public BaseJsonVo syncSysUsers() {
        this.mallUserMapper.syncSysUsers();
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo getBaseUserList(int type, String userId, String name) {
        HttpServletRequest request;
        String resourcePath;
        List<Map<String, String>> users;
        String key = "MallUserService.getBaseUserList" + type;
        Object o = this.redisCacheUtil.get(key);
        if (o != null) {
            users = (List<Map<String, String>>)o;
        } else {
            users = this.mallUserMapper.getBaseUserList(type);
            for (Map<String, String> user : users) {
                user.put("pinyin", this.pinYinHelper.changeToTonePinYin(user.get("USER_NICK")));
                user.put("pinyin", user.get("pinyin") != null ? user.get("pinyin").replace(" ", "") : "");
            }
            this.redisCacheUtil.set(key, users, Long.valueOf(1800L));
        }
        if (StringUtils.isNotEmpty((String)name)) {
            users = users.stream().filter(c -> ((String)c.get("USER_NICK")).contains(name) || ((String)c.get("USER_NAME")).contains(name) || ((String)c.get("pinyin")).contains(name)).collect(Collectors.toList());
        }
        if ("cooperate".equals(resourcePath = (request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest()).getParameter("pageRouterUrl"))) {
            List<cc.lechun.authority.entity.MallUserEntity> equalUser = this.sysUserInterface.getEqualDeptUser(userId);
            for (Map<String, String> user : users) {
                if (userId.equals(user.get("USER_ID"))) {
                    user.put("enable", (String)((Object)Integer.valueOf(0)));
                    continue;
                }
                if (equalUser.stream().filter(c -> c.getUserId().equals(user.get("USER_ID"))).count() > 0L) {
                    user.put("enable", (String)((Object)Integer.valueOf(0)));
                    continue;
                }
                user.put("enable", (String)((Object)Integer.valueOf(1)));
            }
        }
        return BaseJsonVo.success(users);
    }

    @Override
    public Integer getRoleUserCount(Integer roleId) {
        Integer count = this.mallUserRoleMapper.getUserCount(roleId);
        return count == null ? 0 : count;
    }

    @Override
    public Set<String> getSubordinate(String userId) {
        Set<String> subordinate = this.mallUserMapper.findAllSubordinate(userId);
        HashSet<String> rtn = new HashSet<String>();
        rtn.addAll(subordinate);
        if (subordinate != null) {
            for (String s : subordinate) {
                rtn.addAll(this.getSubordinate(s));
            }
        }
        return rtn;
    }

    @Override
    @ReadThroughSingleCache(namespace="getFinancialSubordinate", expiration=300)
    public Set<String> getFinancialSubordinate(@ParameterValueKeyProvider(order=0) String userId) {
        Set<String> allFinancialSubordinate = this.mallUserMapper.findAllFinancialSubordinate(userId);
        return allFinancialSubordinate;
    }

    @Override
    public Boolean isLeadershipRelation(String leaderId, String subordinateId) {
        if (this.getSubordinate(leaderId).contains(subordinateId)) {
            return true;
        }
        return false;
    }

    public Set<String> getLeaderInfo(String userId) {
        Set<String> leadeInfo = this.mallUserMapper.findLeaderByUserId(userId);
        HashSet<String> rtn = new HashSet<String>();
        rtn.addAll(leadeInfo);
        if (leadeInfo != null && leadeInfo.size() > 0 && !leadeInfo.contains(userId)) {
            for (String s : leadeInfo) {
                rtn.addAll(this.getLeaderInfo(s));
            }
        }
        return rtn;
    }

    @Override
    @ReadThroughSingleCache(namespace="isLeadershipRelationNew", expiration=300)
    public Boolean isLeadershipRelationNew(@ParameterValueKeyProvider(order=0) String leaderId, @ParameterValueKeyProvider(order=1) String subordinateId) {
        Set<String> leadeInfo = this.mallUserMapper.findLeaderByUserId(subordinateId);
        if (leadeInfo.contains(leaderId)) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean isLeadership(String leaderId, String subordinateId) {
        String key = "isLeadership_" + leaderId + "_" + subordinateId;
        Object o = this.redisCacheUtil.get(key);
        if (o != null) {
            return (Boolean)o;
        }
        cc.lechun.authority.entity.MallUserEntity param = new cc.lechun.authority.entity.MallUserEntity();
        param.setLeader(leaderId);
        param.setUserId(subordinateId);
        List list = this.mallUserMapper.getList(param);
        if (list == null || list.size() == 0) {
            this.redisCacheUtil.set(key, (Object)false, Long.valueOf(300L));
            return false;
        }
        this.redisCacheUtil.set(key, (Object)true, Long.valueOf(300L));
        return true;
    }

    @Override
    @ReadThroughSingleCache(namespace="getSysUserList4RoleId", expiration=300)
    public List<cc.lechun.authority.entity.MallUserEntity> getSysUserList4RoleId(@ParameterValueKeyProvider(order=0) Integer roleId) {
        return this.mallUserMapper.getSysUserList4RoleId(roleId);
    }

    @Override
    public List<MallUserEntityVo> getMallUserInfoByParam(String userName, String userNick, String dingdingId, Integer platformGroupId) {
        return this.mallUserMapper.getMallUserInfoByParam(userName, userNick, dingdingId, platformGroupId);
    }

    @Override
    public int updateUserDingDingIdById(String userId, String dingdingId) {
        return this.mallUserMapper.updateUserDingDingIdById(userId, dingdingId);
    }

    @Override
    public List<cc.lechun.authority.entity.MallUserEntity> getSysUserListByStatus() {
        return this.mallUserMapper.getSysUserListByStatus();
    }

    @Override
    public List<Map<String, Object>> getDeparts() {
        return this.mallUserMapper.getDeparts();
    }

    @Override
    public List<cc.lechun.authority.entity.MallUserEntity> getEqualDeptUser(String userId) {
        cc.lechun.authority.entity.MallUserEntity user = this.getMallUser(userId);
        if (user != null && user.getDeptId() != null) {
            cc.lechun.authority.entity.MallUserEntity param = new cc.lechun.authority.entity.MallUserEntity();
            param.setDeptId(user.getDeptId());
            return this.mallUserMapper.getList(param);
        }
        return new ArrayList<cc.lechun.authority.entity.MallUserEntity>();
    }

    @Override
    public void deleteByUserId(String userId) {
        this.mallUserRoleMapper.deleteByUserId(userId);
    }

    @Override
    public BaseJsonVo<MallUserEntity> getUserEntity(String userId) {
        cc.lechun.authority.entity.MallUserEntity mallUserEntity = (cc.lechun.authority.entity.MallUserEntity)this.mallUserMapper.selectByPrimaryKey((Serializable)((Object)userId));
        MallUserEntity entity = new MallUserEntity();
        entity.setUserId(mallUserEntity.getUserId());
        entity.setUserName(mallUserEntity.getUserName());
        entity.setUserNick(mallUserEntity.getUserNick());
        entity.setDingdingId(mallUserEntity.getDingdingId());
        entity.setUserType(mallUserEntity.getUserType());
        entity.setLeader(mallUserEntity.getLeader());
        entity.setDeptId(mallUserEntity.getDeptId());
        entity.setStatus(mallUserEntity.getStatus());
        entity.setMobile(mallUserEntity.getMobile());
        entity.setQyWeixinUserid(mallUserEntity.getQyWeixinUserid());
        return BaseJsonVo.success((Object)entity);
    }

    @Override
    public String getDingDingDeptNames(@ParameterValueKeyProvider(order=0) String userId) {
        return this.mallUserMapper.getUserDeptNames(userId);
    }

    public void testCoplitSave(cc.lechun.authority.entity.MallUserEntity userEntity) {
    }

    @Override
    public List<String> getUnRegularUser(int limitStart) {
        return this.mallUserMapper.getUnRegularUser(limitStart);
    }

    @Override
    public int updateRDateByDingDingId(String dingdingId, String rDate) {
        return this.mallUserMapper.updateRDateByDingDingId(dingdingId, rDate);
    }

    @Override
    public cc.lechun.authority.entity.MallUserEntity getUserByDingdingID(String dingdingId) {
        cc.lechun.authority.entity.MallUserEntity param = new cc.lechun.authority.entity.MallUserEntity();
        param.setDingdingId(dingdingId);
        param.setStatus(1);
        List list = this.mallUserMapper.getList(param);
        return list != null && !list.isEmpty() ? (cc.lechun.authority.entity.MallUserEntity)list.get(0) : null;
    }

    @Override
    public List<cc.lechun.authority.entity.MallUserEntity> getAllActiveUsers() {
        return this.mallUserMapper.getAllActiveUsers();
    }

    @Override
    public List<cc.lechun.authority.entity.MallUserEntity> getAllClassUsers(Integer classId) {
        return this.mallUserMapper.getAllClassUsers(classId);
    }
}

