/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.authority.service;

import cc.lechun.authority.dao.PlatformGroupMapper;
import cc.lechun.authority.entity.PlatformGroupEntity;
import cc.lechun.authority.iservice.PlatformGroupInterface;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.database.annotation.ReadDataSource;
import cc.lechun.framework.core.database.annotation.WriteDataSource;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughAssignCache;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlatformGroupService
implements PlatformGroupInterface {
    private static final Logger log = LoggerFactory.getLogger(PlatformGroupService.class);
    @Autowired
    private PlatformGroupMapper platformGroupMapper;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    @WriteDataSource
    public PlatformGroupEntity savePlatFormGroup(PlatformGroupEntity PlatformGroupEntity2) {
        PlatformGroupEntity2.setCreateTime(DateUtils.now());
        this.platformGroupMapper.insertSelective(PlatformGroupEntity2);
        this.removeCache(PlatformGroupEntity2.getPlatformGroupId());
        return PlatformGroupEntity2;
    }

    @Override
    @WriteDataSource
    public PlatformGroupEntity updatePlatFormGroup(PlatformGroupEntity PlatformGroupEntity2) {
        this.platformGroupMapper.updateByPrimaryKeySelective(PlatformGroupEntity2);
        this.removeCache(PlatformGroupEntity2.getPlatformGroupId());
        return PlatformGroupEntity2;
    }

    @Override
    @WriteDataSource
    public void deletePlatFormGroup(int platformGroupId) {
        PlatformGroupEntity platFormGroup = this.getPlatFormGroup(platformGroupId);
        platFormGroup.setStatus(-1);
        this.platformGroupMapper.updateByPrimaryKeySelective(platFormGroup);
        this.removeCache(platformGroupId);
    }

    @Override
    public PlatformGroupEntity getPlatFormGroup(@ParameterValueKeyProvider int platformGroupId) {
        PlatformGroupEntity platformGroupEntity = (PlatformGroupEntity)this.platformGroupMapper.selectByPrimaryKey(Integer.valueOf(platformGroupId));
        return platformGroupEntity;
    }

    @Override
    @ReadThroughAssignCache(assignedKey="list", namespace="ValidPlatFormGroupList", expiration=7200)
    @ReadDataSource
    public List<PlatformGroupEntity> getValidPlatFormGroupList() {
        PlatformGroupEntity PlatformGroupEntity2 = new PlatformGroupEntity();
        PlatformGroupEntity2.setStatus(1);
        return this.platformGroupMapper.getList(PlatformGroupEntity2);
    }

    @Override
    @ReadThroughAssignCache(assignedKey="list", namespace="PlatFormGroupList", expiration=7200)
    @ReadDataSource
    public List<PlatformGroupEntity> getPlatFormGroupList() {
        return this.platformGroupMapper.getList(new PlatformGroupEntity());
    }

    @Override
    public PageInfo getPlatFormGroupList(int pageNum, int pageSize) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.platformGroupMapper.getList(new PlatformGroupEntity());
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    private void removeCache(Integer platformGroupId) {
        this.memcachedService.delete("PlatFormGroup", platformGroupId + "");
        this.memcachedService.delete("PlatFormGroupList", "list");
        this.memcachedService.delete("ValidPlatFormGroupList", "list");
    }
}

