/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.authority.utils;

import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class GuanyuanBIUtils {
    public static final String CHARSET = "UTF-8";
    public static final String RSA_ALGORITHM = "RSA";
    public static final int KEY_SIZE = 1024;
    private static String priKey = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAJyPvIVJDpfiMgpB91f16V3iTxzKa5vkoUnvLGnJTZskxtbiLYXDaM3jVCZFUmxMQgSJcbI7epwEr8yZS2MLLFE+vS6Oy1t7vSAH2e+U6bxBuAHUYNpxuYQSDpswbMnuZlLqVKXMxa5cKh3lFeLQzpkLFYhyaiAop2ioJBPK7QS9AgMBAAECgYAwBFWJe3KiWpmGU90MeTtts+8XoW2HjoN5LYWtnDPVFV52oT/c+qW2H7a7Vh+FX44P3iekxmFAYJ+aXJmmctLQS/oOgkyvMh5ypnZT6KF7SP+TqPVu8EQfXlumdqgD41BIC4hq2+gn2wVXCMU25S0hfWeGSJfN9g0MGwcODqwl8QJBAOj6Zgy7/XGnEZZeFr0rAEYeoekEDVqIi308CPYO2cH6dmijcRpzaNS+PS/7bI3A4t1ZO/FKkHKCafD6Pu81c18CQQCsCD2tecXhkFC2JULFcCB3XBRCQt8NeQMld/rkIs8rZnglk8erZ8YGAVM0ncCPhadfStkCjHMolImkbR3KNvljAkEAvq6KrauDYOzziRWTGNrEC5/wtq15XHrbZ/GmB/XZplkfZr82yAZja5QUslve2hpf0/jABdoYZZB1sySuM8yUkwJBAJQBgw789YJa5xXOeOPk1Anc7pETd1PgCRTzZKdiS1rLjhLGUcLmRThla3CZSFIyaw1RF+NZcro3ETSlrDuNkIECQE/mWVH3kxvtFUbxWkKaaqkZ5rEE/3GX0HaQyaVWksK8KOOR83WpmVawEnfm3jmcAIBTzwEotPZsacMq7PfPnuE=";

    public static void main(String[] args) {
        try {
            System.out.println(GuanyuanBIUtils.buildAccessToken("sso@lechun.cc"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static RSAPrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
        return (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
    }

    public static String privateEncrypt(String data, RSAPrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, privateKey);
            return Base64.encodeBase64String((byte[])GuanyuanBIUtils.rsaSplitCodec(cipher, 1, data.getBytes(CHARSET), privateKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] rsaSplitCodec(Cipher cipher, int opMode, byte[] data, int keySize) {
        int blockSize = opMode == 2 ? keySize / 8 : keySize / 8 - 11;
        ArrayList<byte[]> resultList = new ArrayList<byte[]>();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            for (int offset = 0; data.length > offset; offset += blockSize) {
                int length = Math.min(data.length - offset, blockSize);
                byte[] encryptedBlock = cipher.doFinal(data, offset, length);
                resultList.add(encryptedBlock);
            }
            for (byte[] block : resultList) {
                outputStream.write(block);
            }
            Object object = outputStream.toByteArray();
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static Map<String, String> buildAccessToken(String userMail) {
        if (StringUtils.isEmpty((String)userMail)) {
            return new HashMap<String, String>();
        }
        String domainid = "guanbi";
        String userId = userMail;
        long time = new Date().getTime();
        String str = "{\"domainId\":\"" + domainid + "\",\"externalUserId\":\"" + userId + "\",\"timestamp\":" + time + "}";
        try {
            String access = GuanyuanBIUtils.privateEncrypt(str, GuanyuanBIUtils.getPrivateKey(priKey));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("provider", domainid);
            map.put("ssoToken", GuanyuanBIUtils.toHexString(access));
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, String>();
        }
    }

    public static String toHexString(String s) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            str.append(Integer.toHexString(ch));
        }
        return str.toString();
    }
}

