/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.groupon;

import cc.lechun.active.entity.groupon.GrouponDetailEntity;
import cc.lechun.active.entity.groupon.GrouponOrderVo;
import cc.lechun.active.entity.groupon.GrouponRefundOrderVo;
import cc.lechun.active.service.groupon.GrouponMessageHandle;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.weixin.TemplateMessageEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.message.templatemessage.TemplateMessageItem;
import weixin.popular.bean.message.templatemessage.TemplateMessageResult;

@Component(value="lechunGrouponMessage")
public class LechunGrouponMessageHandle
extends BaseService
implements GrouponMessageHandle {
    @Lazy
    @Autowired
    private MessageInterface messageService;
    @Autowired
    private TemplateMessageInterface templateMessageInterface;
    @Autowired
    @Lazy
    private MallOrderProductInterface orderProductInterface;
    @Autowired
    private CustomerInterface customerService;

    @Override
    public BaseJsonVo startGrouponNotice(GrouponOrderVo grouponOrderVo) {
        LinkedHashMap<String, TemplateMessageItem> data = new LinkedHashMap<String, TemplateMessageItem>();
        TemplateMessageItem first = new TemplateMessageItem();
        first.setColor("");
        TemplateMessageEntity templateMessageEntity = this.templateMessageInterface.getTemplateMessageById(27);
        first.setValue(MessageFormat.format(templateMessageEntity.getFirst(), grouponOrderVo.getTotal() - grouponOrderVo.getOnly()));
        data.put("first", first);
        TemplateMessageItem keyword1 = new TemplateMessageItem();
        keyword1.setColor("");
        keyword1.setValue("\u4e50\u7eaf\u56e2\u8d2d\u6d3b\u52a8");
        data.put("keyword1", keyword1);
        TemplateMessageItem keyword2 = new TemplateMessageItem();
        keyword2.setColor("");
        keyword2.setValue(grouponOrderVo.getProductName());
        data.put("keyword2", keyword2);
        TemplateMessageItem keyword3 = new TemplateMessageItem();
        keyword3.setColor("");
        keyword3.setValue(String.valueOf(grouponOrderVo.getPrice()));
        data.put("keyword3", keyword3);
        TemplateMessageItem keyword4 = new TemplateMessageItem();
        keyword4.setColor("");
        keyword4.setValue(String.valueOf(grouponOrderVo.getTotal()));
        data.put("keyword4", keyword4);
        TemplateMessageItem remark = new TemplateMessageItem();
        remark.setColor("");
        String url = templateMessageEntity.getUrl();
        url = StringUtils.isNotEmpty((String)templateMessageEntity.getUrl()) ? MessageFormat.format(url, grouponOrderVo.getOrderMainNo(), grouponOrderVo.getBindCode(), grouponOrderVo.getGrouponRoleType(), grouponOrderVo.getInviteId(), grouponOrderVo.getTotal() - grouponOrderVo.getOnly()) : "";
        remark.setValue(MessageFormat.format("\u62fc\u8d2d\u65f6\u95f4:{0}\u81f3{1}", DateUtils.now((String)"yyyy-MM-dd HH:mm:ss").substring(5, 16), DateUtils.formatDate((Date)grouponOrderVo.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss").substring(5, 16)));
        data.put("remark", remark);
        try {
            TemplateMessageResult result = this.messageService.messageTemplateSend4CustmoerId(grouponOrderVo.getPlatFormId(), grouponOrderVo.getCustomerId(), url, templateMessageEntity.getTemplateId(), data);
            this.logger.info("\u63a8\u9001\u53c2\u56e2\u6d88\u606f\u72b6\u6001:" + result.isSuccess() + ",,customerId=" + grouponOrderVo.getCustomerId() + ",orderNo=" + grouponOrderVo.getOrderMainNo());
            if (result.isSuccess()) {
                return BaseJsonVo.success((Object)"");
            }
            String temp = MessageFormat.format("\u60a8\u53c2\u4e0e\u7684\u56e2\u8d2d\u5dee{0}\u4e2a\u597d\u53cb\u5c31\u80fd\u62fc\u56e2\u6210\u529f\u4e86\u3002", grouponOrderVo.getTotal() - grouponOrderVo.getOnly()) + "<a href='" + url + "'>\u73b0\u5728\u5c06\u60a8\u7684\u56e2\u8d2d\u9875\u9762\u5206\u4eab\u7ed9\u597d\u53cb\uff0c\u4e00\u8d77\u5206\u4eab\u4e50\u7eaf\u6ecb\u5473\u5427~>></a>";
            BaseResult baseResult = this.messageService.sendCustomerTextMessage4CustmoerId(grouponOrderVo.getCustomerId(), grouponOrderVo.getPlatFormId(), temp, 0);
            return baseResult.isSuccess() ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u6d88\u606f\u63a8\u9001\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"");
        }
    }

    @Override
    public BaseJsonVo joinGrouponNoticeFail(GrouponRefundOrderVo grouponRefundOrderVo) {
        this.logger.info("\u5c06\u53d1\u9001\u56e2\u8d2d\u8ba2\u5355\u8d85\u65f6\u6d88\u606f:{}", (Object)grouponRefundOrderVo.toString());
        LinkedHashMap<String, TemplateMessageItem> data = new LinkedHashMap<String, TemplateMessageItem>();
        TemplateMessageEntity templateMessageEntity = this.templateMessageInterface.getTemplateMessageById(28);
        TemplateMessageItem first = new TemplateMessageItem();
        first.setColor(StringUtils.isNotEmpty((String)templateMessageEntity.getTopColor()) ? templateMessageEntity.getTopColor() : "");
        first.setValue("\u62fc\u56e2\u8d85\u65f6");
        data.put("first", first);
        Optional result = this.orderProductInterface.getOrderProductInfoByOrderMianNo(grouponRefundOrderVo.getOrderMainNo()).stream().findFirst();
        if (!result.isPresent()) {
            this.logger.error("\u63a8\u9001\u62fc\u56e2\u5931\u8d25\u6d88\u606f\u51fa\u9519\uff0c\u67e5\u8be2\u5546\u54c1\u4e3a\u7a7a,\u8ba2\u5355\u53f7={}", (Object)grouponRefundOrderVo.getOrderMainNo());
            return BaseJsonVo.error((String)"\u67e5\u8be2\u8ba2\u5355\u5546\u54c1\u51fa\u9519");
        }
        this.logger.info("\u62fc\u56e2\u5546\u54c1:{}", result.get());
        TemplateMessageItem keyworld1 = new TemplateMessageItem();
        keyworld1.setColor(StringUtils.isNotEmpty((String)templateMessageEntity.getTopColor()) ? templateMessageEntity.getTopColor() : "");
        keyworld1.setValue(((MallOrderProductEntity)result.get()).getProductName());
        data.put("keyword1", keyworld1);
        TemplateMessageItem keyworld2 = new TemplateMessageItem();
        keyworld2.setColor(StringUtils.isNotEmpty((String)templateMessageEntity.getTopColor()) ? templateMessageEntity.getTopColor() : "");
        keyworld2.setValue(((MallOrderProductEntity)result.get()).getTotalPrice().toString());
        data.put("keyword2", keyworld2);
        TemplateMessageItem keyworld3 = new TemplateMessageItem();
        keyworld3.setColor(StringUtils.isNotEmpty((String)templateMessageEntity.getTopColor()) ? templateMessageEntity.getTopColor() : "");
        keyworld3.setValue(((MallOrderProductEntity)result.get()).getTotalPrice().toString());
        data.put("keyword3", keyworld3);
        TemplateMessageItem remark = new TemplateMessageItem();
        remark.setColor(StringUtils.isNotEmpty((String)templateMessageEntity.getBottomColor()) ? templateMessageEntity.getBottomColor() : "");
        remark.setValue(StringUtils.isNotEmpty((String)templateMessageEntity.getRemark()) ? templateMessageEntity.getRemark() : "");
        data.put("remark", remark);
        this.messageService.messageTemplateSend4CustmoerId(grouponRefundOrderVo.getPlatformId(), grouponRefundOrderVo.getCustomerId(), StringUtils.isNotEmpty((String)templateMessageEntity.getUrl()) ? templateMessageEntity.getUrl() + "&bindcode=" + grouponRefundOrderVo.getBindCode() : "", templateMessageEntity.getTemplateId(), data);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo joinGrouponNoticeSuccess(GrouponOrderVo grouponOrderVo) {
        int messagId = 26;
        TemplateMessageEntity templateMessageEntity = this.templateMessageInterface.getTemplateMessageById(26);
        LinkedHashMap<String, TemplateMessageItem> data = new LinkedHashMap<String, TemplateMessageItem>();
        TemplateMessageItem keyword1 = new TemplateMessageItem();
        keyword1.setColor("");
        keyword1.setValue(grouponOrderVo.getProductName());
        data.put("keyword1", keyword1);
        TemplateMessageItem keyword2 = new TemplateMessageItem();
        keyword2.setColor("");
        keyword2.setValue(grouponOrderVo.getGrouponerNick());
        data.put("keyword2", keyword2);
        TemplateMessageItem keyword3 = new TemplateMessageItem();
        keyword3.setColor("");
        keyword3.setValue(String.valueOf(grouponOrderVo.getTotal()));
        data.put("keyword3", keyword3);
        TemplateMessageItem remark = new TemplateMessageItem();
        remark.setColor("");
        String remarkText = MessageFormat.format(templateMessageEntity.getRemark(), DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy-MM-dd HH:mm:ss").substring(5, 16), DateUtils.formatDate((Date)grouponOrderVo.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss").substring(5, 16));
        remark.setValue(remarkText);
        data.put("remark", remark);
        TemplateMessageResult result = null;
        try {
            result = this.messageService.messageTemplateSend4CustmoerId(grouponOrderVo.getPlatFormId(), grouponOrderVo.getCustomerId(), StringUtils.isNotEmpty((String)templateMessageEntity.getUrl()) ? templateMessageEntity.getUrl() : "", templateMessageEntity.getTemplateId(), data);
            if (!result.isSuccess()) {
                this.messageService.sendCustomerTextMessage4CustmoerId(grouponOrderVo.getCustomerId(), grouponOrderVo.getPlatFormId(), "\u4f60\u53c2\u4e0e\u7684\u4e50\u7eaf\u56e2\u8d2d\u6d3b\u52a8\u62fc\u56e2\u6210\u529f", 0);
            }
            this.logger.info("\u63a8\u9001\u6210\u56e2\u6d88\u606f:{},customerId={}", (Object)result.isSuccess(), (Object)grouponOrderVo.getCustomerId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public void noticeGrouponerShare(GrouponOrderVo grouponEntity, GrouponDetailEntity grouponDetailEntity) {
        CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(grouponEntity.getCustomerId(), grouponEntity.getPlatFormId());
        String nick = customerDetailVo != null ? customerDetailVo.getNickName() : "";
        TemplateMessageEntity templateMessageEntity = this.templateMessageInterface.getTemplateMessageById(26);
        String url = "";
        url = templateMessageEntity.getUrl();
        url = MessageFormat.format(url, grouponEntity.getOrderMainNo(), grouponEntity.getBindCode(), 1, grouponDetailEntity.getInviteId(), grouponEntity.getCustomerId());
        String content = MessageFormat.format("\u4f60\u7684\u597d\u53cb{0}\u5df2\u52a0\u5165\uff0c\u548c\u4f60\u4e00\u8d77\u62fc\u56e2\u3002\u4f60\u8fd8\u5dee{1}\u4e2a\u597d\u53cb\u5c31\u80fd\u56e2\u8d2d\u6210\u529f\u4e86\u3002", StringUtils.isNotEmpty((String)nick) ? nick : "", grouponEntity.getTotal() - grouponEntity.getOnly()) + "<a href='" + url + "'>\u70b9\u70b9\u70b9\u8fd9\u91cc\uff0c\u7ee7\u7eed\u5206\u4eab\u7ed9\u597d\u53cb>>></a>";
        this.logger.info("\u901a\u77e5\u7ee7\u7eed\u5206\u4eab\u5185\u5bb9:{}", (Object)content);
        this.messageService.sendCustomerTextMessage4CustmoerId(grouponDetailEntity.getCustomerId(), grouponDetailEntity.getPlatformId(), content, 0);
    }
}

