/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.luckydraw;

import cc.lechun.active.dao.luckydraw.ActiveLuckyDrawJackpotMapper;
import cc.lechun.active.dao.luckydraw.ActiveLuckyDrawMapper;
import cc.lechun.active.dao.luckydraw.ActiveLuckyDrawPrizeMapper;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawEntity;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawJackpotEntity;
import cc.lechun.active.entity.luckydraw.ActiveLuckyDrawPrizeEntity;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawConditionInterface;
import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.service.thirdparty.OldApiUtil;
import cc.lechun.mall.service.thirdparty.OldWealthUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActiveLuckyDrawService
extends BaseService
implements ActiveLuckyDrawInterface {
    @Autowired
    ActiveLuckyDrawMapper luckyDrawMapper;
    @Autowired
    ActiveLuckyDrawPrizeMapper prizeMapper;
    @Autowired
    ActiveLuckyDrawJackpotMapper jackpotMapper;
    @Autowired
    ActiveLuckyDrawConditionInterface conditionInterface;
    @Autowired
    private OldApiUtil oldApiUtil;
    @Autowired
    private OldWealthUtil oldWealthUtil;

    @Override
    public BaseJsonVo luckyDrawListByBindCode(String bindCode) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        String[] bindCodes = new String[]{bindCode};
        List<ActiveLuckyDrawEntity> luckyDrawlist = this.luckyDrawMapper.selectByBindCodes(bindCodes);
        if (luckyDrawlist.size() > 0) {
            BaseJsonVo2.setValue(luckyDrawlist);
        } else {
            BaseJsonVo2.setError("\u67e5\u65e0\u7ed3\u679c");
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo luckyDrawList(String activeNo) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        String[] bindCodes = new String[]{"18a96bc29b814be1b1525e76990217aa"};
        List<ActiveLuckyDrawEntity> luckyDrawlist = this.luckyDrawMapper.selectByBindCodes(bindCodes);
        if (luckyDrawlist.size() > 0) {
            BaseJsonVo2.setValue(luckyDrawlist);
        } else {
            BaseJsonVo2.setError("\u67e5\u65e0\u7ed3\u679c");
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo getLuckyDraw(String luckyDrawId) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        ActiveLuckyDrawEntity entity = (ActiveLuckyDrawEntity)this.luckyDrawMapper.selectByPrimaryKey((Serializable)((Object)luckyDrawId));
        if (entity != null) {
            BaseJsonVo2.setValue((Object)entity);
        } else {
            BaseJsonVo2.setError("\u67e5\u65e0\u7ed3\u679c");
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo addLuckyDraw(ActiveLuckyDrawEntity entity) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        Integer result = 0;
        if (StringUtils.isEmpty((String)entity.getId())) {
            entity.setId(RandomUtils.generateStrId());
            result = this.luckyDrawMapper.insertSelective(entity);
        } else {
            result = this.luckyDrawMapper.updateByPrimaryKeySelective(entity);
        }
        if (result == 1) {
            BaseJsonVo2.setValue((Object)entity);
        } else {
            BaseJsonVo2.setError("\u4fee\u6539\u5931\u8d25");
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo deleteLuckyDraw(String luckyDrawId) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        Integer result = this.luckyDrawMapper.deleteByPrimaryKey((Serializable)((Object)luckyDrawId));
        if (result != 1) {
            BaseJsonVo2.setError("\u5220\u9664\u5931\u8d25");
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo luckyDrawPrizeList(String luckyDrawId) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        ActiveLuckyDrawPrizeEntity entity = new ActiveLuckyDrawPrizeEntity();
        entity.setLuckyDrawId(luckyDrawId);
        List luckyDrawlist = this.prizeMapper.getList(entity);
        if (luckyDrawlist.size() > 0) {
            BaseJsonVo2.setValue((Object)luckyDrawlist);
        } else {
            BaseJsonVo2.setError("\u67e5\u65e0\u7ed3\u679c");
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo getLuckyDrawPrize(String luckyDrawPrizeId) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        ActiveLuckyDrawPrizeEntity prizeEntity = (ActiveLuckyDrawPrizeEntity)this.prizeMapper.selectByPrimaryKey((Serializable)((Object)luckyDrawPrizeId));
        if (prizeEntity != null) {
            BaseJsonVo2.setValue((Object)prizeEntity);
        } else {
            BaseJsonVo2.setError("\u67e5\u65e0\u7ed3\u679c");
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo addLuckyDrawPrize(ActiveLuckyDrawPrizeEntity entity) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        Integer result = 0;
        if (StringUtils.isEmpty((String)entity.getId())) {
            entity.setId(RandomUtils.generateStrId());
            result = this.prizeMapper.insertSelective(entity);
        } else {
            result = this.prizeMapper.updateByPrimaryKeySelective(entity);
        }
        if (result == 1) {
            BaseJsonVo2.setValue((Object)entity);
        } else {
            BaseJsonVo2.setError("\u4fee\u6539\u5931\u8d25");
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo deleteLuckyDrawPrize(String luckyDrawPrizeId) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        Integer result = this.prizeMapper.deleteByPrimaryKey((Serializable)((Object)luckyDrawPrizeId));
        if (result != 1) {
            BaseJsonVo2.setError("\u5220\u9664\u5931\u8d25");
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo luckyDrawJackypotOverviewList(String luckyDrawId) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        List<Integer> periods = this.jackpotMapper.findAllPeriod(luckyDrawId);
        ActiveLuckyDrawPrizeEntity searchEntity = new ActiveLuckyDrawPrizeEntity();
        searchEntity.setLuckyDrawId(luckyDrawId);
        List prizes = this.prizeMapper.getList(searchEntity);
        HashMap resultMap = new HashMap(periods.size());
        for (Integer period : periods) {
            HashMap<String, String> innerMap = new HashMap<String, String>(prizes.size());
            for (ActiveLuckyDrawPrizeEntity prize : prizes) {
                innerMap.put(prize.getId(), "0/0");
            }
            resultMap.put(period, innerMap);
        }
        List<Map<String, Object>> list = this.jackpotMapper.findJackypotOverviewList(luckyDrawId);
        if (list.size() > 0) {
            for (Map<String, Object> map : list) {
                for (Integer period : periods) {
                    for (ActiveLuckyDrawPrizeEntity prize : prizes) {
                        if (!period.equals(Integer.valueOf(map.get("PERIOD").toString())) || !prize.getId().equals(map.get("PRIZE_ID"))) continue;
                        String s = (String)((Map)resultMap.get(period)).get(prize.getId());
                        Integer s_used = Integer.valueOf(s.split("/")[0]);
                        Integer s_unused = Integer.valueOf(s.split("/")[1]);
                        if (Integer.valueOf(map.get("IS_USED").toString()) == 0) {
                            s_unused = s_unused + Integer.valueOf(map.get("USE_COUNT").toString());
                        } else {
                            s_used = s_used + Integer.valueOf(map.get("USE_COUNT").toString());
                        }
                        ((Map)resultMap.get(period)).put(prize.getId(), s_used + "/" + (s_unused + s_used));
                    }
                }
            }
            BaseJsonVo2.setValue(resultMap);
        } else {
            BaseJsonVo2.setError("\u67e5\u65e0\u7ed3\u679c");
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo luckyDrawJackypotSortList(String luckyDrawId, Integer period) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        List<Map> list = this.jackpotMapper.getLuckyDrawJackypotSortList(luckyDrawId, period);
        if (list.size() > 0) {
            BaseJsonVo2.setValue(list);
        } else {
            BaseJsonVo2.setError("\u67e5\u65e0\u7ed3\u679c");
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo generateJackypot(String luckyDrawId, Integer period, Integer gererateType, Map<String, Integer> paramMap) {
        ActiveLuckyDrawJackpotEntity entity;
        AbstractList resultList = null;
        if (gererateType == 1) {
            resultList = new ArrayList();
            HashMap pot = new HashMap();
            for (String string : paramMap.keySet()) {
                ArrayList<ActiveLuckyDrawJackpotEntity> list = new ArrayList<ActiveLuckyDrawJackpotEntity>();
                for (int i = 0; i < paramMap.get(string); ++i) {
                    entity = new ActiveLuckyDrawJackpotEntity();
                    entity.setId(String.valueOf(IDGenerate.getUniqueID()));
                    entity.setLuckyDrawId(luckyDrawId);
                    entity.setPrizeId(string);
                    entity.setPeriod(period);
                    entity.setIsUsed(0);
                    list.add(entity);
                }
                pot.put(string, list);
            }
            for (String string : pot.keySet()) {
                resultList.addAll((Collection)pot.get(string));
            }
            Collections.shuffle(resultList);
        } else {
            resultList = new LinkedList();
            ArrayList<Map.Entry<String, Integer>> paramList = new ArrayList<Map.Entry<String, Integer>>(paramMap.entrySet());
            Collections.sort(paramList, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return o2.getValue().compareTo(o1.getValue());
                }
            });
            for (Map.Entry entry : paramList) {
                if (resultList.size() == 0) {
                    for (int i = 0; i < paramMap.get(entry.getKey()); ++i) {
                        ActiveLuckyDrawJackpotEntity entity2 = new ActiveLuckyDrawJackpotEntity();
                        entity2.setId(String.valueOf(IDGenerate.getUniqueID()));
                        entity2.setLuckyDrawId(luckyDrawId);
                        entity2.setPrizeId((String)entry.getKey());
                        entity2.setPeriod(period);
                        entity2.setIsUsed(0);
                        resultList.add(entity2);
                    }
                    continue;
                }
                int step = resultList.size() / (Integer)entry.getValue();
                for (int i = 0; i < paramMap.get(entry.getKey()); ++i) {
                    entity = new ActiveLuckyDrawJackpotEntity();
                    entity.setId(String.valueOf(IDGenerate.getUniqueID()));
                    entity.setLuckyDrawId(luckyDrawId);
                    entity.setPrizeId((String)entry.getKey());
                    entity.setPeriod(period);
                    entity.setIsUsed(0);
                    resultList.add(step * (i + 1) + i, entity);
                }
            }
        }
        int i = 0;
        for (ActiveLuckyDrawJackpotEntity activeLuckyDrawJackpotEntity : resultList) {
            activeLuckyDrawJackpotEntity.setSortNum(++i);
        }
        this.jackpotMapper.batchInsert(resultList);
        return null;
    }

    @Override
    public BaseJsonVo resortLuckyDrawJackypot(String id, Integer newSortNum) {
        ActiveLuckyDrawJackpotEntity jackpotEntity = new ActiveLuckyDrawJackpotEntity();
        jackpotEntity.setId(id);
        jackpotEntity.setSortNum(newSortNum);
        this.jackpotMapper.updateByPrimaryKeySelective(jackpotEntity);
        return new BaseJsonVo();
    }

    @Override
    public BaseJsonVo canParticipate(CustomerDetailVo customer, String bindCode) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        String[] bindCodes = new String[]{bindCode};
        List<ActiveLuckyDrawEntity> luckyDrawlist = this.luckyDrawMapper.selectByBindCodes(bindCodes);
        if (luckyDrawlist == null || luckyDrawlist.size() == 0) {
            BaseJsonVo2.setError("bindCode\u9519\u8bef");
            return BaseJsonVo2;
        }
        Integer limitCount = luckyDrawlist.get(0).getLimitCount();
        if (limitCount == 0) {
            return BaseJsonVo2;
        }
        List<ActiveLuckyDrawJackpotEntity> partRecords = this.jackpotMapper.findCustomerPartRecord(customer.getCustomerId(), luckyDrawlist.get(0).getId());
        if (partRecords != null && partRecords.size() >= limitCount) {
            BaseJsonVo2.setError("\u62bd\u5956\u6b21\u6570\u8d85\u9650");
            BaseJsonVo2.setValue(partRecords);
            return BaseJsonVo2;
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo findCustomersWhoDrawedYesterday(String bindCode) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        String beginTime = DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)-86400, (String)"yyyy-MM-dd") + " 00:00:00";
        String endTime = DateUtils.date() + " 00:00:00";
        List<String> luckyDrawJackpotlist = this.jackpotMapper.findCustomersWhoDrawedYesterday(bindCode, beginTime, endTime);
        ArrayList<String> luckyDrawJackpotlist2 = new ArrayList<String>();
        for (String name : luckyDrawJackpotlist) {
            if (!StringUtils.isNotEmpty((String)name)) continue;
            luckyDrawJackpotlist2.add(name);
        }
        BaseJsonVo2.setValue(luckyDrawJackpotlist2);
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo getBestPrize(String bindCode) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        String[] bindCodes = new String[]{bindCode};
        List<ActiveLuckyDrawEntity> entitys = this.luckyDrawMapper.selectByBindCodes(bindCodes);
        if (entitys == null || entitys.size() == 0) {
            BaseJsonVo2.setError("\u9519\u8bef\u7684bindCode");
            return BaseJsonVo2;
        }
        ActiveLuckyDrawEntity entity = entitys.get(0);
        Map<String, Object> bestPrize = this.prizeMapper.getBestPrize(entity.getId(), entity.getCurrentPeriod());
        Integer bestPrizeCount = this.prizeMapper.getBestPrizeCount(entity.getId(), entity.getCurrentPeriod(), bestPrize.get("PRIZE_ID").toString());
        if (bestPrizeCount <= 0) {
            bestPrizeCount = 1;
        }
        bestPrize.put("_COU", bestPrizeCount);
        BaseJsonVo2.setValue(bestPrize);
        return BaseJsonVo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo draw(CustomerDetailVo customer, String areaId, String bindCode) throws Exception {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        String[] bindCodes = new String[]{bindCode};
        List<ActiveLuckyDrawEntity> luckyDrawlist = this.luckyDrawMapper.selectByBindCodes(bindCodes);
        if (luckyDrawlist == null || luckyDrawlist.size() == 0) {
            BaseJsonVo2.setError("bindCode\u9519\u8bef");
            return BaseJsonVo2;
        }
        String luckyDrawId = luckyDrawlist.get(0).getId();
        Integer period = luckyDrawlist.get(0).getCurrentPeriod();
        List<ActiveLuckyDrawPrizeEntity> prizeEntities = this.conditionInterface.getPrizeListByCondition(customer.getCustomerId(), areaId, luckyDrawId);
        String[] prizeCondition = new String[prizeEntities.size()];
        for (int i = 0; i < prizeEntities.size(); ++i) {
            prizeCondition[i] = prizeEntities.get(i).getId();
        }
        ActiveLuckyDrawService activeLuckyDrawService = this;
        synchronized (activeLuckyDrawService) {
            ActiveLuckyDrawJackpotEntity entity = this.jackpotMapper.getFirstLott(customer.getCustomerId(), luckyDrawId, period, prizeCondition);
            if (entity == null || StringUtils.isEmpty((String)entity.getId())) {
                BaseJsonVo2.setError("\u5956\u6c60\u5df2\u62bd\u5b8c");
            } else {
                entity.setCustomerId(customer.getCustomerId());
                entity.setIsUsed(1);
                entity.setUsedTime(DateUtils.now());
                int result = this.jackpotMapper.updateByPrimaryKeySelective(entity);
                if (result <= 0) {
                    BaseJsonVo2.setError("\u62bd\u5956\u5931\u8d25");
                } else {
                    ActiveLuckyDrawPrizeEntity prize = (ActiveLuckyDrawPrizeEntity)this.prizeMapper.selectByPrimaryKey((Serializable)((Object)entity.getPrizeId()));
                    if ("1".equals(prize.getPrizeType())) {
                        for (int i = 0; i < 5; ++i) {
                            try {
                                Map<String, Object> rtnMap = this.oldApiUtil.sendCashTicket(customer.getCustomerId(), prize.getPrizeData());
                                if (rtnMap == null) continue;
                                i = 5;
                                continue;
                            }
                            catch (IOException e) {
                                this.logger.error("", (Throwable)e);
                            }
                        }
                    } else if ("2".equals(prize.getPrizeType())) {
                        for (int i = 0; i < 5; ++i) {
                            try {
                                Boolean rtnMap = this.oldWealthUtil.increaseWealth(customer.getCustomerId(), Integer.valueOf(prize.getPrizeData()), "\u65b0\u5e74\u5957\u88c5\u62bd\u5956\u8d60\u9001", "\u65b0\u5e74\u5957\u88c5\u62bd\u5956\u8d60\u9001");
                                if (!rtnMap.booleanValue()) continue;
                                i = 5;
                                continue;
                            }
                            catch (IOException e) {
                                this.logger.error("", (Throwable)e);
                            }
                        }
                    }
                    BaseJsonVo2.setValue((Object)entity.getPrizeId());
                }
            }
        }
        return BaseJsonVo2;
    }

    @Override
    public BaseJsonVo periodList(String luckyDrawId) {
        BaseJsonVo BaseJsonVo2 = new BaseJsonVo();
        List<Integer> periodList = this.jackpotMapper.findAllPeriod(luckyDrawId);
        if (periodList.size() > 0) {
            BaseJsonVo2.setValue(periodList);
        } else {
            BaseJsonVo2.setError("\u67e5\u65e0\u7ed3\u679c");
        }
        return BaseJsonVo2;
    }
}

