/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.service.sales;

import cc.lechun.active.service.sales.ActiveSaleBase;
import cc.lechun.active.service.sales.ActiveSaleHandle;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component(value="activeType_18")
public class NewProCrowdHandle
extends ActiveSaleBase
implements ActiveSaleHandle {
    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode) {
        List tt;
        BaseJsonVo baseJsonVo = this.canJoin(customerId, bindCode);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
        orderMainEntity.setCustomerId(customerId);
        orderMainEntity.setBindCode(bindCode);
        List<MallOrderMainEntity> list = this.orderMainInterface.getOrderMainList(orderMainEntity);
        if (list != null && list.size() >= 1 && (tt = list.stream().filter(c -> c.getStatus() >= 3 && c.getStatus() < 20).collect(Collectors.toList())) != null && tt.size() >= 1) {
            return BaseJsonVo.error((String)"\u5df2\u53c2\u4e0e\u8fc7\u6d3b\u52a8");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo checkCanJoin(String customerId, String bindCode, MallMainOrderVo mainOrderVo) {
        return this.checkCanJoin(customerId, bindCode);
    }

    @Override
    public BaseJsonVo afterCreateOrder(MallOrderCacheVo orderCacheVo, MallMainOrderVo mainOrderVo) {
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo afterPay(MallOrderMainEntity orderMain) {
        this.collectionActiveOrderData(orderMain);
        if (StringUtils.isNotEmpty((String)orderMain.getBindCode()) && orderMain.getBindCode().length() >= 32) {
            this.sendCoupon(orderMain.getCustomerId(), orderMain.getBindCode(), orderMain.getPlatformId());
        }
        this.updateOrderComplete(orderMain, OrderStatusEnum.COMPLETION.getName());
        this.logger.info("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5b8c\u6210," + orderMain.getOrderMainNo());
        return BaseJsonVo.success((Object)"");
    }
}

