/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.api;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.vo.ActiveCashticketVo;
import cc.lechun.cms.api.ActiveApi;
import cc.lechun.cms.dto.ActiveDTO;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.iservice.cashticket.CashticketBatchInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ActiveApiImpl
extends BaseService
implements ActiveApi {
    @Autowired
    private ActiveInterface activeService;
    @Autowired
    private ActiveCashticketInterface activeCashticketServcie;
    @Autowired
    private CashticketBatchInterface cashticketBatchInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private PlatFormInterface platFormInterface;

    public BaseJsonVo<List<ActiveDTO>> getActiveForOptionList() {
        List<ActiveEntity> list = this.activeService.getActiveForOption(1000);
        ArrayList result = new ArrayList();
        if (list != null && list.size() > 0) {
            list.forEach(activeEntity -> {
                ActiveDTO activeDTO = new ActiveDTO();
                BeanUtils.copyProperties((Object)activeEntity, (Object)activeDTO);
                result.add(activeDTO);
            });
            return BaseJsonVo.success(result);
        }
        return BaseJsonVo.success(new ArrayList());
    }

    public BaseJsonVo<ActiveDTO> getActiveByActiveNo(String activeNo) {
        ActiveEntity active = this.activeService.getActiveEntityByActiveNo(activeNo);
        if (active != null) {
            ActiveDTO activeDTO = new ActiveDTO();
            BeanUtils.copyProperties((Object)active, (Object)activeDTO);
            return BaseJsonVo.success((Object)activeDTO);
        }
        return BaseJsonVo.success((Object)new ActiveDTO());
    }

    public BaseJsonVo sendCash(String activeNo, String customerId, Integer platformId) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(activeNo);
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        BaseJsonVo baseJsonVo = this.activeService.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        if (StringUtils.isNotEmpty((String)customerId) && customerId.length() == 11) {
            CustomerEntity customerEntity = this.customerInterface.getCustomerByMobile(customerId, this.platFormInterface.getPlatFormGroupId(platformId));
            if (customerEntity != null) {
                customerId = customerEntity.getCustomerId();
            } else {
                this.logger.info("\u624b\u673a\u53f7{}\u7ed1\u5b9a\u7684\u7528\u6237\u4e3a\u7a7a,\u4f18\u60e0\u5238\u4e0d\u53d1\u653e", (Object)customerId);
            }
        }
        return this.activeCashticketServcie.sendTicket4Base(customerId, activeEntity.getBindCode(), "", platformId, true);
    }

    public BaseJsonVo setCashSendNum(String activeNo, Integer userTackCount) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(activeNo);
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        BaseJsonVo baseJsonVo = this.activeService.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        List<ActiveCashticketVo> list = this.activeCashticketServcie.getSelectCashticketByBindCode(activeEntity.getBindCode());
        if (list != null) {
            list.forEach(activeCashticketVo -> this.cashticketBatchInterface.setTakedNum(activeCashticketVo.getTicketBatchId(), userTackCount));
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f.");
    }

    public BaseJsonVo<ActiveDTO> getActiveEntityByQrcode(String bindCode) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        ActiveDTO dto = new ActiveDTO();
        BeanUtils.copyProperties((Object)activeEntity, (Object)dto);
        return BaseJsonVo.success((Object)dto);
    }
}

