/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.constants.trade;

import cc.lechun.common.enums.trade.OrderStatusEnum;
import java.util.Arrays;

public class OrderStatusClassConstants {
    public static int[] getStatusByStatusClass(int statusClass) {
        if (statusClass == 1) {
            return new int[]{OrderStatusEnum.UNPAY.getValue()};
        }
        if (statusClass == 2) {
            return new int[]{OrderStatusEnum.UNCONFIRM.getValue(), OrderStatusEnum.PAYCONFIRM.getValue(), OrderStatusEnum.COD_CONFIRM.getValue(), OrderStatusEnum.EXPORT.getValue(), OrderStatusEnum.PROCESS.getValue(), OrderStatusEnum.DELIVING.getValue(), OrderStatusEnum.COD_PAYCONFIRM.getValue()};
        }
        if (statusClass == 3) {
            return new int[]{OrderStatusEnum.PART_DELIVERED.getValue(), OrderStatusEnum.DELIVERED.getValue(), OrderStatusEnum.ARRIVED.getValue()};
        }
        if (statusClass == 4) {
            return new int[]{OrderStatusEnum.TRADE_EXCEPTION.getValue(), OrderStatusEnum.PART_COMPLETION.getValue(), OrderStatusEnum.COMPLETION.getValue()};
        }
        if (statusClass == 5) {
            return new int[]{OrderStatusEnum.RETURN_GOODS.getValue(), OrderStatusEnum.CHANGE_GOODS.getValue(), OrderStatusEnum.RETURN_PROCESS.getValue(), OrderStatusEnum.CHANGE_PROCESS.getValue(), OrderStatusEnum.REFUND_APPLY.getValue(), OrderStatusEnum.REFUND_PROCESS.getValue(), OrderStatusEnum.REFUNDED.getValue()};
        }
        if (statusClass == 6) {
            return new int[]{OrderStatusEnum.CANCEL.getValue()};
        }
        return new int[]{0};
    }

    public static int getStatusClassByStatus(int status) {
        for (int i = 1; i <= 6; ++i) {
            int[] s = OrderStatusClassConstants.getStatusByStatusClass(i);
            if (Arrays.binarySearch(s, status) <= -1) continue;
            return i;
        }
        return 0;
    }

    public static String getStatusClassName(int statusClass) {
        if (statusClass == 1) {
            return "\u5f85\u4ed8\u6b3e";
        }
        if (statusClass == 2) {
            return "\u5f85\u53d1\u8d27";
        }
        if (statusClass == 3) {
            return "\u5f85\u6536\u8d27";
        }
        if (statusClass == 4) {
            return "\u5f85\u8bc4\u4ef7";
        }
        if (statusClass == 5) {
            return "\u9000\u6b3e/\u552e\u540e";
        }
        if (statusClass == 6) {
            return "\u5df2\u53d6\u6d88";
        }
        if (statusClass == 7) {
            return "\u5df2\u8bc4\u4ef7";
        }
        return "\u5168\u90e8";
    }
}

